/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.axis.security;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPHeader;
import org.apache.axis.AxisFault;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.SOAPPart;
import org.apache.axis.message.SOAPHeaderElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.axis.security.handler.WSDoAllHandler;
import org.apache.ws.security.SOAPConstants;
import org.apache.ws.security.WSConstants;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.message.token.Timestamp;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class WSDoAllReceiver
extends WSDoAllHandler {
    protected static Log log = LogFactory.getLog((String)(class$org$apache$ws$axis$security$WSDoAllReceiver == null ? (class$org$apache$ws$axis$security$WSDoAllReceiver = WSDoAllReceiver.class$("org.apache.ws.axis.security.WSDoAllReceiver")) : class$org$apache$ws$axis$security$WSDoAllReceiver).getName());
    static /* synthetic */ Class class$org$apache$ws$axis$security$WSDoAllReceiver;

    public void invoke(MessageContext msgContext) throws AxisFault {
        doDebug = log.isDebugEnabled();
        if (doDebug) {
            log.debug((Object)("WSDoAllReceiver: enter invoke() with msg type: " + msgContext.getCurrentMessage().getMessageType()));
        }
        RequestData reqData = new RequestData();
        try {
            Timestamp timestamp;
            X509Certificate returnCert;
            reqData.setMsgContext(msgContext);
            Vector actions = new Vector();
            String action = null;
            action = (String)this.getOption("action");
            if (action == null) {
                action = (String)msgContext.getProperty("action");
            }
            if (action == null) {
                throw new AxisFault("WSDoAllReceiver: No action defined");
            }
            int doAction = WSSecurityUtil.decodeAction(action, actions);
            String actor = (String)this.getOption("actor");
            Message sm = msgContext.getCurrentMessage();
            Document doc = null;
            if (sm == null) {
                return;
            }
            try {
                doc = sm.getSOAPEnvelope().getAsDocument();
                if (doDebug) {
                    log.debug((Object)"Received SOAP request: ");
                    log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
                }
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiver: cannot convert into document", (Throwable)ex);
            }
            String msgType = sm.getMessageType();
            if (msgType != null && msgType.equals("response")) {
                SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants(doc.getDocumentElement());
                if (WSSecurityUtil.findElement(doc.getDocumentElement(), "Fault", soapConstants.getEnvelopeURI()) != null) {
                    return;
                }
            }
            CallbackHandler cbHandler = null;
            if ((doAction & 5) != 0) {
                cbHandler = this.getPasswordCB(reqData);
            }
            if ((doAction & 2) == 2) {
                this.decodeSignatureParameter2(reqData);
            }
            if ((doAction & 4) == 4) {
                this.decodeDecryptionParameter(reqData);
            }
            Vector wsResult = null;
            try {
                wsResult = secEngine.processSecurityHeader(doc, actor, cbHandler, reqData.getSigCrypto(), reqData.getDecCrypto());
            }
            catch (WSSecurityException ex) {
                ex.printStackTrace();
                throw new AxisFault("WSDoAllReceiver: security processing failed", (Throwable)ex);
            }
            if (wsResult == null) {
                if (doAction == 0) {
                    return;
                }
                throw new AxisFault("WSDoAllReceiver: Request does not contain required Security header");
            }
            ArrayList<QName> processedHeaders = new ArrayList<QName>();
            Iterator iterator = sm.getSOAPEnvelope().getHeaders().iterator();
            while (iterator.hasNext()) {
                SOAPHeaderElement tempHeader = (SOAPHeaderElement)iterator.next();
                if (!tempHeader.isProcessed()) continue;
                processedHeaders.add(tempHeader.getQName());
            }
            SOAPPart sPart = (SOAPPart)sm.getSOAPPart();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            org.apache.xml.security.utils.XMLUtils.outputDOM((Node)doc, (OutputStream)os, (boolean)true);
            sPart.setCurrentMessage((Object)os.toByteArray(), 4);
            if (doDebug) {
                log.debug((Object)"Processed received SOAP request");
                log.debug((Object)XMLUtils.PrettyDocumentToString((Document)doc));
            }
            iterator = processedHeaders.iterator();
            while (iterator.hasNext()) {
                QName qname = (QName)iterator.next();
                Enumeration headersByName = sm.getSOAPEnvelope().getHeadersByName(qname.getNamespaceURI(), qname.getLocalPart());
                while (headersByName.hasMoreElements()) {
                    SOAPHeaderElement tempHeader = (SOAPHeaderElement)headersByName.nextElement();
                    tempHeader.setProcessed(true);
                }
            }
            SOAPHeader sHeader = null;
            try {
                sHeader = sm.getSOAPEnvelope().getHeader();
            }
            catch (Exception ex) {
                throw new AxisFault("WSDoAllReceiver: cannot get SOAP header after security processing", (Throwable)ex);
            }
            Iterator headers = sHeader.examineHeaderElements(actor);
            SOAPHeaderElement headerElement = null;
            while (headers.hasNext()) {
                SOAPHeaderElement hE = (SOAPHeaderElement)headers.next();
                if (!hE.getLocalName().equals("Security") || !hE.getNamespaceURI().equals(WSConstants.WSSE_NS)) continue;
                headerElement = hE;
                break;
            }
            ((SOAPHeaderElement)headerElement).setProcessed(true);
            WSSecurityEngineResult actionResult = WSSecurityUtil.fetchActionResult(wsResult, 2);
            if (actionResult != null && (returnCert = actionResult.getCertificate()) != null && !this.verifyTrust(returnCert, reqData)) {
                throw new AxisFault("WSDoAllReceiver: The certificate used for the signature is not trusted");
            }
            actionResult = WSSecurityUtil.fetchActionResult(wsResult, 32);
            if (actionResult != null && (timestamp = actionResult.getTimestamp()) != null && !this.verifyTimestamp(timestamp, this.decodeTimeToLive(reqData))) {
                throw new AxisFault("WSDoAllReceiver: The timestamp could not be validated");
            }
            int resultActions = wsResult.size();
            int size = actions.size();
            if (size != resultActions) {
                throw new AxisFault("WSDoAllReceiver: security processing failed (actions number mismatch)");
            }
            for (int i = 0; i < size; ++i) {
                if (((Integer)actions.get(i)).intValue() == ((WSSecurityEngineResult)wsResult.get(i)).getAction()) continue;
                throw new AxisFault("WSDoAllReceiver: security processing failed (actions mismatch)");
            }
            Vector<WSHandlerResult> results = null;
            results = (Vector<WSHandlerResult>)msgContext.getProperty("RECV_RESULTS");
            if (results == null) {
                results = new Vector<WSHandlerResult>();
                msgContext.setProperty("RECV_RESULTS", results);
            }
            WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
            results.add(0, rResult);
            if (doDebug) {
                log.debug((Object)"WSDoAllReceiver: exit invoke()");
            }
        }
        catch (WSSecurityException e) {
            throw new AxisFault(e.getMessage(), (Throwable)e);
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

