/*
 * Decompiled with CFR 0.152.
 */
package org.glite.security.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import org.apache.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PasswordFinder;
import org.glite.security.util.Password;

public class PrivateKeyReader {
    static Logger logger = Logger.getLogger((String)PrivateKeyReader.class.getName());
    static final byte CARR = 13;
    static final byte NL = 10;
    static final int BUF_LEN = 1000;

    public static PrivateKey read(BufferedInputStream bin, PasswordFinder finder) throws Exception {
        try {
            String line;
            int num;
            byte[] b = new byte[1000];
            bin.mark(10000);
            bin.reset();
            bin.mark(10000);
            PEMReader pemReader = new PEMReader((Reader)new InputStreamReader(bin), finder, "BC");
            Object o = pemReader.readObject();
            logger.debug((Object)("read the keypair" + o));
            KeyPair pair = (KeyPair)o;
            PrivateKey privateKey = pair.getPrivate();
            logger.debug((Object)("the private key is " + privateKey));
            bin.reset();
            do {
                num = bin.read(b);
                line = new String(b);
                bin.reset();
                PrivateKeyReader.skipLine(bin);
                bin.mark(1000);
            } while (num > 0 && !line.startsWith("-----END"));
            bin.mark(10000);
            return privateKey;
        }
        catch (Exception e) {
            logger.error((Object)("Error while reading private key from a file. Exception: " + e.getClass().getName() + " message:" + e.getMessage()));
            throw e;
        }
    }

    public static PrivateKey read(BufferedInputStream bin) throws Exception {
        return PrivateKeyReader.read(bin, (PasswordFinder)null);
    }

    public static PrivateKey read(BufferedInputStream bin, String passwd) throws Exception {
        if (passwd == null) {
            return PrivateKeyReader.read(bin, (PasswordFinder)null);
        }
        return PrivateKeyReader.read(bin, new Password(passwd.toCharArray()));
    }

    public static void skipLine(BufferedInputStream stream) throws IOException {
        byte[] b = new byte[1000];
        stream.mark(1002);
        int num = 0;
        while (stream.available() > 0) {
            int i;
            num = stream.read(b);
            for (i = 0; i < num && b[i] != 13 && b[i] != 10; ++i) {
            }
            stream.reset();
            if (b[i] == 13 || b[i] == 10) {
                stream.skip(i);
                stream.mark(1002);
                break;
            }
            stream.skip(1000L);
            stream.mark(1002);
        }
        num = stream.read(b);
        if (b[0] != 13 && b[0] != 10) {
            logger.error((Object)"No newline char found when trying to skip line");
            throw new IOException("No newline char found when trying to skip line");
        }
        stream.reset();
        if (b[1] == 13 || b[1] == 10 && b[0] != b[1]) {
            stream.skip(2L);
        } else {
            stream.skip(1L);
        }
        stream.mark(1002);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

