/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vremanagement.deployer.impl.operators.ant;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.gcube.common.vremanagement.deployer.impl.operators.ant.AntInterfaceException;

public class AntRunner {
    private Project project;
    protected Log logger = LogFactory.getLog((String)this.getClass().getName());

    public AntRunner() {
        this.project = new Project();
    }

    public void init(String _buildFile, String _baseDir) throws AntInterfaceException {
        try {
            this.project.init();
        }
        catch (BuildException e) {
            throw new AntInterfaceException("The default task list could not be loaded.");
        }
        this.logger.trace((Object)"initializing the Ant project... ");
        this.logger.trace((Object)("base dir = " + _baseDir));
        if (_baseDir == null) {
            _baseDir = new String(".");
        }
        try {
            this.project.setBasedir(_baseDir);
        }
        catch (BuildException e) {
            throw new AntInterfaceException("The given basedir doesn't exist, or isn't a directory.");
        }
        this.logger.trace((Object)("build file = " + _buildFile));
        if (_buildFile == null) {
            _buildFile = new String("build.xml");
        }
        try {
            ProjectHelper.getProjectHelper().parse(this.project, (Object)new File(_buildFile));
        }
        catch (BuildException e) {
            e.printStackTrace(System.err);
            throw new AntInterfaceException("Configuration file " + _buildFile + " is invalid, or cannot be read.");
        }
    }

    public void setProperties(Map _properties, boolean _overridable) throws AntInterfaceException {
        if (this.project == null) {
            throw new AntInterfaceException("Properties cannot be set because the project has not been initialized. Please call the 'init' method first !");
        }
        if (_properties == null) {
            throw new AntInterfaceException("The provided property map is null.");
        }
        Set propertyNames = _properties.keySet();
        for (String propertyName : propertyNames) {
            String propertyValue = (String)_properties.get(propertyName);
            if (propertyValue == null) continue;
            this.logger.trace((Object)("property " + propertyName + " = " + propertyValue));
            if (_overridable) {
                this.project.setProperty(propertyName, propertyValue);
                continue;
            }
            this.project.setUserProperty(propertyName, propertyValue);
        }
    }

    public void runTarget(String _target) throws AntInterfaceException {
        if (this.project == null) {
            throw new AntInterfaceException("No target can be launched because the project has not been initialized. Please call the 'init' method first !");
        }
        if (_target == null) {
            _target = this.project.getDefaultTarget();
        }
        try {
            this.project.executeTarget(_target);
        }
        catch (BuildException e) {
            throw new AntInterfaceException(e.getMessage());
        }
    }

    public void runScript() throws AntInterfaceException {
        this.runTarget("runScript");
    }
}

