/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.informationsystem.notification.impl.client;

import java.io.StringReader;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.axis.message.MessageElement;
import org.apache.axis.message.addressing.EndpointReferenceType;
import org.gcube.common.core.informationsystem.notifier.ISNotifier;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.events.GCUBEEvent;
import org.gcube.common.core.utils.events.GCUBETopic;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.informationsystem.notification.impl.client.NoNotificationMessageException;
import org.gcube.common.informationsystem.notification.impl.client.NotificationBroker;
import org.globus.wsrf.encoding.DeserializationException;
import org.globus.wsrf.encoding.ObjectDeserializer;
import org.oasis.wsn.GetCurrentMessage;
import org.oasis.wsn.GetCurrentMessageResponse;
import org.oasis.wsn.TopicExpressionType;
import org.oasis.wsn.WSBaseNotificationServiceAddressingLocator;
import org.oasis.wsrf.properties.ResourcePropertyValueChangeNotificationType;
import org.xml.sax.InputSource;

class ReNotifier
implements Runnable {
    protected static final GCUBELog log = new GCUBELog(ReNotifier.class);
    private ISNotifier.GCUBENotificationTopic topic;
    private NotificationBroker broker;
    private GCUBEScope scope;
    private EndpointReferenceType epr;

    public ReNotifier(ISNotifier.GCUBENotificationTopic gCUBENotificationTopic, EndpointReferenceType endpointReferenceType, GCUBEScope gCUBEScope, NotificationBroker notificationBroker) {
        this.topic = gCUBENotificationTopic;
        this.epr = endpointReferenceType;
        this.scope = gCUBEScope;
        this.broker = notificationBroker;
    }

    public void run() {
        log.trace((Object)("About to retrieve past messages about " + this.topic.getTopicQName() + " from " + this.epr.getAddress()));
        try {
            Object object;
            MessageElement[] messageElementArray;
            TopicExpressionType topicExpressionType = new TopicExpressionType();
            topicExpressionType.setDialect("http://docs.oasis-open.org/wsn/2004/06/TopicExpression/Simple");
            topicExpressionType.setValue((Object)this.topic.getTopicQName());
            GetCurrentMessage getCurrentMessage = new GetCurrentMessage(topicExpressionType);
            GetCurrentMessageResponse getCurrentMessageResponse = null;
            try {
                messageElementArray = new WSBaseNotificationServiceAddressingLocator();
                object = messageElementArray.getNotificationProducerPort(this.epr);
                getCurrentMessageResponse = object.getCurrentMessage(getCurrentMessage);
            }
            catch (Exception exception) {
                log.error((Object)("Error while invoking getLastMessage() on " + this.epr.getAddress() + "; removing producer from list. "), (Throwable)exception);
                return;
            }
            if (getCurrentMessageResponse == null) {
                throw new NoNotificationMessageException("no past notification for the topic: " + this.topic);
            }
            messageElementArray = getCurrentMessageResponse.get_any();
            if (messageElementArray == null) {
                throw new NoNotificationMessageException("no past notfication for the topic: " + this.topic.getTopicQName());
            }
            log.trace((Object)"the mesage Element is retrieved");
            object = messageElementArray[0].getAsString();
            try {
                XPath xPath;
                log.trace((Object)"starting renotification");
                InputSource inputSource = new InputSource(new StringReader((String)object));
                ResourcePropertyValueChangeNotificationType resourcePropertyValueChangeNotificationType = (ResourcePropertyValueChangeNotificationType)ObjectDeserializer.deserialize((InputSource)inputSource, ResourcePropertyValueChangeNotificationType.class);
                log.trace((Object)"message deserialized");
                MessageElement[] messageElementArray2 = resourcePropertyValueChangeNotificationType.getNewValue().get_any();
                if (this.topic.getPrecondition() != null && !((Boolean)(xPath = XPathFactory.newInstance().newXPath()).evaluate(this.topic.getPrecondition(), new InputSource(new StringReader(messageElementArray2[0].getAsString())), XPathConstants.BOOLEAN)).booleanValue()) {
                    throw new NoNotificationMessageException("no past notfication for the topic: " + this.topic.getTopicQName() + " with precondition " + this.topic.getPrecondition());
                }
                log.trace((Object)"preparing the event");
                xPath = new ISNotifier.NotificationEvent(new ISNotifier.NotificationMessage(this.topic.getTopicQName(), messageElementArray2, this.epr));
                this.broker.producer.notify((GCUBETopic)ISNotifier.NotificationTopic.NOTIFICATIONRECEIVED, new GCUBEEvent[]{xPath});
            }
            catch (DeserializationException deserializationException) {
                XPath xPath;
                log.info((Object)"Re-notifying Generic Notfication");
                if (this.topic.getPrecondition() != null && !((Boolean)(xPath = XPathFactory.newInstance().newXPath()).evaluate(this.topic.getPrecondition(), new InputSource(new StringReader(messageElementArray[0].getAsString())), XPathConstants.BOOLEAN)).booleanValue()) {
                    throw new NoNotificationMessageException("no past notfication for the topic: " + this.topic.getTopicQName() + " with precondition " + this.topic.getPrecondition());
                }
                xPath = new ISNotifier.NotificationEvent(new ISNotifier.NotificationMessage(this.topic.getTopicQName(), (Object)messageElementArray[0], this.epr));
                this.broker.producer.notify((GCUBETopic)ISNotifier.NotificationTopic.NOTIFICATIONRECEIVED, new GCUBEEvent[]{xPath});
            }
        }
        catch (NoNotificationMessageException noNotificationMessageException) {
            log.warn((Object)"no message found ", (Throwable)noNotificationMessageException);
        }
        catch (Exception exception) {
            log.error((Object)("Error while trying to retrieve last message from " + this.epr.getAddress() + " about " + this.topic), (Throwable)exception);
        }
    }
}

