/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts.config;

import java.io.InputStream;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import org.apache.commons.digester.Digester;
import org.apache.portals.bridges.struts.config.PortletURLTypes;
import org.apache.portals.bridges.struts.config.RenderContextAttributes;

public class StrutsPortletConfig {
    private RenderContextAttributes renderContextAttributes;
    private PortletURLTypes portletURLTypes;

    public void loadConfig(PortletContext portletContext, String config) throws PortletException {
        this.renderContextAttributes = new RenderContextAttributes();
        this.portletURLTypes = new PortletURLTypes();
        InputStream input = portletContext.getResourceAsStream(config);
        if (input == null) {
            return;
        }
        Digester digester = new Digester();
        digester.setClassLoader(Thread.currentThread().getContextClassLoader());
        this.renderContextAttributes.configure(digester);
        this.portletURLTypes.configure(digester);
        try {
            digester.parse(input);
        }
        catch (Exception e) {
            throw new PortletException("Error loading StrutsPortlet config " + config + ": " + e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                input.close();
            }
            catch (Exception e) {}
        }
    }

    public RenderContextAttributes getRenderContextAttributes() {
        return this.renderContextAttributes;
    }

    public PortletURLTypes getPortletURLTypes() {
        return this.portletURLTypes;
    }
}

