/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.testing.async;

import java.util.concurrent.TimeoutException;
import org.hibernate.testing.async.Executable;
import org.hibernate.testing.async.ExecutableAdapter;

public class TimedExecutor {
    private final long timeOut;
    private final int checkMilliSeconds;

    public TimedExecutor(long timeOut) {
        this(timeOut, 1000);
    }

    public TimedExecutor(long timeOut, int checkMilliSeconds) {
        this.timeOut = timeOut;
        this.checkMilliSeconds = checkMilliSeconds;
    }

    public void execute(Executable executable) throws TimeoutException {
        ExecutableAdapter adapter = new ExecutableAdapter(executable);
        Thread separateThread = new Thread(adapter);
        separateThread.start();
        int runningTime = 0;
        do {
            if ((long)runningTime > this.timeOut) {
                try {
                    executable.timedOut();
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw new TimeoutException();
            }
            try {
                Thread.sleep(this.checkMilliSeconds);
                runningTime += this.checkMilliSeconds;
            }
            catch (InterruptedException ignore) {
                // empty catch block
            }
        } while (!adapter.isDone());
        adapter.reThrowAnyErrors();
    }
}

