/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.calendar.service.permission;

import com.liferay.calendar.model.Calendar;
import com.liferay.calendar.service.CalendarLocalServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.security.auth.PrincipalException;
import com.liferay.portal.security.permission.PermissionChecker;

public class CalendarPermission {
    public static void check(PermissionChecker permissionChecker, Calendar calendar, String actionId) throws PortalException {
        if (!CalendarPermission.contains(permissionChecker, calendar, actionId)) {
            throw new PrincipalException();
        }
    }

    public static void check(PermissionChecker permissionChecker, long calendarId, String actionId) throws PortalException, SystemException {
        if (!CalendarPermission.contains(permissionChecker, calendarId, actionId)) {
            throw new PrincipalException();
        }
    }

    public static boolean contains(PermissionChecker permissionChecker, Calendar calendar, String actionId) {
        if (permissionChecker.hasOwnerPermission(calendar.getCompanyId(), Calendar.class.getName(), calendar.getCalendarId(), calendar.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(calendar.getGroupId(), Calendar.class.getName(), calendar.getCalendarId(), actionId);
    }

    public static boolean contains(PermissionChecker permissionChecker, long calendarId, String actionId) throws PortalException, SystemException {
        Calendar calendar = CalendarLocalServiceUtil.getCalendar(calendarId);
        return CalendarPermission.contains(permissionChecker, calendar, actionId);
    }
}

