/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.result;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import org.hsqldb.ColumnBase;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.SqlInvariants;
import org.hsqldb.Statement;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.DataOutputStream;
import org.hsqldb.navigator.RowSetNavigator;
import org.hsqldb.navigator.RowSetNavigatorClient;
import org.hsqldb.result.ResultLob;
import org.hsqldb.result.ResultMetaData;
import org.hsqldb.result.ResultProperties;
import org.hsqldb.rowio.RowInputBinary;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class Result {
    public static final ResultMetaData sessionAttributesMetaData = ResultMetaData.newResultMetaData(4);
    private static final ResultMetaData emptyMeta;
    public static final Result emptyGeneratedResult;
    public static final Result updateZeroResult;
    public static final Result updateOneResult;
    public byte mode;
    int databaseID;
    long sessionID;
    private long id;
    private String databaseName;
    private String mainString;
    private String subString;
    private String zoneString;
    int errorCode;
    private HsqlException exception;
    long statementID;
    int statementReturnType;
    public int updateCount;
    private int fetchSize;
    private Result chainedResult;
    private int lobCount;
    ResultLob lobResults;
    public ResultMetaData metaData;
    public ResultMetaData parameterMetaData;
    public ResultMetaData generatedMetaData;
    public int rsProperties;
    public int queryTimeout;
    int generateKeys;
    public Object valueData;
    public Statement statement;
    public RowSetNavigator navigator;

    Result(int mode) {
        this.mode = (byte)mode;
    }

    public Result(int mode, int count) {
        this.mode = (byte)mode;
        this.updateCount = count;
    }

    public static Result newResult(RowSetNavigator nav) {
        Result result = new Result(3);
        result.navigator = nav;
        return result;
    }

    public static Result newResult(int type) {
        RowSetNavigatorClient navigator = null;
        Result result = null;
        switch (type) {
            case 35: 
            case 41: 
            case 43: {
                break;
            }
            case 8: 
            case 9: {
                navigator = new RowSetNavigatorClient(4);
                break;
            }
            case 6: 
            case 17: {
                navigator = new RowSetNavigatorClient(1);
                break;
            }
            case 16: {
                navigator = new RowSetNavigatorClient(4);
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 20: {
                break;
            }
            case 18: {
                throw Error.runtimeError(201, "Result");
            }
        }
        result = new Result(type);
        result.navigator = navigator;
        return result;
    }

    public static Result newResult(DataInput dataInput, RowInputBinary in) throws IOException, HsqlException {
        return Result.newResult(null, dataInput.readByte(), dataInput, in);
    }

    public static Result newResult(Session session, int mode, DataInput dataInput, RowInputBinary in) throws IOException, HsqlException {
        try {
            if (mode == 18) {
                return ResultLob.newLob(dataInput, false);
            }
            Result result = Result.newResult(session, dataInput, in, mode);
            return result;
        }
        catch (IOException e) {
            throw Error.error(1300);
        }
    }

    public void readAdditionalResults(SessionInterface session, DataInputStream inputStream, RowInputBinary in) throws IOException, HsqlException {
        Result currentResult = this;
        this.setSession(session);
        byte addedResultMode;
        while ((addedResultMode = inputStream.readByte()) != 0) {
            currentResult = Result.newResult(null, inputStream, in, addedResultMode);
            this.addChainedResult(currentResult);
        }
        return;
    }

    public void readLobResults(SessionInterface session, DataInputStream inputStream, RowInputBinary in) throws IOException, HsqlException {
        byte addedResultMode;
        Result currentResult = this;
        boolean hasLob = false;
        this.setSession(session);
        while ((addedResultMode = inputStream.readByte()) == 18) {
            ResultLob resultLob = ResultLob.newLob(inputStream, false);
            if (session instanceof Session) {
                ((Session)session).allocateResultLob(resultLob, inputStream);
            } else {
                currentResult.addLobResult(resultLob);
            }
            hasLob = true;
        }
        if (addedResultMode != 0) {
            throw Error.runtimeError(201, "Result");
        }
        if (hasLob) {
            ((Session)session).registerResultLobs(currentResult);
        }
    }

    private static Result newResult(Session session, DataInput dataInput, RowInputBinary in, int mode) throws IOException, HsqlException {
        Result result = Result.newResult(mode);
        int length = dataInput.readInt();
        in.resetRow(0, length);
        byte[] byteArray = in.getBuffer();
        int offset = 4;
        dataInput.readFully(byteArray, 4, length - 4);
        block0 : switch (mode) {
            case 7: {
                result.statementReturnType = in.readByte();
                break;
            }
            case 10: 
            case 32: 
            case 39: {
                break;
            }
            case 37: {
                result.setStatementType(in.readByte());
                result.mainString = in.readString();
                result.rsProperties = in.readByte();
                result.generateKeys = in.readByte();
                if (result.generateKeys != 11 && result.generateKeys != 21) break;
                result.generatedMetaData = new ResultMetaData(in);
                break;
            }
            case 40: {
                result.id = in.readLong();
                break;
            }
            case 36: {
                result.statementID = in.readLong();
                break;
            }
            case 34: {
                result.updateCount = in.readInt();
                result.fetchSize = in.readInt();
                result.statementReturnType = in.readByte();
                result.mainString = in.readString();
                result.rsProperties = in.readByte();
                result.queryTimeout = in.readShort();
                result.generateKeys = in.readByte();
                if (result.generateKeys != 11 && result.generateKeys != 21) break;
                result.generatedMetaData = new ResultMetaData(in);
                break;
            }
            case 31: {
                result.databaseName = in.readString();
                result.mainString = in.readString();
                result.subString = in.readString();
                result.zoneString = in.readString();
                result.updateCount = in.readInt();
                break;
            }
            case 2: 
            case 19: {
                result.mainString = in.readString();
                result.subString = in.readString();
                result.errorCode = in.readInt();
                break;
            }
            case 11: {
                result.databaseID = in.readInt();
                result.sessionID = in.readLong();
                result.databaseName = in.readString();
                result.mainString = in.readString();
                break;
            }
            case 1: {
                result.updateCount = in.readInt();
                break;
            }
            case 33: {
                int type = in.readInt();
                result.setActionType(type);
                switch (type) {
                    case 2: 
                    case 4: {
                        result.mainString = in.readString();
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: {
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 38: {
                int type = in.readInt();
                result.setConnectionAttrType(type);
                switch (type) {
                    case 10027: {
                        result.mainString = in.readString();
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 4: {
                result.statementReturnType = in.readByte();
                result.statementID = in.readLong();
                result.rsProperties = in.readByte();
                result.metaData = new ResultMetaData(in);
                result.parameterMetaData = new ResultMetaData(in);
                break;
            }
            case 43: {
                result.updateCount = in.readInt();
                result.fetchSize = in.readInt();
                result.statementID = in.readLong();
                result.statementReturnType = in.readByte();
                result.rsProperties = in.readByte();
                result.metaData = new ResultMetaData(in);
                result.valueData = Result.readSimple(in, result.metaData);
                break;
            }
            case 35: {
                result.updateCount = in.readInt();
                result.fetchSize = in.readInt();
                result.statementID = in.readLong();
                result.rsProperties = in.readByte();
                result.queryTimeout = in.readShort();
                Statement statement = session.statementManager.getStatement(session, result.statementID);
                if (statement == null) {
                    result.mode = (byte)21;
                    result.valueData = ValuePool.emptyObjectArray;
                    break;
                }
                result.statement = statement;
                result.metaData = result.statement.getParametersMetaData();
                result.valueData = Result.readSimple(in, result.metaData);
                break;
            }
            case 41: {
                result.id = in.readLong();
                int type = in.readInt();
                result.setActionType(type);
                result.metaData = new ResultMetaData(in);
                result.valueData = Result.readSimple(in, result.metaData);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 16: {
                result.updateCount = in.readInt();
                result.fetchSize = in.readInt();
                result.statementID = in.readLong();
                result.queryTimeout = in.readShort();
                result.metaData = new ResultMetaData(in);
                result.navigator.readSimple(in, result.metaData);
                break;
            }
            case 17: {
                result.metaData = new ResultMetaData(in);
                result.navigator.read(in, result.metaData);
                break;
            }
            case 13: {
                result.id = in.readLong();
                result.updateCount = in.readInt();
                result.fetchSize = in.readInt();
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                result.id = in.readLong();
                result.updateCount = in.readInt();
                result.fetchSize = in.readInt();
                result.rsProperties = in.readByte();
                result.metaData = new ResultMetaData(in);
                result.navigator = new RowSetNavigatorClient();
                result.navigator.read(in, result.metaData);
                break;
            }
            case 14: {
                result.metaData = new ResultMetaData(in);
                result.navigator = new RowSetNavigatorClient();
                result.navigator.read(in, result.metaData);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Result");
            }
        }
        return result;
    }

    public static Result newPSMResult(int type, String label, Object value) {
        Result result = Result.newResult(42);
        result.errorCode = type;
        result.mainString = label;
        result.valueData = value;
        return result;
    }

    public static Result newPSMResult(Object value) {
        Result result = Result.newResult(42);
        result.valueData = value;
        return result;
    }

    public static Result newPrepareStatementRequest() {
        return Result.newResult(37);
    }

    public static Result newPreparedExecuteRequest(Type[] types, long statementId) {
        Result result = Result.newResult(35);
        result.metaData = ResultMetaData.newSimpleResultMetaData(types);
        result.statementID = statementId;
        result.valueData = ValuePool.emptyObjectArray;
        return result;
    }

    public static Result newCallResponse(Type[] types, long statementId, Object[] values) {
        Result result = Result.newResult(43);
        result.metaData = ResultMetaData.newSimpleResultMetaData(types);
        result.statementID = statementId;
        result.valueData = values;
        return result;
    }

    public static Result newUpdateResultRequest(Type[] types, long id) {
        Result result = Result.newResult(41);
        result.metaData = ResultMetaData.newUpdateResultMetaData(types);
        result.id = id;
        result.valueData = new Object[0];
        return result;
    }

    public void setPreparedResultUpdateProperties(Object[] parameterValues) {
        this.valueData = parameterValues;
    }

    public void setPreparedExecuteProperties(Object[] parameterValues, int maxRows, int fetchSize, int resultProps) {
        this.mode = (byte)35;
        this.valueData = parameterValues;
        this.updateCount = maxRows;
        this.fetchSize = fetchSize;
        this.rsProperties = resultProps;
    }

    public void setBatchedPreparedExecuteRequest() {
        this.mode = (byte)9;
        if (this.navigator == null) {
            this.navigator = new RowSetNavigatorClient(4);
        } else {
            ((RowSetNavigatorClient)this.navigator).clear();
        }
        this.updateCount = 0;
        this.fetchSize = 0;
    }

    public void addBatchedPreparedExecuteRequest(Object[] parameterValues) {
        ((RowSetNavigatorClient)this.navigator).add(parameterValues);
    }

    public static Result newBatchedExecuteRequest() {
        Type[] types = new Type[]{Type.SQL_VARCHAR};
        Result result = Result.newResult(8);
        result.metaData = ResultMetaData.newSimpleResultMetaData(types);
        return result;
    }

    public static Result newBatchedExecuteResponse(int[] updateCounts, Result generatedResult, Result e) {
        Result result = Result.newResult(16);
        result.addChainedResult(generatedResult);
        result.addChainedResult(e);
        Type[] types = new Type[]{Type.SQL_INTEGER};
        result.metaData = ResultMetaData.newSimpleResultMetaData(types);
        Object[][] table = new Object[updateCounts.length][];
        for (int i = 0; i < updateCounts.length; ++i) {
            table[i] = new Object[]{ValuePool.getInt(updateCounts[i])};
        }
        ((RowSetNavigatorClient)result.navigator).setData(table);
        return result;
    }

    public static Result newResetSessionRequest() {
        Result result = Result.newResult(10);
        return result;
    }

    public static Result newConnectionAttemptRequest(String user, String password, String database, String zoneString, int timeZoneSeconds) {
        Result result = Result.newResult(31);
        result.mainString = user;
        result.subString = password;
        result.zoneString = zoneString;
        result.databaseName = database;
        result.updateCount = timeZoneSeconds;
        return result;
    }

    public static Result newConnectionAcknowledgeResponse(Database database, long sessionID, int databaseID) {
        Result result = Result.newResult(11);
        result.sessionID = sessionID;
        result.databaseID = databaseID;
        result.databaseName = database.getUniqueName();
        result.mainString = database.getProperties().getClientPropertiesAsString();
        return result;
    }

    public static Result newUpdateZeroResult() {
        return new Result(1, 0);
    }

    public static Result newUpdateCountResult(int count) {
        return new Result(1, count);
    }

    public static Result newUpdateCountResult(ResultMetaData meta, int count) {
        Result result = Result.newResult(1);
        Result dataResult = Result.newGeneratedDataResult(meta);
        result.updateCount = count;
        result.addChainedResult(dataResult);
        return result;
    }

    public static Result newSingleColumnResult(ResultMetaData meta) {
        Result result = Result.newResult(3);
        result.metaData = meta;
        result.navigator = new RowSetNavigatorClient();
        return result;
    }

    public static Result newSingleColumnResult(String colName, Type type) {
        Result result = Result.newResult(3);
        result.metaData = ResultMetaData.newResultMetaData(1);
        result.metaData.columns[0] = new ColumnBase(null, null, null, colName);
        result.metaData.columns[0].setType(type);
        result.metaData.prepareData();
        result.navigator = new RowSetNavigatorClient(8);
        return result;
    }

    public static Result newSingleColumnStringResult(String colName, String contents) {
        Result result = Result.newSingleColumnResult("OPERATION", Type.SQL_VARCHAR);
        LineNumberReader lnr = new LineNumberReader(new StringReader(contents));
        while (true) {
            String line = null;
            try {
                line = lnr.readLine();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (line == null) break;
            result.getNavigator().add(new Object[]{line});
        }
        return result;
    }

    public static Result newPrepareResponse(Statement statement) {
        Result r = Result.newResult(4);
        r.statement = statement;
        r.statementID = statement.getID();
        int csType = statement.getType();
        r.statementReturnType = statement.getStatementReturnType();
        r.metaData = statement.getResultMetaData();
        r.parameterMetaData = statement.getParametersMetaData();
        return r;
    }

    public static Result newFreeStmtRequest(long statementID) {
        Result r = Result.newResult(36);
        r.statementID = statementID;
        return r;
    }

    public static Result newExecuteDirectRequest() {
        return Result.newResult(34);
    }

    public void setPrepareOrExecuteProperties(String sql, int maxRows, int fetchSize, int statementReturnType, int timeout, int resultSetProperties, int keyMode, int[] generatedIndexes, String[] generatedNames) {
        this.mainString = sql;
        this.updateCount = maxRows;
        this.fetchSize = fetchSize;
        this.statementReturnType = statementReturnType;
        this.queryTimeout = timeout;
        this.rsProperties = resultSetProperties;
        this.generateKeys = keyMode;
        this.generatedMetaData = ResultMetaData.newGeneratedColumnsMetaData(generatedIndexes, generatedNames);
    }

    public static Result newSetSavepointRequest(String name) {
        Result result = Result.newResult(38);
        result.setConnectionAttrType(10027);
        result.setMainString(name);
        return result;
    }

    public static Result newRequestDataResult(long id, int offset, int count) {
        Result result = Result.newResult(13);
        result.id = id;
        result.updateCount = offset;
        result.fetchSize = count;
        return result;
    }

    public static Result newDataResult(ResultMetaData md) {
        Result result = Result.newResult(3);
        result.navigator = new RowSetNavigatorClient();
        result.metaData = md;
        return result;
    }

    public static Result newGeneratedDataResult(ResultMetaData md) {
        Result result = Result.newResult(20);
        result.navigator = new RowSetNavigatorClient();
        result.metaData = md;
        return result;
    }

    public int getExecuteProperties() {
        return this.rsProperties;
    }

    public void setDataResultProperties(int maxRows, int fetchSize, int resultSetScrollability, int resultSetConcurrency, int resultSetHoldability) {
        this.updateCount = maxRows;
        this.fetchSize = fetchSize;
        this.rsProperties = ResultProperties.getValueForJDBC(resultSetScrollability, resultSetConcurrency, resultSetHoldability);
    }

    public static Result newDataHeadResult(SessionInterface session, Result source, int offset, int count) {
        if (offset + count > source.navigator.getSize()) {
            count = source.navigator.getSize() - offset;
        }
        Result result = Result.newResult(15);
        result.metaData = source.metaData;
        result.navigator = new RowSetNavigatorClient(source.navigator, offset, count);
        result.navigator.setId(source.navigator.getId());
        result.setSession(session);
        result.rsProperties = source.rsProperties;
        result.fetchSize = source.fetchSize;
        return result;
    }

    public static Result newDataRowsResult(Result source, int offset, int count) {
        if (offset + count > source.navigator.getSize()) {
            count = source.navigator.getSize() - offset;
        }
        Result result = Result.newResult(14);
        result.id = source.id;
        result.metaData = source.metaData;
        result.navigator = new RowSetNavigatorClient(source.navigator, offset, count);
        return result;
    }

    public static Result newDataRowsResult(RowSetNavigator navigator) {
        Result result = Result.newResult(14);
        result.navigator = navigator;
        return result;
    }

    public static Result newSessionAttributesResult() {
        Result result = Result.newResult(3);
        result.navigator = new RowSetNavigatorClient(1);
        result.metaData = sessionAttributesMetaData;
        result.navigator.add(new Object[4]);
        return result;
    }

    public static Result newWarningResult(HsqlException w) {
        Result result = Result.newResult(19);
        result.mainString = w.getMessage();
        result.subString = w.getSQLState();
        result.errorCode = w.getErrorCode();
        return result;
    }

    public static Result newErrorResult(Throwable t) {
        return Result.newErrorResult(t, null);
    }

    public static Result newErrorResult(Throwable t, String statement) {
        Result result = Result.newResult(2);
        if (t instanceof HsqlException) {
            result.exception = (HsqlException)t;
            result.mainString = result.exception.getMessage();
            result.subString = result.exception.getSQLState();
            if (statement != null) {
                result.mainString = result.mainString + " in statement [" + statement + "]";
            }
            result.errorCode = result.exception.getErrorCode();
        } else if (t instanceof OutOfMemoryError) {
            System.gc();
            result.exception = Error.error(460, t);
            result.mainString = result.exception.getMessage();
            result.subString = result.exception.getSQLState();
            result.errorCode = result.exception.getErrorCode();
        } else {
            result.exception = Error.error(458, t);
            result.mainString = result.exception.getMessage() + " " + t.toString();
            result.subString = result.exception.getSQLState();
            result.errorCode = result.exception.getErrorCode();
            if (statement != null) {
                result.mainString = result.mainString + " in statement [" + statement + "]";
            }
        }
        return result;
    }

    public void write(SessionInterface session, DataOutputStream dataOut, RowOutputInterface rowOut) throws IOException, HsqlException {
        rowOut.reset();
        rowOut.writeByte(this.mode);
        int startPos = rowOut.size();
        rowOut.writeSize(0);
        block0 : switch (this.mode) {
            case 7: {
                rowOut.writeByte(this.statementReturnType);
                break;
            }
            case 10: 
            case 32: 
            case 39: {
                break;
            }
            case 37: {
                rowOut.writeByte(this.statementReturnType);
                rowOut.writeString(this.mainString);
                rowOut.writeByte(this.rsProperties);
                rowOut.writeByte(this.generateKeys);
                if (this.generateKeys != 11 && this.generateKeys != 21) break;
                this.generatedMetaData.write(rowOut);
                break;
            }
            case 36: {
                rowOut.writeLong(this.statementID);
                break;
            }
            case 40: {
                rowOut.writeLong(this.id);
                break;
            }
            case 34: {
                rowOut.writeInt(this.updateCount);
                rowOut.writeInt(this.fetchSize);
                rowOut.writeByte(this.statementReturnType);
                rowOut.writeString(this.mainString);
                rowOut.writeByte(this.rsProperties);
                rowOut.writeShort(this.queryTimeout);
                rowOut.writeByte(this.generateKeys);
                if (this.generateKeys != 11 && this.generateKeys != 21) break;
                this.generatedMetaData.write(rowOut);
                break;
            }
            case 31: {
                rowOut.writeString(this.databaseName);
                rowOut.writeString(this.mainString);
                rowOut.writeString(this.subString);
                rowOut.writeString(this.zoneString);
                rowOut.writeInt(this.updateCount);
                break;
            }
            case 2: 
            case 19: {
                rowOut.writeString(this.mainString);
                rowOut.writeString(this.subString);
                rowOut.writeInt(this.errorCode);
                break;
            }
            case 11: {
                rowOut.writeInt(this.databaseID);
                rowOut.writeLong(this.sessionID);
                rowOut.writeString(this.databaseName);
                rowOut.writeString(this.mainString);
                break;
            }
            case 1: {
                rowOut.writeInt(this.updateCount);
                break;
            }
            case 33: {
                int type = this.getActionType();
                rowOut.writeInt(type);
                switch (type) {
                    case 2: 
                    case 4: {
                        rowOut.writeString(this.mainString);
                        break block0;
                    }
                    case 0: 
                    case 1: 
                    case 6: 
                    case 7: {
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 4: {
                rowOut.writeByte(this.statementReturnType);
                rowOut.writeLong(this.statementID);
                rowOut.writeByte(this.rsProperties);
                this.metaData.write(rowOut);
                this.parameterMetaData.write(rowOut);
                break;
            }
            case 43: {
                rowOut.writeInt(this.updateCount);
                rowOut.writeInt(this.fetchSize);
                rowOut.writeLong(this.statementID);
                rowOut.writeByte(this.statementReturnType);
                rowOut.writeByte(this.rsProperties);
                this.metaData.write(rowOut);
                Result.writeSimple(rowOut, this.metaData, (Object[])this.valueData);
                break;
            }
            case 35: {
                rowOut.writeInt(this.updateCount);
                rowOut.writeInt(this.fetchSize);
                rowOut.writeLong(this.statementID);
                rowOut.writeByte(this.rsProperties);
                rowOut.writeShort(this.queryTimeout);
                Result.writeSimple(rowOut, this.metaData, (Object[])this.valueData);
                break;
            }
            case 41: {
                rowOut.writeLong(this.id);
                rowOut.writeInt(this.getActionType());
                this.metaData.write(rowOut);
                Result.writeSimple(rowOut, this.metaData, (Object[])this.valueData);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 16: {
                rowOut.writeInt(this.updateCount);
                rowOut.writeInt(this.fetchSize);
                rowOut.writeLong(this.statementID);
                rowOut.writeShort(this.queryTimeout);
                this.metaData.write(rowOut);
                this.navigator.writeSimple(rowOut, this.metaData);
                break;
            }
            case 17: {
                this.metaData.write(rowOut);
                this.navigator.write(rowOut, this.metaData);
                break;
            }
            case 38: {
                int type = this.getConnectionAttrType();
                rowOut.writeInt(type);
                switch (type) {
                    case 10027: {
                        rowOut.writeString(this.mainString);
                        break block0;
                    }
                }
                throw Error.runtimeError(201, "Result");
            }
            case 13: {
                rowOut.writeLong(this.id);
                rowOut.writeInt(this.updateCount);
                rowOut.writeInt(this.fetchSize);
                break;
            }
            case 14: {
                this.metaData.write(rowOut);
                this.navigator.write(rowOut, this.metaData);
                break;
            }
            case 3: 
            case 15: 
            case 20: {
                rowOut.writeLong(this.id);
                rowOut.writeInt(this.updateCount);
                rowOut.writeInt(this.fetchSize);
                rowOut.writeByte(this.rsProperties);
                this.metaData.write(rowOut);
                this.navigator.write(rowOut, this.metaData);
                break;
            }
            default: {
                throw Error.runtimeError(201, "Result");
            }
        }
        rowOut.writeIntData(rowOut.size() - startPos, startPos);
        dataOut.write(rowOut.getOutputStream().getBuffer(), 0, rowOut.size());
        int count = this.getLobCount();
        Result current = this;
        for (int i = 0; i < count; ++i) {
            ResultLob lob = current.lobResults;
            lob.writeBody(session, dataOut);
            current = current.lobResults;
        }
        if (this.chainedResult == null) {
            dataOut.writeByte(0);
        } else {
            this.chainedResult.write(session, dataOut, rowOut);
        }
        dataOut.flush();
    }

    public int getType() {
        return this.mode;
    }

    public boolean isData() {
        return this.mode == 3 || this.mode == 15;
    }

    public boolean isError() {
        return this.mode == 2;
    }

    public boolean isWarning() {
        return this.mode == 19;
    }

    public boolean isUpdateCount() {
        return this.mode == 1;
    }

    public boolean isSimpleValue() {
        return this.mode == 42;
    }

    public boolean hasGeneratedKeys() {
        return this.mode == 1 && this.chainedResult != null;
    }

    public HsqlException getException() {
        return this.exception;
    }

    public long getStatementID() {
        return this.statementID;
    }

    public void setStatementID(long statementId) {
        this.statementID = statementId;
    }

    public String getMainString() {
        return this.mainString;
    }

    public void setMainString(String sql) {
        this.mainString = sql;
    }

    public String getSubString() {
        return this.subString;
    }

    public String getZoneString() {
        return this.zoneString;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Object getValueObject() {
        return this.valueData;
    }

    public void setValueObject(Object value) {
        this.valueData = value;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setMaxRows(int count) {
        this.updateCount = count;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int count) {
        this.fetchSize = count;
    }

    public int getUpdateCount() {
        return this.updateCount;
    }

    public int getConnectionAttrType() {
        return this.updateCount;
    }

    public void setConnectionAttrType(int type) {
        this.updateCount = type;
    }

    public int getActionType() {
        return this.updateCount;
    }

    public void setActionType(int type) {
        this.updateCount = type;
    }

    public long getSessionId() {
        return this.sessionID;
    }

    public void setSessionId(long id) {
        this.sessionID = id;
    }

    public void setSession(SessionInterface session) {
        if (this.navigator != null) {
            this.navigator.setSession(session);
        }
    }

    public int getDatabaseId() {
        return this.databaseID;
    }

    public void setDatabaseId(int id) {
        this.databaseID = id;
    }

    public long getResultId() {
        return this.id;
    }

    public void setResultId(long id) {
        this.id = id;
        if (this.navigator != null) {
            this.navigator.setId(id);
        }
    }

    public void setUpdateCount(int count) {
        this.updateCount = count;
    }

    public void setAsTransactionEndRequest(int subType, String savepoint) {
        this.mode = (byte)33;
        this.updateCount = subType;
        this.mainString = savepoint == null ? "" : savepoint;
    }

    public Object[] getSingleRowData() {
        Object[] data = this.initialiseNavigator().getNext();
        data = (Object[])ArrayUtil.resizeArrayIfDifferent(data, this.metaData.getColumnCount());
        return data;
    }

    public Object[] getParameterData() {
        return (Object[])this.valueData;
    }

    public Object[] getSessionAttributes() {
        return this.initialiseNavigator().getNext();
    }

    public void setResultType(int type) {
        this.mode = (byte)type;
    }

    public void setStatementType(int type) {
        this.statementReturnType = type;
    }

    public int getStatementType() {
        return this.statementReturnType;
    }

    public int getGeneratedResultType() {
        return this.generateKeys;
    }

    public ResultMetaData getGeneratedResultMetaData() {
        return this.generatedMetaData;
    }

    public Result getChainedResult() {
        return this.chainedResult;
    }

    public Result getUnlinkChainedResult() {
        Result result = this.chainedResult;
        this.chainedResult = null;
        return result;
    }

    public void addChainedResult(Result result) {
        Result current = this;
        while (current.chainedResult != null) {
            current = current.chainedResult;
        }
        current.chainedResult = result;
    }

    public void addWarnings(HsqlException[] warnings) {
        for (int i = 0; i < warnings.length; ++i) {
            Result warning = Result.newWarningResult(warnings[i]);
            this.addChainedResult(warning);
        }
    }

    public int getLobCount() {
        return this.lobCount;
    }

    public ResultLob getLOBResult() {
        return this.lobResults;
    }

    public void addLobResult(ResultLob result) {
        Result current = this;
        while (current.lobResults != null) {
            current = current.lobResults;
        }
        current.lobResults = result;
        ++this.lobCount;
    }

    public void clearLobResults() {
        this.lobResults = null;
        this.lobCount = 0;
    }

    private static Object[] readSimple(RowInputBinary in, ResultMetaData meta) throws IOException {
        int size = in.readInt();
        return in.readData(meta.columnTypes);
    }

    private static void writeSimple(RowOutputInterface out, ResultMetaData meta, Object[] data) throws IOException {
        out.writeInt(1);
        out.writeData(meta.getColumnCount(), meta.columnTypes, data, null, null);
    }

    public RowSetNavigator getNavigator() {
        return this.navigator;
    }

    public void setNavigator(RowSetNavigator navigator) {
        this.navigator = navigator;
    }

    public RowSetNavigator initialiseNavigator() {
        switch (this.mode) {
            case 6: 
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                this.navigator.beforeFirst();
                return this.navigator;
            }
            case 3: 
            case 15: 
            case 20: {
                this.navigator.reset();
                return this.navigator;
            }
        }
        throw Error.runtimeError(201, "Result");
    }

    static {
        SqlInvariants.isSystemSchemaName("SYSTEM");
        for (int i = 0; i < 4; ++i) {
            Result.sessionAttributesMetaData.columns[i] = new ColumnBase(null, null, null, null);
        }
        Result.sessionAttributesMetaData.columns[0].setType(Type.SQL_INTEGER);
        Result.sessionAttributesMetaData.columns[1].setType(Type.SQL_INTEGER);
        Result.sessionAttributesMetaData.columns[2].setType(Type.SQL_BOOLEAN);
        Result.sessionAttributesMetaData.columns[3].setType(Type.SQL_VARCHAR);
        sessionAttributesMetaData.prepareData();
        emptyMeta = ResultMetaData.newResultMetaData(0);
        emptyGeneratedResult = Result.newDataResult(emptyMeta);
        updateZeroResult = Result.newUpdateCountResult(0);
        updateOneResult = Result.newUpdateCountResult(1);
    }
}

