/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ibm.icu.text;

import com.liferay.ibm.icu.text.Replaceable;
import com.liferay.ibm.icu.text.Transliterator;
import com.liferay.ibm.icu.text.UnicodeSet;
import java.util.Vector;

class CompoundTransliterator
extends Transliterator {
    private Transliterator[] trans = null;
    private int numAnonymousRBTs = 0;

    CompoundTransliterator(Vector list) {
        this(list, 0);
    }

    CompoundTransliterator(Vector list, int numAnonymousRBTs) {
        super("", null);
        this.init(list, 0, false);
        this.numAnonymousRBTs = numAnonymousRBTs;
    }

    private void init(Vector list, int direction, boolean fixReverseID) {
        int i;
        int count = list.size();
        this.trans = new Transliterator[count];
        for (i = 0; i < count; ++i) {
            int j = direction == 0 ? i : count - 1 - i;
            this.trans[i] = (Transliterator)list.elementAt(j);
        }
        if (direction == 1 && fixReverseID) {
            StringBuffer newID = new StringBuffer();
            for (i = 0; i < count; ++i) {
                if (i > 0) {
                    newID.append(';');
                }
                newID.append(this.trans[i].getID());
            }
            this.setID(newID.toString());
        }
        this.computeMaximumContextLength();
    }

    public int getCount() {
        return this.trans.length;
    }

    public Transliterator getTransliterator(int index) {
        return this.trans[index];
    }

    private static void _smartAppend(StringBuffer buf, char c) {
        if (buf.length() != 0 && buf.charAt(buf.length() - 1) != c) {
            buf.append(c);
        }
    }

    public String toRules(boolean escapeUnprintable) {
        StringBuffer rulesSource = new StringBuffer();
        if (this.numAnonymousRBTs >= 1 && this.getFilter() != null) {
            rulesSource.append("::").append(this.getFilter().toPattern(escapeUnprintable)).append(';');
        }
        for (int i = 0; i < this.trans.length; ++i) {
            String rule;
            if (this.trans[i].getID().startsWith("%Pass")) {
                rule = this.trans[i].toRules(escapeUnprintable);
                if (this.numAnonymousRBTs > 1 && i > 0 && this.trans[i - 1].getID().startsWith("%Pass")) {
                    rule = "::Null;" + rule;
                }
            } else {
                rule = this.trans[i].getID().indexOf(59) >= 0 ? this.trans[i].toRules(escapeUnprintable) : this.trans[i].baseToRules(escapeUnprintable);
            }
            CompoundTransliterator._smartAppend(rulesSource, '\n');
            rulesSource.append(rule);
            CompoundTransliterator._smartAppend(rulesSource, ';');
        }
        return rulesSource.toString();
    }

    protected UnicodeSet handleGetSourceSet() {
        UnicodeSet set = new UnicodeSet();
        for (int i = 0; i < this.trans.length; ++i) {
            set.addAll(this.trans[i].getSourceSet());
            if (!set.isEmpty()) break;
        }
        return set;
    }

    public UnicodeSet getTargetSet() {
        UnicodeSet set = new UnicodeSet();
        for (int i = 0; i < this.trans.length; ++i) {
            set.addAll(this.trans[i].getTargetSet());
        }
        return set;
    }

    protected void handleTransliterate(Replaceable text, Transliterator.Position index, boolean incremental) {
        if (this.trans.length < 1) {
            index.start = index.limit;
            return;
        }
        int compoundLimit = index.limit;
        int compoundStart = index.start;
        int delta = 0;
        Object log = null;
        for (int i = 0; i < this.trans.length; ++i) {
            index.start = compoundStart;
            int limit = index.limit;
            if (index.start == index.limit) break;
            this.trans[i].filteredTransliterate(text, index, incremental);
            if (!incremental && index.start != index.limit) {
                throw new RuntimeException("ERROR: Incomplete non-incremental transliteration by " + this.trans[i].getID());
            }
            delta += index.limit - limit;
            if (!incremental) continue;
            index.limit = index.start;
        }
        index.limit = compoundLimit += delta;
    }

    private void computeMaximumContextLength() {
        int max = 0;
        for (int i = 0; i < this.trans.length; ++i) {
            int len = this.trans[i].getMaximumContextLength();
            if (len <= max) continue;
            max = len;
        }
        this.setMaximumContextLength(max);
    }
}

