/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.db;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.DataAccessException;
import org.jamwiki.DataHandler;
import org.jamwiki.Environment;
import org.jamwiki.WikiBase;
import org.jamwiki.WikiException;
import org.jamwiki.WikiMessage;
import org.jamwiki.db.AnsiQueryHandler;
import org.jamwiki.db.DatabaseConnection;
import org.jamwiki.db.QueryHandler;
import org.jamwiki.db.WikiDatabase;
import org.jamwiki.model.Category;
import org.jamwiki.model.Interwiki;
import org.jamwiki.model.LogItem;
import org.jamwiki.model.Namespace;
import org.jamwiki.model.RecentChange;
import org.jamwiki.model.Role;
import org.jamwiki.model.RoleMap;
import org.jamwiki.model.Topic;
import org.jamwiki.model.TopicType;
import org.jamwiki.model.TopicVersion;
import org.jamwiki.model.VirtualWiki;
import org.jamwiki.model.Watchlist;
import org.jamwiki.model.WikiFile;
import org.jamwiki.model.WikiFileVersion;
import org.jamwiki.model.WikiGroup;
import org.jamwiki.model.WikiUser;
import org.jamwiki.model.WikiUserDetails;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.ParserOutput;
import org.jamwiki.parser.ParserUtil;
import org.jamwiki.utils.Encryption;
import org.jamwiki.utils.LinkUtil;
import org.jamwiki.utils.Pagination;
import org.jamwiki.utils.WikiCache;
import org.jamwiki.utils.WikiLogger;
import org.jamwiki.utils.WikiUtil;
import org.springframework.transaction.TransactionStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnsiDataHandler
implements DataHandler {
    private static final int TIME_LIMIT_TOPIC_LOOKUP = 10;
    private static final String CACHE_INTERWIKI_LIST = "org.jamwiki.db.AnsiDataHandler.CACHE_INTERWIKI_LIST";
    private static final String CACHE_NAMESPACE_LIST = "org.jamwiki.db.AnsiDataHandler.CACHE_NAMESPACE_LIST";
    private static final String CACHE_ROLE_MAP_GROUP = "org.jamwiki.db.AnsiDataHandler.CACHE_ROLE_MAP_GROUP";
    private static final String CACHE_TOPIC_NAMES_BY_NAME = "org.jamwiki.db.AnsiDataHandler.CACHE_TOPIC_NAMES_BY_NAME";
    private static final String CACHE_TOPICS_BY_ID = "org.jamwiki.db.AnsiDataHandler.CACHE_TOPICS_BY_ID";
    private static final String CACHE_TOPICS_BY_NAME = "org.jamwiki.db.AnsiDataHandler.CACHE_TOPICS_BY_NAME";
    private static final String CACHE_TOPIC_VERSIONS = "org.jamwiki.db.AnsiDataHandler.CACHE_TOPIC_VERSIONS";
    private static final String CACHE_USER_BY_USER_ID = "org.jamwiki.db.AnsiDataHandler.CACHE_USER_BY_USER_ID";
    private static final String CACHE_USER_BY_USER_NAME = "org.jamwiki.db.AnsiDataHandler.CACHE_USER_BY_USER_NAME";
    private static final String CACHE_VIRTUAL_WIKI_LIST = "org.jamwiki.db.AnsiDataHandler.CACHE_VIRTUAL_WIKI_LIST";
    private static final WikiLogger logger = WikiLogger.getLogger(AnsiDataHandler.class.getName());
    private final QueryHandler queryHandler = new AnsiQueryHandler();

    private void addCategories(List<Category> categoryList, int topicId, Connection conn) throws DataAccessException, WikiException {
        int virtualWikiId = -1;
        for (Category category : categoryList) {
            virtualWikiId = this.lookupVirtualWikiId(category.getVirtualWiki());
            this.validateCategory(category);
        }
        try {
            this.queryHandler().insertCategories(categoryList, virtualWikiId, topicId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addGroupMember(String username, int groupId, Connection conn) throws DataAccessException {
        try {
            this.queryHandler().insertGroupMember(username, groupId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addLogItem(LogItem logItem, Connection conn) throws DataAccessException, WikiException {
        int virtualWikiId = this.lookupVirtualWikiId(logItem.getVirtualWiki());
        this.validateLogItem(logItem);
        try {
            this.queryHandler().insertLogItem(logItem, virtualWikiId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addRecentChange(RecentChange change, Connection conn) throws DataAccessException, WikiException {
        int virtualWikiId = this.lookupVirtualWikiId(change.getVirtualWiki());
        this.validateRecentChange(change);
        try {
            this.queryHandler().insertRecentChange(change, virtualWikiId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addTopic(Topic topic, Connection conn) throws DataAccessException, WikiException {
        int virtualWikiId = this.lookupVirtualWikiId(topic.getVirtualWiki());
        try {
            this.validateTopic(topic);
            this.queryHandler().insertTopic(topic, virtualWikiId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addTopicLinks(List<String> links, int topicId, Connection conn) throws DataAccessException {
        HashMap<String, String> linksMap = new HashMap<String, String>();
        for (String link : links) {
            if (link.length() > 200) continue;
            linksMap.put(link, link);
        }
        links = new ArrayList(linksMap.keySet());
        try {
            this.queryHandler().insertTopicLinks(links, topicId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addTopicVersion(Topic topic, TopicVersion topicVersion, Connection conn) throws DataAccessException, WikiException {
        if (topicVersion.getPreviousTopicVersionId() == null && topic.getCurrentVersionId() != null) {
            topicVersion.setPreviousTopicVersionId(topic.getCurrentVersionId());
        }
        topicVersion.setTopicId(topic.getTopicId());
        topicVersion.initializeVersionParams(topic);
        try {
            this.validateTopicVersion(topicVersion);
            this.queryHandler().insertTopicVersion(topicVersion, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        topic.setCurrentVersionId(topicVersion.getTopicVersionId());
    }

    private void addUserDetails(WikiUserDetails userDetails, Connection conn) throws DataAccessException, WikiException {
        this.validateUserDetails(userDetails);
        try {
            this.queryHandler().insertUserDetails(userDetails, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addVirtualWiki(VirtualWiki virtualWiki, Connection conn) throws DataAccessException, WikiException {
        try {
            this.validateVirtualWiki(virtualWiki);
            this.queryHandler().insertVirtualWiki(virtualWiki, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addWatchlistEntry(int virtualWikiId, String topicName, int userId, Connection conn) throws DataAccessException, WikiException {
        this.validateWatchlistEntry(topicName);
        try {
            this.queryHandler().insertWatchlistEntry(virtualWikiId, topicName, userId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addWikiFile(WikiFile wikiFile, Connection conn) throws DataAccessException, WikiException {
        try {
            int virtualWikiId = this.lookupVirtualWikiId(wikiFile.getVirtualWiki());
            this.validateWikiFile(wikiFile);
            this.queryHandler().insertWikiFile(wikiFile, virtualWikiId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addWikiFileVersion(WikiFileVersion wikiFileVersion, Connection conn) throws DataAccessException, WikiException {
        try {
            this.validateWikiFileVersion(wikiFileVersion);
            this.queryHandler().insertWikiFileVersion(wikiFileVersion, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addWikiGroup(WikiGroup group, Connection conn) throws DataAccessException, WikiException {
        try {
            this.validateWikiGroup(group);
            this.queryHandler().insertWikiGroup(group, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void addWikiUser(WikiUser user, Connection conn) throws DataAccessException, WikiException {
        try {
            this.validateWikiUser(user);
            this.queryHandler().insertWikiUser(user, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public boolean authenticate(String username, String password) throws DataAccessException {
        if (StringUtils.isBlank((String)password)) {
            return false;
        }
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            String encryptedPassword = Encryption.encrypt(password);
            boolean bl = this.queryHandler().authenticateUser(username, encryptedPassword, conn);
            return bl;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
    }

    private String authorName(Integer authorId, String authorName) throws DataAccessException {
        if (authorId != null) {
            WikiUser user = this.lookupWikiUser(authorId);
            authorName = user.getUsername();
        }
        return authorName;
    }

    private String cacheTopicKey(String virtualWiki, Namespace namespace, String pageName) {
        String topicName = namespace.getLabel(virtualWiki);
        if (topicName.length() != 0) {
            topicName = topicName + ":";
        }
        topicName = topicName + pageName;
        return WikiCache.key(virtualWiki, topicName);
    }

    private void cacheTopicRefresh(Topic topic) {
        String key = this.cacheTopicKey(topic.getVirtualWiki(), topic.getNamespace(), topic.getPageName());
        WikiCache.removeFromCacheCaseInsensitive("org.jamwiki.WikiBase.CACHE_PARSED_TOPIC_CONTENT", key);
        WikiCache.removeFromCacheCaseInsensitive(CACHE_TOPIC_NAMES_BY_NAME, key);
        WikiCache.removeFromCacheCaseInsensitive(CACHE_TOPICS_BY_NAME, key);
        if (topic.getDeleteDate() == null) {
            WikiCache.addToCache(CACHE_TOPIC_NAMES_BY_NAME, key, topic.getName());
        }
        WikiCache.addToCache(CACHE_TOPICS_BY_NAME, key, topic);
        WikiCache.addToCache(CACHE_TOPICS_BY_ID, topic.getTopicId(), topic);
    }

    @Override
    public boolean canMoveTopic(Topic fromTopic, String destination) throws DataAccessException {
        Topic toTopic = this.lookupTopic(fromTopic.getVirtualWiki(), destination, false, null);
        if (toTopic == null || toTopic.getDeleteDate() != null) {
            return true;
        }
        if (!toTopic.getVirtualWiki().equals(fromTopic.getVirtualWiki())) {
            return false;
        }
        return toTopic.getRedirectTo() != null && toTopic.getRedirectTo().equals(fromTopic.getName());
    }

    private static void checkLength(String value, int maxLength) throws WikiException {
        if (value != null && value.length() > maxLength) {
            throw new WikiException(new WikiMessage("error.fieldlength", value, Integer.valueOf(maxLength).toString()));
        }
    }

    @Override
    public void deleteInterwiki(Interwiki interwiki) throws DataAccessException {
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            this.queryHandler().deleteInterwiki(interwiki, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
        WikiCache.removeAllFromCache(CACHE_INTERWIKI_LIST);
    }

    private void deleteRecentChanges(Topic topic, Connection conn) throws DataAccessException {
        try {
            this.queryHandler().deleteRecentChanges(topic.getTopicId(), conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void deleteTopic(Topic topic, TopicVersion topicVersion) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            if (topicVersion != null) {
                this.deleteRecentChanges(topic, conn);
            }
            ParserOutput parserOutput = new ParserOutput();
            topic.setDeleteDate(new Timestamp(System.currentTimeMillis()));
            this.writeTopic(topic, topicVersion, parserOutput.getCategories(), parserOutput.getLinks());
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    private void deleteTopicCategories(Topic topic, Connection conn) throws DataAccessException {
        try {
            this.queryHandler().deleteTopicCategories(topic.getTopicId(), conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void deleteTopicLinks(int topicId, Connection conn) throws DataAccessException {
        try {
            this.queryHandler().deleteTopicLinks(topicId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void deleteWatchlistEntry(int virtualWikiId, String topicName, int userId, Connection conn) throws DataAccessException {
        try {
            this.queryHandler().deleteWatchlistEntry(virtualWikiId, topicName, userId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void executeUpgradeQuery(String prop, Connection conn) throws SQLException {
        this.queryHandler().executeUpgradeQuery(prop, conn);
    }

    @Override
    public void executeUpgradeUpdate(String prop, Connection conn) throws SQLException {
        this.queryHandler().executeUpgradeUpdate(prop, conn);
    }

    private int findMaxNamespaceId() throws DataAccessException {
        List<Namespace> namespaces = this.lookupNamespaces();
        int namespaceEnd = 0;
        for (Namespace namespace : namespaces) {
            namespaceEnd = namespace.getId() > namespaceEnd ? namespace.getId() : namespaceEnd;
        }
        return namespaceEnd;
    }

    @Override
    public List<Category> getAllCategories(String virtualWiki, Pagination pagination) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().getCategories(virtualWikiId, virtualWiki, pagination);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<Role> getAllRoles() throws DataAccessException {
        try {
            return this.queryHandler().getRoles();
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<String> getAllTopicNames(String virtualWiki, boolean includeDeleted) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            ArrayList<String> arrayList = new ArrayList<String>(this.queryHandler().lookupTopicNames(virtualWikiId, includeDeleted, conn).values());
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
    }

    @Override
    public List<WikiFileVersion> getAllWikiFileVersions(String virtualWiki, String topicName, boolean descending) throws DataAccessException {
        WikiFile wikiFile = this.lookupWikiFile(virtualWiki, topicName);
        if (wikiFile == null) {
            throw new DataAccessException("No topic exists for " + virtualWiki + " / " + topicName);
        }
        try {
            return this.queryHandler().getAllWikiFileVersions(wikiFile, descending);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<LogItem> getLogItems(String virtualWiki, int logType, Pagination pagination, boolean descending) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().getLogItems(virtualWikiId, virtualWiki, logType, pagination, descending);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<RecentChange> getRecentChanges(String virtualWiki, Pagination pagination, boolean descending) throws DataAccessException {
        try {
            return this.queryHandler().getRecentChanges(virtualWiki, pagination, descending);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<RoleMap> getRoleMapByLogin(String loginFragment) throws DataAccessException {
        try {
            return this.queryHandler().getRoleMapByLogin(loginFragment);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<RoleMap> getRoleMapByRole(String authority) throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_ROLE_MAP_GROUP, authority);
        if (cacheElement != null) {
            return (List)cacheElement.getObjectValue();
        }
        List<RoleMap> roleMapList = null;
        try {
            roleMapList = this.queryHandler().getRoleMapByRole(authority);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        WikiCache.addToCache(CACHE_ROLE_MAP_GROUP, authority, roleMapList);
        return roleMapList;
    }

    @Override
    public List<Role> getRoleMapGroup(String groupName) throws DataAccessException {
        try {
            return this.queryHandler().getRoleMapGroup(groupName);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<RoleMap> getRoleMapGroups() throws DataAccessException {
        try {
            return this.queryHandler().getRoleMapGroups();
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<Role> getRoleMapUser(String login) throws DataAccessException {
        try {
            return this.queryHandler().getRoleMapUser(login);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<RecentChange> getTopicHistory(String virtualWiki, String topicName, Pagination pagination, boolean descending) throws DataAccessException {
        Topic topic = this.lookupTopic(virtualWiki, topicName, true, null);
        if (topic == null) {
            return new ArrayList<RecentChange>();
        }
        try {
            return this.queryHandler().getTopicHistory(topic.getTopicId(), pagination, descending);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<String> getTopicsAdmin(String virtualWiki, Pagination pagination) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().getTopicsAdmin(virtualWikiId, pagination);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<RecentChange> getUserContributions(String virtualWiki, String userString, Pagination pagination, boolean descending) throws DataAccessException {
        try {
            if (this.lookupWikiUser(userString) != null) {
                return this.queryHandler().getUserContributionsByLogin(virtualWiki, userString, pagination, descending);
            }
            return this.queryHandler().getUserContributionsByUserDisplay(virtualWiki, userString, pagination, descending);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<VirtualWiki> getVirtualWikiList() throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_VIRTUAL_WIKI_LIST, CACHE_VIRTUAL_WIKI_LIST);
        if (cacheElement != null) {
            return (List)cacheElement.getObjectValue();
        }
        ArrayList<VirtualWiki> virtualWikis = new ArrayList();
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            virtualWikis = this.queryHandler().getVirtualWikis(conn);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
        WikiCache.addToCache(CACHE_VIRTUAL_WIKI_LIST, CACHE_VIRTUAL_WIKI_LIST, virtualWikis);
        return virtualWikis;
    }

    @Override
    public Watchlist getWatchlist(String virtualWiki, int userId) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            List<String> watchedTopicNames = this.queryHandler().getWatchlist(virtualWikiId, userId);
            return new Watchlist(virtualWiki, watchedTopicNames);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<RecentChange> getWatchlist(String virtualWiki, int userId, Pagination pagination) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().getWatchlist(virtualWikiId, userId, pagination);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<Category> lookupCategoryTopics(String virtualWiki, String categoryName) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().lookupCategoryTopics(virtualWikiId, virtualWiki, categoryName);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public Map<String, String> lookupConfiguration() throws DataAccessException {
        try {
            return this.queryHandler().lookupConfiguration();
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public Interwiki lookupInterwiki(String interwikiPrefix) throws DataAccessException {
        if (interwikiPrefix == null) {
            return null;
        }
        List<Interwiki> interwikis = this.lookupInterwikis();
        for (Interwiki interwiki : interwikis) {
            if (!interwiki.getInterwikiPrefix().equalsIgnoreCase(interwikiPrefix.trim())) continue;
            return interwiki;
        }
        return null;
    }

    @Override
    public List<Interwiki> lookupInterwikis() throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_INTERWIKI_LIST, CACHE_INTERWIKI_LIST);
        if (cacheElement != null) {
            return (List)cacheElement.getObjectValue();
        }
        List<Interwiki> interwikis = null;
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            interwikis = this.queryHandler().lookupInterwikis(conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
        WikiCache.addToCache(CACHE_INTERWIKI_LIST, CACHE_INTERWIKI_LIST, interwikis);
        return interwikis;
    }

    @Override
    public Namespace lookupNamespace(String virtualWiki, String namespaceString) throws DataAccessException {
        if (namespaceString == null) {
            return null;
        }
        List<Namespace> namespaces = this.lookupNamespaces();
        for (Namespace namespace : namespaces) {
            if (!namespace.getLabel(virtualWiki).equalsIgnoreCase(namespaceString) && !namespace.getDefaultLabel().equals(namespaceString)) continue;
            return namespace;
        }
        return null;
    }

    @Override
    public Namespace lookupNamespaceById(int namespaceId) throws DataAccessException {
        List<Namespace> namespaces = this.lookupNamespaces();
        for (Namespace namespace : namespaces) {
            if (namespace.getId() == null || namespace.getId() != namespaceId) continue;
            return namespace;
        }
        return null;
    }

    @Override
    public List<Namespace> lookupNamespaces() throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_NAMESPACE_LIST, CACHE_NAMESPACE_LIST);
        if (cacheElement != null) {
            return (List)cacheElement.getObjectValue();
        }
        List<Namespace> namespaces = null;
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            namespaces = this.queryHandler().lookupNamespaces(conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
        WikiCache.addToCache(CACHE_NAMESPACE_LIST, CACHE_NAMESPACE_LIST, namespaces);
        return namespaces;
    }

    @Override
    public Topic lookupTopic(String virtualWiki, String topicName, boolean deleteOK, Connection conn) throws DataAccessException {
        if (StringUtils.isBlank((String)virtualWiki) || StringUtils.isBlank((String)topicName)) {
            return null;
        }
        Namespace namespace = LinkUtil.retrieveTopicNamespace(virtualWiki, topicName);
        String pageName = LinkUtil.retrieveTopicPageName(namespace, virtualWiki, topicName);
        return this.lookupTopic(virtualWiki, namespace, pageName, deleteOK, conn);
    }

    private Topic lookupTopic(String virtualWiki, Namespace namespace, String pageName, boolean deleteOK, Connection conn) throws DataAccessException {
        long execution;
        String sharedKey;
        Element cacheElement;
        Element cacheElement2;
        long start = System.currentTimeMillis();
        String key = this.cacheTopicKey(virtualWiki, namespace, pageName);
        if (conn == null && (cacheElement2 = WikiCache.retrieveFromCache(CACHE_TOPICS_BY_NAME, key)) != null) {
            Topic cacheTopic = (Topic)cacheElement2.getObjectValue();
            return cacheTopic == null || !deleteOK && cacheTopic.getDeleteDate() != null ? null : new Topic(cacheTopic);
        }
        boolean checkSharedVirtualWiki = this.useSharedVirtualWiki(virtualWiki, namespace);
        String sharedVirtualWiki = Environment.getValue("shared-upload-virtual-wiki");
        if (conn == null && checkSharedVirtualWiki && (cacheElement = WikiCache.retrieveFromCache(CACHE_TOPICS_BY_NAME, sharedKey = this.cacheTopicKey(sharedVirtualWiki, namespace, pageName))) != null) {
            Topic cacheTopic = (Topic)cacheElement.getObjectValue();
            return cacheTopic == null || !deleteOK && cacheTopic.getDeleteDate() != null ? null : new Topic(cacheTopic);
        }
        Topic topic = null;
        try {
            int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
            topic = this.queryHandler().lookupTopic(virtualWikiId, virtualWiki, namespace, pageName, conn);
            if (topic == null && Environment.getBooleanValue("allow-capitalization")) {
                String alternativePageName = StringUtils.equals((String)pageName, (String)StringUtils.capitalize((String)pageName)) ? StringUtils.lowerCase((String)pageName) : StringUtils.capitalize((String)pageName);
                topic = this.queryHandler().lookupTopic(virtualWikiId, virtualWiki, namespace, alternativePageName, conn);
            }
            if (topic == null && checkSharedVirtualWiki) {
                topic = this.lookupTopic(sharedVirtualWiki, namespace, pageName, deleteOK, conn);
            }
            if (conn == null) {
                Topic cacheTopic = topic == null ? null : new Topic(topic);
                WikiCache.addToCache(CACHE_TOPICS_BY_NAME, key, cacheTopic);
                WikiCache.addToCache(CACHE_TOPIC_NAMES_BY_NAME, key, cacheTopic == null ? null : cacheTopic.getName());
            }
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        if (logger.isDebugEnabled() && (execution = System.currentTimeMillis() - start) > 10L) {
            logger.debug("Slow topic lookup for: " + Topic.buildTopicName(virtualWiki, namespace, pageName) + " (" + (double)execution / 1000.0 + " s)");
        }
        return topic == null || !deleteOK && topic.getDeleteDate() != null ? null : topic;
    }

    @Override
    public Topic lookupTopicById(String virtualWiki, int topicId) throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_TOPICS_BY_ID, topicId);
        if (cacheElement != null) {
            return (Topic)cacheElement.getObjectValue();
        }
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        Topic result = null;
        try {
            result = this.queryHandler().lookupTopicById(virtualWikiId, virtualWiki, topicId);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        WikiCache.addToCache(CACHE_TOPICS_BY_ID, topicId, result);
        return result;
    }

    @Override
    public int lookupTopicCount(String virtualWiki, Integer namespaceId) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        int namespaceStart = namespaceId != null ? namespaceId : 0;
        int namespaceEnd = namespaceId != null ? namespaceId.intValue() : this.findMaxNamespaceId();
        try {
            return this.queryHandler().lookupTopicCount(virtualWikiId, namespaceStart, namespaceEnd);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public Map<Integer, String> lookupTopicByType(String virtualWiki, TopicType topicType1, TopicType topicType2, Integer namespaceId, Pagination pagination) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        int namespaceStart = namespaceId != null ? namespaceId : 0;
        int namespaceEnd = namespaceId != null ? namespaceId.intValue() : this.findMaxNamespaceId();
        try {
            return this.queryHandler().lookupTopicByType(virtualWikiId, topicType1, topicType2, namespaceStart, namespaceEnd, pagination);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public String lookupTopicName(String virtualWiki, String topicName) throws DataAccessException {
        if (StringUtils.isBlank((String)virtualWiki) || StringUtils.isBlank((String)topicName)) {
            return null;
        }
        Namespace namespace = LinkUtil.retrieveTopicNamespace(virtualWiki, topicName);
        String pageName = LinkUtil.retrieveTopicPageName(namespace, virtualWiki, topicName);
        return this.lookupTopicName(virtualWiki, namespace, pageName);
    }

    private String lookupTopicName(String virtualWiki, Namespace namespace, String pageName) throws DataAccessException {
        long execution;
        String sharedKey;
        long start = System.currentTimeMillis();
        String key = this.cacheTopicKey(virtualWiki, namespace, pageName);
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_TOPIC_NAMES_BY_NAME, key);
        if (cacheElement != null) {
            return (String)cacheElement.getObjectValue();
        }
        boolean checkSharedVirtualWiki = this.useSharedVirtualWiki(virtualWiki, namespace);
        String sharedVirtualWiki = Environment.getValue("shared-upload-virtual-wiki");
        if (checkSharedVirtualWiki && (cacheElement = WikiCache.retrieveFromCache(CACHE_TOPIC_NAMES_BY_NAME, sharedKey = this.cacheTopicKey(sharedVirtualWiki, namespace, pageName))) != null) {
            return (String)cacheElement.getObjectValue();
        }
        String topicName = null;
        try {
            int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
            topicName = this.queryHandler().lookupTopicName(virtualWikiId, virtualWiki, namespace, pageName);
            if (topicName == null && checkSharedVirtualWiki) {
                topicName = this.lookupTopicName(sharedVirtualWiki, namespace, pageName);
            }
            WikiCache.addToCache(CACHE_TOPIC_NAMES_BY_NAME, key, topicName);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        if (logger.isDebugEnabled() && (execution = System.currentTimeMillis() - start) > 10L) {
            logger.debug("Slow topic existence lookup for: " + Topic.buildTopicName(virtualWiki, namespace, pageName) + " (" + (double)execution / 1000.0 + " s)");
        }
        return topicName;
    }

    @Override
    public List<String> lookupTopicLinks(String virtualWiki, String topicName) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().lookupTopicLinks(virtualWikiId, topicName);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<String> lookupTopicLinkOrphans(String virtualWiki, int namespaceId) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().lookupTopicLinkOrphans(virtualWikiId, namespaceId);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public TopicVersion lookupTopicVersion(int topicVersionId) throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_TOPIC_VERSIONS, topicVersionId);
        if (cacheElement != null) {
            return (TopicVersion)cacheElement.getObjectValue();
        }
        TopicVersion topicVersion = null;
        try {
            topicVersion = this.queryHandler().lookupTopicVersion(topicVersionId);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        WikiCache.addToCache(CACHE_TOPIC_VERSIONS, topicVersionId, topicVersion);
        return topicVersion;
    }

    @Override
    public Integer lookupTopicVersionNextId(int topicVersionId) throws DataAccessException {
        try {
            return this.queryHandler().lookupTopicVersionNextId(topicVersionId);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public VirtualWiki lookupVirtualWiki(String virtualWikiName) throws DataAccessException {
        List<VirtualWiki> virtualWikis = this.getVirtualWikiList();
        for (VirtualWiki virtualWiki : virtualWikis) {
            if (!virtualWiki.getName().equals(virtualWikiName)) continue;
            return virtualWiki;
        }
        return null;
    }

    private int lookupVirtualWikiId(String virtualWikiName) throws DataAccessException {
        VirtualWiki virtualWiki = this.lookupVirtualWiki(virtualWikiName);
        return virtualWiki == null ? -1 : virtualWiki.getVirtualWikiId();
    }

    @Override
    public WikiFile lookupWikiFile(String virtualWiki, String topicName) throws DataAccessException {
        if (StringUtils.isBlank((String)virtualWiki) || StringUtils.isBlank((String)topicName)) {
            return null;
        }
        Namespace namespace = LinkUtil.retrieveTopicNamespace(virtualWiki, topicName);
        String pageName = LinkUtil.retrieveTopicPageName(namespace, virtualWiki, topicName);
        return this.lookupWikiFile(virtualWiki, namespace, pageName);
    }

    private WikiFile lookupWikiFile(String virtualWiki, Namespace namespace, String pageName) throws DataAccessException {
        Topic topic = this.lookupTopic(virtualWiki, namespace, pageName, false, null);
        if (topic == null) {
            return null;
        }
        try {
            int virtualWikiId = this.lookupVirtualWikiId(topic.getVirtualWiki());
            WikiFile wikiFile = this.queryHandler().lookupWikiFile(virtualWikiId, topic.getVirtualWiki(), topic.getTopicId());
            if (wikiFile == null && this.useSharedVirtualWiki(topic.getVirtualWiki(), topic.getNamespace())) {
                String sharedVirtualWiki = Environment.getValue("shared-upload-virtual-wiki");
                wikiFile = this.lookupWikiFile(sharedVirtualWiki, namespace, pageName);
            }
            return wikiFile;
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public int lookupWikiFileCount(String virtualWiki) throws DataAccessException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        try {
            return this.queryHandler().lookupWikiFileCount(virtualWikiId);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public WikiGroup lookupWikiGroup(String groupName) throws DataAccessException {
        try {
            return this.queryHandler().lookupWikiGroup(groupName);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public WikiUser lookupWikiUser(int userId) throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_USER_BY_USER_ID, userId);
        if (cacheElement != null) {
            return (WikiUser)cacheElement.getObjectValue();
        }
        WikiUser user = null;
        try {
            user = this.queryHandler().lookupWikiUser(userId);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        WikiCache.addToCache(CACHE_USER_BY_USER_ID, userId, user);
        return user;
    }

    @Override
    public WikiUser lookupWikiUser(String username) throws DataAccessException {
        Element cacheElement = WikiCache.retrieveFromCache(CACHE_USER_BY_USER_NAME, username);
        if (cacheElement != null) {
            return (WikiUser)cacheElement.getObjectValue();
        }
        WikiUser result = null;
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            int userId = this.queryHandler().lookupWikiUser(username, conn);
            if (userId != -1) {
                result = this.lookupWikiUser(userId);
            }
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
        WikiCache.addToCache(CACHE_USER_BY_USER_NAME, username, result);
        return result;
    }

    @Override
    public int lookupWikiUserCount() throws DataAccessException {
        try {
            return this.queryHandler().lookupWikiUserCount();
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public String lookupWikiUserEncryptedPassword(String username) throws DataAccessException {
        try {
            return this.queryHandler().lookupWikiUserEncryptedPassword(username);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public List<String> lookupWikiUsers(Pagination pagination) throws DataAccessException {
        try {
            return this.queryHandler().lookupWikiUsers(pagination);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    @Override
    public void moveTopic(Topic fromTopic, TopicVersion fromVersion, String destination) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            boolean detinationExistsFlag;
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            if (!this.canMoveTopic(fromTopic, destination)) {
                throw new WikiException(new WikiMessage("move.exception.destinationexists", destination));
            }
            Topic toTopic = this.lookupTopic(fromTopic.getVirtualWiki(), destination, false, conn);
            boolean bl = detinationExistsFlag = toTopic != null && toTopic.getDeleteDate() == null;
            if (detinationExistsFlag) {
                this.deleteTopic(toTopic, null);
            }
            String fromTopicName = fromTopic.getName();
            fromTopic.setName(destination);
            fromVersion.setRecentChangeAllowed(false);
            ParserOutput fromParserOutput = ParserUtil.parserOutput(fromTopic.getTopicContent(), fromTopic.getVirtualWiki(), fromTopic.getName());
            this.writeTopic(fromTopic, fromVersion, fromParserOutput.getCategories(), fromParserOutput.getLinks());
            if (detinationExistsFlag) {
                toTopic.setName(fromTopicName);
                this.writeTopic(toTopic, null, null, null);
                this.undeleteTopic(toTopic, null);
            } else {
                toTopic = new Topic(fromTopic);
                toTopic.setTopicId(-1);
                toTopic.setName(fromTopicName);
            }
            String content = ParserUtil.parserRedirectContent(destination);
            toTopic.setRedirectTo(destination);
            toTopic.setTopicType(TopicType.REDIRECT);
            toTopic.setTopicContent(content);
            TopicVersion toVersion = fromVersion;
            toVersion.setTopicVersionId(-1);
            toVersion.setVersionContent(content);
            toVersion.setRecentChangeAllowed(true);
            ParserOutput toParserOutput = ParserUtil.parserOutput(toTopic.getTopicContent(), toTopic.getVirtualWiki(), toTopic.getName());
            this.writeTopic(toTopic, toVersion, toParserOutput.getCategories(), toParserOutput.getLinks());
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (ParserException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void orderTopicVersions(Topic topic, List<Integer> topicVersionIdList) throws DataAccessException {
        try {
            int virtualWikiId = this.lookupVirtualWikiId(topic.getVirtualWiki());
            this.queryHandler().orderTopicVersions(topic, virtualWikiId, topicVersionIdList);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        this.cacheTopicRefresh(topic);
    }

    protected QueryHandler queryHandler() {
        return this.queryHandler;
    }

    @Override
    public void reloadLogItems() throws DataAccessException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            List<VirtualWiki> virtualWikis = this.getVirtualWikiList();
            for (VirtualWiki virtualWiki : virtualWikis) {
                this.queryHandler().reloadLogItems(virtualWiki.getVirtualWikiId(), conn);
            }
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void reloadRecentChanges() throws DataAccessException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.queryHandler().reloadRecentChanges(conn);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setup(Locale locale, WikiUser user, String username, String encryptedPassword) throws DataAccessException, WikiException {
        WikiDatabase.initialize();
        Connection conn = null;
        Statement stmt = null;
        try {
            conn = DatabaseConnection.getConnection();
            stmt = conn.createStatement();
            stmt.executeQuery(WikiDatabase.getExistenceValidationQuery());
            return;
        }
        catch (SQLException e) {
        }
        finally {
            DatabaseConnection.closeConnection(conn, stmt);
        }
        WikiDatabase.setup(locale, user, username, encryptedPassword);
    }

    @Override
    public void setupSpecialPages(Locale locale, WikiUser user, VirtualWiki virtualWiki) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "StartingPoints", user, false);
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "LeftMenu", user, true);
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "BottomArea", user, true);
            WikiDatabase.setupSpecialPage(locale, virtualWiki.getName(), "StyleSheet", user, true);
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void undeleteTopic(Topic topic, TopicVersion topicVersion) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            ParserOutput parserOutput = ParserUtil.parserOutput(topic.getTopicContent(), topic.getVirtualWiki(), topic.getName());
            topic.setDeleteDate(null);
            this.writeTopic(topic, topicVersion, parserOutput.getCategories(), parserOutput.getLinks());
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (ParserException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void updateSpecialPage(Locale locale, String virtualWiki, String topicName, String userDisplay) throws DataAccessException, WikiException {
        logger.info("Updating special page " + virtualWiki + " / " + topicName);
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            String contents = WikiDatabase.readSpecialPage(locale, topicName);
            Topic topic = this.lookupTopic(virtualWiki, topicName, false, conn);
            int charactersChanged = StringUtils.length((String)contents) - StringUtils.length((String)topic.getTopicContent());
            topic.setTopicContent(contents);
            TopicVersion topicVersion = new TopicVersion(null, userDisplay, "Automatically updated by system upgrade", contents, charactersChanged);
            ParserOutput parserOutput = ParserUtil.parserOutput(topic.getTopicContent(), virtualWiki, topicName);
            this.writeTopic(topic, topicVersion, parserOutput.getCategories(), parserOutput.getLinks());
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (ParserException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (IOException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    private void updateTopic(Topic topic, Connection conn) throws DataAccessException, WikiException {
        int virtualWikiId = this.lookupVirtualWikiId(topic.getVirtualWiki());
        this.validateTopic(topic);
        try {
            this.queryHandler().updateTopic(topic, virtualWikiId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void updateUserDetails(WikiUserDetails userDetails, Connection conn) throws DataAccessException, WikiException {
        this.validateUserDetails(userDetails);
        try {
            this.queryHandler().updateUserDetails(userDetails, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void updateVirtualWiki(VirtualWiki virtualWiki, Connection conn) throws DataAccessException, WikiException {
        this.validateVirtualWiki(virtualWiki);
        try {
            this.queryHandler().updateVirtualWiki(virtualWiki, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void updateWikiFile(WikiFile wikiFile, Connection conn) throws DataAccessException, WikiException {
        int virtualWikiId = this.lookupVirtualWikiId(wikiFile.getVirtualWiki());
        this.validateWikiFile(wikiFile);
        try {
            this.queryHandler().updateWikiFile(wikiFile, virtualWikiId, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void updateWikiGroup(WikiGroup group, Connection conn) throws DataAccessException, WikiException {
        this.validateWikiGroup(group);
        try {
            this.queryHandler().updateWikiGroup(group, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private void updateWikiUser(WikiUser user, Connection conn) throws DataAccessException, WikiException {
        this.validateWikiUser(user);
        try {
            this.queryHandler().updateWikiUser(user, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
    }

    private boolean useSharedVirtualWiki(String virtualWiki, Namespace namespace) {
        String sharedVirtualWiki = Environment.getValue("shared-upload-virtual-wiki");
        if (!StringUtils.isBlank((String)sharedVirtualWiki) && !StringUtils.equals((String)virtualWiki, (String)sharedVirtualWiki)) {
            return namespace.getId().equals(6) || namespace.getId().equals(-2);
        }
        return false;
    }

    protected void validateAuthority(String role) throws WikiException {
        AnsiDataHandler.checkLength(role, 30);
    }

    protected void validateCategory(Category category) throws WikiException {
        AnsiDataHandler.checkLength(category.getName(), 200);
        AnsiDataHandler.checkLength(category.getSortKey(), 200);
    }

    protected void validateConfiguration(Map<String, String> configuration) throws WikiException {
        for (String key : configuration.keySet()) {
            AnsiDataHandler.checkLength(key, 50);
            AnsiDataHandler.checkLength(configuration.get(key), 500);
        }
    }

    protected void validateLogItem(LogItem logItem) throws WikiException {
        AnsiDataHandler.checkLength(logItem.getUserDisplayName(), 200);
        AnsiDataHandler.checkLength(logItem.getLogParamString(), 500);
        logItem.setLogComment(StringUtils.substring((String)logItem.getLogComment(), (int)0, (int)200));
    }

    protected void validateNamespace(Namespace mainNamespace, Namespace commentsNamespace) throws WikiException {
        AnsiDataHandler.checkLength(mainNamespace.getDefaultLabel(), 200);
        if (commentsNamespace != null) {
            AnsiDataHandler.checkLength(commentsNamespace.getDefaultLabel(), 200);
            if (commentsNamespace.getMainNamespace() == null || !commentsNamespace.getMainNamespace().equals(mainNamespace)) {
                throw new WikiException(new WikiMessage("error.commentsnamespace", commentsNamespace.getDefaultLabel(), mainNamespace.getDefaultLabel()));
            }
        }
    }

    protected void validateNamespaceTranslation(Namespace namespace, String virtualWiki) throws WikiException {
        AnsiDataHandler.checkLength(namespace.getLabel(virtualWiki), 200);
    }

    protected void validateRecentChange(RecentChange change) throws WikiException {
        AnsiDataHandler.checkLength(change.getTopicName(), 200);
        AnsiDataHandler.checkLength(change.getAuthorName(), 200);
        AnsiDataHandler.checkLength(change.getVirtualWiki(), 100);
        change.setChangeComment(StringUtils.substring((String)change.getChangeComment(), (int)0, (int)200));
        AnsiDataHandler.checkLength(change.getParamString(), 500);
    }

    protected void validateRole(Role role) throws WikiException {
        AnsiDataHandler.checkLength(role.getAuthority(), 30);
        role.setDescription(StringUtils.substring((String)role.getDescription(), (int)0, (int)200));
    }

    protected void validateTopic(Topic topic) throws WikiException {
        AnsiDataHandler.checkLength(topic.getName(), 200);
        AnsiDataHandler.checkLength(topic.getRedirectTo(), 200);
    }

    protected void validateTopicVersion(TopicVersion topicVersion) throws WikiException {
        AnsiDataHandler.checkLength(topicVersion.getAuthorDisplay(), 100);
        AnsiDataHandler.checkLength(topicVersion.getVersionParamString(), 500);
        topicVersion.setEditComment(StringUtils.substring((String)topicVersion.getEditComment(), (int)0, (int)200));
    }

    protected void validateUserDetails(WikiUserDetails userDetails) throws WikiException {
        AnsiDataHandler.checkLength(userDetails.getUsername(), 100);
        if (userDetails.getPassword() != null && userDetails.getPassword().length() > 100) {
            throw new WikiException(new WikiMessage("error.fieldlength", "-", "100"));
        }
    }

    protected void validateVirtualWiki(VirtualWiki virtualWiki) throws WikiException {
        AnsiDataHandler.checkLength(virtualWiki.getName(), 100);
        AnsiDataHandler.checkLength(virtualWiki.getRootTopicName(), 200);
        AnsiDataHandler.checkLength(virtualWiki.getLogoImageUrl(), 200);
        AnsiDataHandler.checkLength(virtualWiki.getMetaDescription(), 500);
        AnsiDataHandler.checkLength(virtualWiki.getSiteName(), 200);
    }

    protected void validateWatchlistEntry(String topicName) throws WikiException {
        AnsiDataHandler.checkLength(topicName, 200);
    }

    protected void validateWikiFile(WikiFile wikiFile) throws WikiException {
        AnsiDataHandler.checkLength(wikiFile.getFileName(), 200);
        AnsiDataHandler.checkLength(wikiFile.getUrl(), 200);
        AnsiDataHandler.checkLength(wikiFile.getMimeType(), 100);
    }

    protected void validateWikiFileVersion(WikiFileVersion wikiFileVersion) throws WikiException {
        AnsiDataHandler.checkLength(wikiFileVersion.getUrl(), 200);
        AnsiDataHandler.checkLength(wikiFileVersion.getMimeType(), 100);
        AnsiDataHandler.checkLength(wikiFileVersion.getAuthorDisplay(), 100);
        wikiFileVersion.setUploadComment(StringUtils.substring((String)wikiFileVersion.getUploadComment(), (int)0, (int)200));
    }

    protected void validateWikiGroup(WikiGroup group) throws WikiException {
        AnsiDataHandler.checkLength(group.getName(), 30);
        group.setDescription(StringUtils.substring((String)group.getDescription(), (int)0, (int)200));
    }

    protected void validateWikiUser(WikiUser user) throws WikiException {
        AnsiDataHandler.checkLength(user.getUsername(), 100);
        AnsiDataHandler.checkLength(user.getDisplayName(), 100);
        AnsiDataHandler.checkLength(user.getCreateIpAddress(), 39);
        AnsiDataHandler.checkLength(user.getLastLoginIpAddress(), 39);
        AnsiDataHandler.checkLength(user.getDefaultLocale(), 8);
        AnsiDataHandler.checkLength(user.getEmail(), 100);
        AnsiDataHandler.checkLength(user.getEditor(), 50);
        AnsiDataHandler.checkLength(user.getSignature(), 255);
    }

    @Override
    public void writeConfiguration(Map<String, String> configuration) throws DataAccessException, WikiException {
        this.validateConfiguration(configuration);
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.queryHandler().updateConfiguration(configuration, conn);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void writeFile(WikiFile wikiFile, WikiFileVersion wikiFileVersion) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            WikiUtil.validateTopicName(wikiFile.getVirtualWiki(), wikiFile.getFileName());
            if (wikiFile.getFileId() <= 0) {
                this.addWikiFile(wikiFile, conn);
            } else {
                this.updateWikiFile(wikiFile, conn);
            }
            wikiFileVersion.setFileId(wikiFile.getFileId());
            this.addWikiFileVersion(wikiFileVersion, conn);
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void writeInterwiki(Interwiki interwiki) throws DataAccessException, WikiException {
        interwiki.validate();
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.queryHandler().deleteInterwiki(interwiki, conn);
            this.queryHandler().insertInterwiki(interwiki, conn);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
        WikiCache.removeAllFromCache(CACHE_INTERWIKI_LIST);
    }

    @Override
    public void writeNamespace(Namespace mainNamespace, Namespace commentsNamespace) throws DataAccessException, WikiException {
        this.validateNamespace(mainNamespace, commentsNamespace);
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.queryHandler().updateNamespace(mainNamespace, commentsNamespace, conn);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
        WikiCache.removeAllFromCache(CACHE_NAMESPACE_LIST);
    }

    @Override
    public void writeNamespaceTranslations(List<Namespace> namespaces, String virtualWiki) throws DataAccessException, WikiException {
        int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
        for (Namespace namespace : namespaces) {
            this.validateNamespaceTranslation(namespace, virtualWiki);
        }
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.queryHandler().updateNamespaceTranslations(namespaces, virtualWiki, virtualWikiId, conn);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        DatabaseConnection.commit(status);
        WikiCache.removeAllFromCache(CACHE_NAMESPACE_LIST);
    }

    @Override
    public void writeRole(Role role, boolean update) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.validateRole(role);
            if (update) {
                this.queryHandler().updateRole(role, conn);
            } else {
                this.queryHandler().insertRole(role, conn);
            }
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void writeRoleMapGroup(int groupId, List<String> roles) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.queryHandler().deleteGroupAuthorities(groupId, conn);
            for (String authority : roles) {
                this.validateAuthority(authority);
                this.queryHandler().insertGroupAuthority(groupId, authority, conn);
            }
            WikiCache.removeAllFromCache(CACHE_ROLE_MAP_GROUP);
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void writeRoleMapUser(String username, List<String> roles) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            this.queryHandler().deleteUserAuthorities(username, conn);
            for (String authority : roles) {
                this.validateAuthority(authority);
                this.queryHandler().insertUserAuthority(username, authority, conn);
            }
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void writeTopic(Topic topic, TopicVersion topicVersion, LinkedHashMap<String, String> categories, List<String> links) throws DataAccessException, WikiException {
        long start = System.currentTimeMillis();
        WikiUtil.validateTopicName(topic.getVirtualWiki(), topic.getName());
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            if (topic.getTopicId() <= 0) {
                this.addTopic(topic, conn);
            } else if (topicVersion == null) {
                this.updateTopic(topic, conn);
            }
            if (topicVersion != null) {
                this.addTopicVersion(topic, topicVersion, conn);
                this.updateTopic(topic, conn);
                String authorName = this.authorName(topicVersion.getAuthorId(), topicVersion.getAuthorDisplay());
                LogItem logItem = LogItem.initLogItem(topic, topicVersion, authorName);
                RecentChange change = null;
                if (logItem != null) {
                    this.addLogItem(logItem, conn);
                    change = RecentChange.initRecentChange(logItem);
                } else {
                    change = RecentChange.initRecentChange(topic, topicVersion, authorName);
                }
                if (topicVersion.isRecentChangeAllowed()) {
                    this.addRecentChange(change, conn);
                }
            }
            if (categories != null) {
                this.deleteTopicCategories(topic, conn);
                if (topic.getDeleteDate() == null && !categories.isEmpty()) {
                    ArrayList<Category> categoryList = new ArrayList<Category>();
                    for (String categoryName : categories.keySet()) {
                        Category category = new Category();
                        category.setName(categoryName);
                        category.setSortKey(categories.get(categoryName));
                        category.setVirtualWiki(topic.getVirtualWiki());
                        category.setChildTopicName(topic.getName());
                        categoryList.add(category);
                    }
                    this.addCategories(categoryList, topic.getTopicId(), conn);
                }
            }
            if (links != null) {
                this.deleteTopicLinks(topic.getTopicId(), conn);
                if (topic.getDeleteDate() == null && !links.isEmpty()) {
                    this.addTopicLinks(links, topic.getTopicId(), conn);
                }
                WikiBase.getSearchEngine().updateInIndex(topic);
            }
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
        this.cacheTopicRefresh(topic);
        logger.debug("Wrote topic " + topic.getName() + " with params [categories is null: " + (categories == null) + "] / [links is null: " + (links == null) + "] in " + (double)(System.currentTimeMillis() - start) / 1000.0 + " s.");
    }

    @Override
    public void writeTopicVersion(Topic topic, TopicVersion topicVersion) throws DataAccessException, WikiException {
        Connection conn = null;
        try {
            conn = DatabaseConnection.getConnection();
            this.addTopicVersion(topic, topicVersion, conn);
        }
        catch (SQLException e) {
            throw new DataAccessException(e);
        }
        finally {
            DatabaseConnection.closeConnection(conn);
        }
    }

    @Override
    public void writeVirtualWiki(VirtualWiki virtualWiki) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            WikiUtil.validateVirtualWikiName(virtualWiki.getName());
            if (virtualWiki.getVirtualWikiId() <= 0) {
                this.addVirtualWiki(virtualWiki, conn);
            } else {
                this.updateVirtualWiki(virtualWiki, conn);
            }
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
        WikiCache.removeAllFromCache(CACHE_VIRTUAL_WIKI_LIST);
    }

    @Override
    public void writeWatchlistEntry(Watchlist watchlist, String virtualWiki, String topicName, int userId) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            int virtualWikiId = this.lookupVirtualWikiId(virtualWiki);
            String article = WikiUtil.extractTopicLink(virtualWiki, topicName);
            String comments = WikiUtil.extractCommentsLink(virtualWiki, topicName);
            if (watchlist.containsTopic(topicName)) {
                this.deleteWatchlistEntry(virtualWikiId, article, userId, conn);
                this.deleteWatchlistEntry(virtualWikiId, comments, userId, conn);
                watchlist.remove(article);
                watchlist.remove(comments);
            } else {
                this.addWatchlistEntry(virtualWikiId, article, userId, conn);
                this.addWatchlistEntry(virtualWikiId, comments, userId, conn);
                watchlist.add(article);
                watchlist.add(comments);
            }
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void writeWikiGroup(WikiGroup group) throws DataAccessException, WikiException {
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            if (group.getGroupId() <= 0) {
                this.addWikiGroup(group, conn);
            } else {
                this.updateWikiGroup(group, conn);
            }
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
    }

    @Override
    public void writeWikiUser(WikiUser user, String username, String encryptedPassword) throws DataAccessException, WikiException {
        WikiUtil.validateUserName(user.getUsername());
        TransactionStatus status = null;
        try {
            status = DatabaseConnection.startTransaction();
            Connection conn = DatabaseConnection.getConnection();
            if (user.getUserId() <= 0) {
                WikiUserDetails userDetails = new WikiUserDetails(username, encryptedPassword);
                this.addUserDetails(userDetails, conn);
                this.addWikiUser(user, conn);
                this.addGroupMember(user.getUsername(), WikiBase.getGroupRegisteredUser().getGroupId(), conn);
                List<VirtualWiki> virtualWikis = this.getVirtualWikiList();
                for (VirtualWiki virtualWiki : virtualWikis) {
                    LogItem logItem = LogItem.initLogItem(user, virtualWiki.getName());
                    this.addLogItem(logItem, conn);
                    RecentChange change = RecentChange.initRecentChange(logItem);
                    this.addRecentChange(change, conn);
                }
            } else {
                if (!StringUtils.isBlank((String)encryptedPassword)) {
                    WikiUserDetails userDetails = new WikiUserDetails(username, encryptedPassword);
                    this.updateUserDetails(userDetails, conn);
                }
                this.updateWikiUser(user, conn);
            }
        }
        catch (DataAccessException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        catch (SQLException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw new DataAccessException(e);
        }
        catch (WikiException e) {
            DatabaseConnection.rollbackOnException(status, e);
            throw e;
        }
        DatabaseConnection.commit(status);
        WikiCache.addToCache(CACHE_USER_BY_USER_ID, user.getUserId(), user);
        WikiCache.addToCache(CACHE_USER_BY_USER_NAME, user.getUsername(), user);
    }
}

