/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.ReadWriteLockDummy;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.Type;

public class IndexAVL
implements Index {
    private final long persistenceId;
    protected final HsqlNameManager.HsqlName name;
    private final boolean[] colCheck;
    final int[] colIndex;
    private final int[] defaultColMap;
    final Type[] colTypes;
    private final boolean[] colDesc;
    private final boolean[] nullsLast;
    final boolean isSimpleOrder;
    final boolean isSimple;
    protected final boolean isPK;
    protected final boolean isUnique;
    protected final boolean isConstraint;
    private final boolean isForward;
    private boolean isClustered;
    private static final IndexRowIterator emptyIterator = new IndexRowIterator(null, null, null, null, 0, false, false);
    protected TableBase table;
    int position;
    Object[] nullData;
    ReadWriteLock lock;
    Lock readLock;
    Lock writeLock;

    public IndexAVL(HsqlNameManager.HsqlName name, long id, TableBase table, int[] columns, boolean[] descending, boolean[] nullsLast, Type[] colTypes, boolean pk, boolean unique, boolean constraint, boolean forward) {
        this.persistenceId = id;
        this.name = name;
        this.colIndex = columns;
        this.colTypes = colTypes;
        this.colDesc = descending == null ? new boolean[columns.length] : descending;
        this.nullsLast = nullsLast == null ? new boolean[columns.length] : nullsLast;
        this.isPK = pk;
        this.isUnique = unique;
        this.isConstraint = constraint;
        this.isForward = forward;
        this.table = table;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.defaultColMap = new int[columns.length];
        ArrayUtil.fillSequence(this.defaultColMap);
        boolean simpleOrder = this.colIndex.length > 0;
        for (int i = 0; i < this.colDesc.length; ++i) {
            if (!this.colDesc[i] && !this.nullsLast[i]) continue;
            simpleOrder = false;
        }
        this.isSimpleOrder = simpleOrder;
        this.isSimple = this.isSimpleOrder && this.colIndex.length == 1;
        this.nullData = new Object[this.colIndex.length];
        switch (table.getTableType()) {
            case 4: 
            case 5: 
            case 7: {
                this.lock = new ReentrantReadWriteLock();
                break;
            }
            default: {
                this.lock = new ReadWriteLockDummy();
            }
        }
        this.readLock = this.lock.readLock();
        this.writeLock = this.lock.writeLock();
    }

    public int getType() {
        return 20;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    public OrderedHashSet getComponents() {
        return null;
    }

    public void compile(Session session, SchemaObject parentObject) {
    }

    public String getSQL() {
        StringBuffer sb = new StringBuffer();
        sb = new StringBuffer(64);
        sb.append("CREATE").append(' ');
        if (this.isUnique()) {
            sb.append("UNIQUE").append(' ');
        }
        sb.append("INDEX").append(' ');
        sb.append(this.getName().statementName);
        sb.append(' ').append("ON").append(' ');
        sb.append(((Table)this.table).getName().getSchemaQualifiedStatementName());
        int[] col = this.getColumns();
        int len = this.getVisibleColumns();
        sb.append(((Table)this.table).getColumnListSQL(col, len));
        return sb.toString();
    }

    public long getChangeTimestamp() {
        return 0L;
    }

    public RowIterator emptyIterator() {
        return emptyIterator;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public long getPersistenceId() {
        return this.persistenceId;
    }

    public int getVisibleColumns() {
        return this.colIndex.length;
    }

    public int getColumnCount() {
        return this.colIndex.length;
    }

    public boolean isUnique() {
        return this.isUnique;
    }

    public boolean isConstraint() {
        return this.isConstraint;
    }

    public int[] getColumns() {
        return this.colIndex;
    }

    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    public boolean[] getColumnDesc() {
        return this.colDesc;
    }

    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    public int getIndexOrderValue() {
        if (this.isPK) {
            return 0;
        }
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setTable(TableBase table) {
        this.table = table;
    }

    public void setClustered(boolean clustered) {
        this.isClustered = clustered;
    }

    public boolean isClustered() {
        return this.isClustered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(Session session, PersistentStore store) {
        this.readLock.lock();
        try {
            int n = store.elementCount(session);
            Object var5_4 = null;
            this.readLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeUnique(PersistentStore store) {
        this.readLock.lock();
        try {
            int n = store.elementCountUnique(this);
            Object var4_3 = null;
            this.readLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNodeCount(Session session, PersistentStore store) {
        int count = 0;
        this.readLock.lock();
        try {
            RowIterator it = this.firstRow(session, store);
            while (it.hasNext()) {
                it.getNextRow();
                ++count;
            }
            int n = count;
            Object var7_6 = null;
            this.readLock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(PersistentStore store) {
        this.readLock.lock();
        try {
            boolean bl = this.getAccessor(store) == null;
            Object var4_3 = null;
            this.readLock.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkIndex(PersistentStore store) {
        this.readLock.lock();
        try {
            NodeAVL p;
            NodeAVL f = null;
            for (p = this.getAccessor(store); p != null; p = p.getLeft(store)) {
                f = p;
                this.checkNodes(store, p);
            }
            p = f;
            while (f != null) {
                this.checkNodes(store, f);
                f = this.next(store, f);
            }
            Object var5_4 = null;
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    void checkNodes(PersistentStore store, NodeAVL p) {
        NodeAVL l = p.getLeft(store);
        NodeAVL r = p.getRight(store);
        if (l != null && l.getBalance(store) == -2) {
            System.out.print("broken index - deleted");
        }
        if (r != null && r.getBalance(store) == -2) {
            System.out.print("broken index -deleted");
        }
        if (l != null && !p.equals(l.getParent(store))) {
            System.out.print("broken index - no parent");
        }
        if (r != null && !p.equals(r.getParent(store))) {
            System.out.print("broken index - no parent");
        }
    }

    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap) {
        int fieldcount = rowColMap.length;
        for (int j = 0; j < fieldcount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int[] rowColMap, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[rowColMap[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public int compareRowNonUnique(Session session, Object[] a, Object[] b, int fieldCount) {
        for (int j = 0; j < fieldCount; ++j) {
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            return i;
        }
        return 0;
    }

    public int compareRow(Session session, Object[] a, Object[] b) {
        for (int j = 0; j < this.colIndex.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.colIndex[j]] == null || b[this.colIndex[j]] == null;
            if (this.colDesc[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        return 0;
    }

    int compareRowForInsertOrDelete(Session session, Row newRow, Row existingRow, boolean useRowId, int start) {
        Object[] a = newRow.getData();
        Object[] b = existingRow.getData();
        for (int j = start; j < this.colIndex.length; ++j) {
            boolean nulls;
            int i = this.colTypes[j].compare(session, a[this.colIndex[j]], b[this.colIndex[j]]);
            if (i == 0) continue;
            if (this.isSimpleOrder) {
                return i;
            }
            boolean bl = nulls = a[this.colIndex[j]] == null || b[this.colIndex[j]] == null;
            if (this.colDesc[j] && !nulls) {
                i = -i;
            }
            if (this.nullsLast[j] && nulls) {
                i = -i;
            }
            return i;
        }
        if (useRowId) {
            return newRow.getPos() - existingRow.getPos();
        }
        return 0;
    }

    int compareObject(Session session, Object[] a, Object[] b, int[] rowColMap, int position) {
        return this.colTypes[position].compare(session, a[this.colIndex[position]], b[rowColMap[position]]);
    }

    boolean hasNulls(Session session, Object[] rowData) {
        if (this.colIndex.length == 1) {
            return rowData[this.colIndex[0]] == null;
        }
        boolean normal = session == null ? true : session.database.sqlUniqueNulls;
        for (int j = 0; j < this.colIndex.length; ++j) {
            if (rowData[this.colIndex[j]] == null) {
                if (!normal) continue;
                return true;
            }
            if (normal) continue;
            return false;
        }
        return !normal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Session session, PersistentStore store, Row row) {
        boolean isleft = true;
        int compare = -1;
        boolean compareRowId = !this.isUnique || this.hasNulls(session, row.getData());
        this.writeLock.lock();
        store.writeLock();
        try {
            NodeAVL n;
            NodeAVL x = n = this.getAccessor(store);
            if (n == null) {
                store.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
                Object var12_9 = null;
                store.writeUnlock();
                this.writeLock.unlock();
                return;
            }
            do {
                Row currentRow;
                if ((compare = this.compareRowForInsertOrDelete(session, row, currentRow = n.getRow(store), compareRowId, 0)) == 0 && session != null && !compareRowId && session.database.txManager.isMVRows() && !this.isEqualReadable(session, store, n)) {
                    compareRowId = true;
                    compare = this.compareRowForInsertOrDelete(session, row, currentRow, compareRowId, this.colIndex.length);
                }
                if (compare != 0) continue;
                Constraint c = null;
                if (this.isConstraint) {
                    c = ((Table)this.table).getUniqueConstraintForIndex(this);
                }
                if (c == null) {
                    throw Error.error(104, this.name.statementName);
                }
                throw c.getException(row.getData());
            } while ((n = (x = n).child(store, isleft = compare < 0)) != null);
            x = x.set(store, isleft, ((RowAVL)row).getNode(this.position));
            this.balance(store, x, isleft);
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            store.writeUnlock();
            this.writeLock.unlock();
            throw throwable;
        }
        Object var12_10 = null;
        store.writeUnlock();
        this.writeLock.unlock();
    }

    public void delete(Session session, PersistentStore store, Row row) {
        NodeAVL node;
        if (!row.isInMemory()) {
            row = (Row)store.get(row, false);
        }
        if ((node = ((RowAVL)row).getNode(this.position)) != null) {
            this.delete(store, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void delete(PersistentStore store, NodeAVL x) {
        block28: {
            block27: {
                if (x == null) {
                    return;
                }
                this.writeLock.lock();
                store.writeLock();
                try {
                    NodeAVL n;
                    if (x.getLeft(store) == null) {
                        n = x.getRight(store);
                    } else if (x.getRight(store) == null) {
                        n = x.getLeft(store);
                    } else {
                        NodeAVL dl;
                        NodeAVL dp;
                        NodeAVL xp;
                        NodeAVL d;
                        block25: {
                            d = x;
                            x = x.getLeft(store);
                            while (true) {
                                NodeAVL temp;
                                if ((temp = x.getRight(store)) == null) {
                                    n = x.getLeft(store);
                                    int b = x.getBalance(store);
                                    x = x.setBalance(store, d.getBalance(store));
                                    d = d.setBalance(store, b);
                                    xp = x.getParent(store);
                                    dp = d.getParent(store);
                                    if (d.isRoot(store)) {
                                        break;
                                    }
                                    break block25;
                                }
                                x = temp;
                            }
                            store.setAccessor((Index)this, x);
                        }
                        x = x.setParent(store, dp);
                        if (dp != null) {
                            dp = dp.isRight(d) ? dp.setRight(store, x) : dp.setLeft(store, x);
                        }
                        if (d.equals(xp)) {
                            if ((d = d.setParent(store, x)).isLeft(x)) {
                                x = x.setLeft(store, d);
                                NodeAVL dr = d.getRight(store);
                                x = x.setRight(store, dr);
                            } else {
                                x = x.setRight(store, d);
                                dl = d.getLeft(store);
                                x = x.setLeft(store, dl);
                            }
                        } else {
                            d = d.setParent(store, xp);
                            xp = xp.setRight(store, d);
                            dl = d.getLeft(store);
                            NodeAVL dr = d.getRight(store);
                            x = x.setLeft(store, dl);
                            x = x.setRight(store, dr);
                        }
                        x.getRight(store).setParent(store, x);
                        x.getLeft(store).setParent(store, x);
                        d = d.setLeft(store, n);
                        if (n != null) {
                            n = n.setParent(store, d);
                        }
                        x = d = d.setRight(store, null);
                    }
                    boolean isleft = x.isFromLeft(store);
                    x.replace(store, this, n);
                    n = x.getParent(store);
                    x.delete();
                    while (n != null) {
                        x = n;
                        int sign = isleft ? 1 : -1;
                        switch (x.getBalance(store) * sign) {
                            case -1: {
                                x = x.setBalance(store, 0);
                                break;
                            }
                            case 0: {
                                x = x.setBalance(store, sign);
                                Object var11_13 = null;
                                store.writeUnlock();
                                this.writeLock.unlock();
                                return;
                            }
                            case 1: {
                                NodeAVL r = x.child(store, !isleft);
                                int b = r.getBalance(store);
                                if (b * sign >= 0) {
                                    x.replace(store, this, r);
                                    NodeAVL child = r.child(store, isleft);
                                    x = x.set(store, !isleft, child);
                                    r = r.set(store, isleft, x);
                                    if (b == 0) {
                                        x = x.setBalance(store, sign);
                                        r = r.setBalance(store, -sign);
                                        break block27;
                                    } else {
                                        x = x.setBalance(store, 0);
                                        x = r = r.setBalance(store, 0);
                                        break;
                                    }
                                }
                                NodeAVL l = r.child(store, isleft);
                                x.replace(store, this, l);
                                b = l.getBalance(store);
                                r = r.set(store, isleft, l.child(store, !isleft));
                                l = l.set(store, !isleft, r);
                                x = x.set(store, !isleft, l.child(store, isleft));
                                l = l.set(store, isleft, x);
                                x = x.setBalance(store, b == sign ? -sign : 0);
                                r = r.setBalance(store, b == -sign ? sign : 0);
                                x = l = l.setBalance(store, 0);
                                break;
                            }
                        }
                        isleft = x.isFromLeft(store);
                        n = x.getParent(store);
                    }
                    break block28;
                }
                catch (Throwable throwable) {
                    Object var11_16 = null;
                    store.writeUnlock();
                    this.writeLock.unlock();
                    throw throwable;
                }
            }
            Object var11_14 = null;
            store.writeUnlock();
            this.writeLock.unlock();
            return;
        }
        Object var11_15 = null;
        store.writeUnlock();
        this.writeLock.unlock();
    }

    public boolean existsParent(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        NodeAVL node = this.findNode(session, store, rowdata, rowColMap, rowColMap.length, 41, 2, false);
        return node != null;
    }

    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int matchCount, int distinctCount, int compareType, boolean reversed, boolean[] map) {
        if (compareType == 74) {
            return this.lastRow(session, store);
        }
        NodeAVL node = this.findNode(session, store, rowdata, this.defaultColMap, matchCount, compareType, 0, reversed);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, distinctCount, false, reversed);
    }

    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata) {
        NodeAVL node = this.findNode(session, store, rowdata, this.colIndex, this.colIndex.length, 41, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    public RowIterator findFirstRow(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap) {
        NodeAVL node = this.findNode(session, store, rowdata, rowColMap, rowColMap.length, 41, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    public RowIterator findFirstRowNotNull(Session session, PersistentStore store) {
        NodeAVL node = this.findNode(session, store, this.nullData, this.defaultColMap, 1, 48, 0, false);
        if (node == null) {
            return emptyIterator;
        }
        return new IndexRowIterator(session, store, this, node, 0, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator firstRow(Session session, PersistentStore store) {
        IndexRowIterator indexRowIterator;
        NodeAVL x;
        block5: {
            this.readLock.lock();
            try {
                Row row;
                NodeAVL l = x = this.getAccessor(store);
                while (l != null) {
                    x = l;
                    l = x.getLeft(store);
                }
                while (session != null && x != null && !session.database.txManager.canRead(session, row = x.getRow(store), 0, null)) {
                    x = this.next(store, x);
                }
                if (x != null) break block5;
                indexRowIterator = emptyIterator;
                Object var7_6 = null;
                this.readLock.unlock();
                return indexRowIterator;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        indexRowIterator = new IndexRowIterator(session, store, this, x, 0, false, false);
        Object var7_7 = null;
        this.readLock.unlock();
        return indexRowIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator firstRow(PersistentStore store) {
        NodeAVL x;
        block4: {
            this.readLock.lock();
            try {
                NodeAVL l = x = this.getAccessor(store);
                while (l != null) {
                    x = l;
                    l = x.getLeft(store);
                }
                if (x != null) break block4;
                IndexRowIterator indexRowIterator = emptyIterator;
                Object var6_6 = null;
                this.readLock.unlock();
                return indexRowIterator;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(null, store, this, x, 0, false, false);
        Object var6_7 = null;
        this.readLock.unlock();
        return indexRowIterator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowIterator lastRow(Session session, PersistentStore store) {
        IndexRowIterator indexRowIterator;
        NodeAVL x;
        block5: {
            this.readLock.lock();
            try {
                Row row;
                NodeAVL l = x = this.getAccessor(store);
                while (l != null) {
                    x = l;
                    l = x.getRight(store);
                }
                while (session != null && x != null && !session.database.txManager.canRead(session, row = x.getRow(store), 0, null)) {
                    x = this.last(store, x);
                }
                if (x != null) break block5;
                indexRowIterator = emptyIterator;
                Object var7_6 = null;
                this.readLock.unlock();
                return indexRowIterator;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.readLock.unlock();
                throw throwable;
            }
        }
        indexRowIterator = new IndexRowIterator(session, store, this, x, 0, false, true);
        Object var7_7 = null;
        this.readLock.unlock();
        return indexRowIterator;
    }

    NodeAVL next(Session session, PersistentStore store, NodeAVL x, int distinctCount) {
        Row row;
        if (x == null) {
            return null;
        }
        do {
            if (distinctCount != 0) {
                Object[] baseData = x.getData(store);
                return this.findNode(session, store, baseData, this.colIndex, distinctCount, 43, 0, false);
            }
            x = this.next(store, x);
            if (x == null) {
                return x;
            }
            if (session != null) continue;
            return x;
        } while (!session.database.txManager.canRead(session, row = x.getRow(store), 0, null));
        return x;
    }

    NodeAVL last(Session session, PersistentStore store, NodeAVL x, int distinctCount) {
        Row row;
        if (x == null) {
            return null;
        }
        do {
            if (distinctCount != 0) {
                Object[] baseData = x.getData(store);
                return this.findNode(session, store, baseData, this.colIndex, distinctCount, 44, 0, false);
            }
            x = this.last(store, x);
            if (x == null) {
                return x;
            }
            if (session != null) continue;
            return x;
        } while (!session.database.txManager.canRead(session, row = x.getRow(store), 0, null));
        return x;
    }

    NodeAVL next(PersistentStore store, NodeAVL x) {
        NodeAVL temp = x.getRight(store);
        if (temp != null) {
            x = temp;
            temp = x.getLeft(store);
            while (temp != null) {
                x = temp;
                temp = x.getLeft(store);
            }
            return x;
        }
        temp = x;
        for (x = x.getParent(store); x != null && x.isRight(temp); x = x.getParent(store)) {
            temp = x;
        }
        return x;
    }

    NodeAVL last(PersistentStore store, NodeAVL x) {
        if (x == null) {
            return null;
        }
        NodeAVL temp = x.getLeft(store);
        if (temp != null) {
            x = temp;
            temp = x.getRight(store);
            while (temp != null) {
                x = temp;
                temp = x.getRight(store);
            }
            return x;
        }
        temp = x;
        for (x = x.getParent(store); x != null && x.isLeft(temp); x = x.getParent(store)) {
            temp = x;
        }
        return x;
    }

    boolean isEqualReadable(Session session, PersistentStore store, NodeAVL node) {
        Row row;
        Object[] nodeData;
        NodeAVL c = node;
        if (session.database.txManager.canRead(session, node.getRow(store), 1, null)) {
            return true;
        }
        Object[] data = node.getData(store);
        while ((c = this.last(store, c)) != null && this.compareRow(session, data, nodeData = c.getData(store)) == 0) {
            row = c.getRow(store);
            if (!session.database.txManager.canRead(session, row, 1, null)) continue;
            return true;
        }
        while ((c = this.next(session, store, node, 0)) != null && this.compareRow(session, data, nodeData = c.getData(store)) == 0) {
            row = c.getRow(store);
            if (!session.database.txManager.canRead(session, row, 1, null)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore store, Object[] rowdata, int[] rowColMap, int fieldCount, int compareType, int readMode, boolean reversed) {
        Row currentRow;
        NodeAVL result;
        block23: {
            this.readLock.lock();
            NodeAVL x = this.getAccessor(store);
            NodeAVL n = null;
            result = null;
            currentRow = null;
            if (compareType != 41 && compareType != 47) {
                --fieldCount;
            }
            while (x != null) {
                currentRow = x.getRow(store);
                int i = 0;
                if (fieldCount > 0) {
                    i = this.compareRowNonUnique(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                }
                if (i == 0) {
                    switch (compareType) {
                        case 41: 
                        case 47: {
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 43: 
                        case 48: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i <= 0) {
                                n = x.getRight(store);
                                break;
                            }
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 42: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i < 0) {
                                n = x.getRight(store);
                                break;
                            }
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        case 44: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i < 0) {
                                result = x;
                                n = x.getRight(store);
                                break;
                            }
                            n = x.getLeft(store);
                            break;
                        }
                        case 45: {
                            i = this.compareObject(session, currentRow.getData(), rowdata, rowColMap, fieldCount);
                            if (i <= 0) {
                                result = x;
                                n = x.getRight(store);
                                break;
                            }
                            n = x.getLeft(store);
                            break;
                        }
                        default: {
                            Error.runtimeError(201, "Index");
                            break;
                        }
                    }
                } else if (i < 0) {
                    n = x.getRight(store);
                } else if (i > 0) {
                    n = x.getLeft(store);
                }
                if (n == null) break;
                x = n;
            }
            if (session != null) break block23;
            NodeAVL nodeAVL = result;
            Object var15_16 = null;
            this.readLock.unlock();
            return nodeAVL;
        }
        try {
            while (result != null && !session.database.txManager.canRead(session, currentRow = result.getRow(store), readMode, this.colIndex)) {
                NodeAVL nodeAVL = result = reversed ? this.last(store, result) : this.next(store, result);
                if (result == null) break;
                currentRow = result.getRow(store);
                if (fieldCount <= 0 || this.compareRowNonUnique(session, currentRow.getData(), rowdata, rowColMap, fieldCount) == 0) continue;
                result = null;
                break;
            }
            NodeAVL nodeAVL = result;
            Object var15_17 = null;
            this.readLock.unlock();
            return nodeAVL;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore store, Object data, int compareType, int readMode) {
        Row currentRow;
        NodeAVL result;
        block14: {
            this.readLock.lock();
            NodeAVL x = this.getAccessor(store);
            NodeAVL n = null;
            result = null;
            currentRow = null;
            while (x != null) {
                currentRow = x.getRow(store);
                int i = this.colTypes[0].compare(session, data, currentRow.getData()[this.colIndex[0]]);
                switch (compareType) {
                    case 41: 
                    case 47: {
                        if (i == 0) {
                            result = x;
                            n = x.getLeft(store);
                            break;
                        }
                        if (i > 0) {
                            n = x.getRight(store);
                            break;
                        }
                        if (i >= 0) break;
                        n = x.getLeft(store);
                        break;
                    }
                    case 43: 
                    case 48: {
                        if (i >= 0) {
                            n = x.getRight(store);
                            break;
                        }
                        result = x;
                        n = x.getLeft(store);
                        break;
                    }
                    case 42: {
                        if (i > 0) {
                            n = x.getRight(store);
                            break;
                        }
                        result = x;
                        n = x.getLeft(store);
                        break;
                    }
                    default: {
                        Error.runtimeError(201, "Index");
                    }
                }
                if (n == null) break;
                x = n;
            }
            if (session != null) break block14;
            NodeAVL nodeAVL = result;
            Object var12_13 = null;
            this.readLock.unlock();
            return nodeAVL;
        }
        try {
            while (result != null && !session.database.txManager.canRead(session, currentRow = result.getRow(store), readMode, this.colIndex)) {
                result = this.next(store, result);
                if (compareType != 41 || this.colTypes[0].compare(session, data, currentRow.getData()[this.colIndex[0]]) == 0) continue;
                result = null;
                break;
            }
            NodeAVL nodeAVL = result;
            Object var12_14 = null;
            this.readLock.unlock();
            return nodeAVL;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.readLock.unlock();
            throw throwable;
        }
    }

    void balance(PersistentStore store, NodeAVL x, boolean isleft) {
        while (true) {
            int sign = isleft ? 1 : -1;
            switch (x.getBalance(store) * sign) {
                case 1: {
                    x = x.setBalance(store, 0);
                    return;
                }
                case 0: {
                    x = x.setBalance(store, -sign);
                    break;
                }
                case -1: {
                    NodeAVL l = x.child(store, isleft);
                    if (l.getBalance(store) == -sign) {
                        x.replace(store, this, l);
                        x = x.set(store, isleft, l.child(store, !isleft));
                        l = l.set(store, !isleft, x);
                        x = x.setBalance(store, 0);
                        l = l.setBalance(store, 0);
                    } else {
                        NodeAVL r = l.child(store, !isleft);
                        x.replace(store, this, r);
                        l = l.set(store, !isleft, r.child(store, isleft));
                        r = r.set(store, isleft, l);
                        x = x.set(store, isleft, r.child(store, !isleft));
                        r = r.set(store, !isleft, x);
                        int rb = r.getBalance(store);
                        x = x.setBalance(store, rb == -sign ? sign : 0);
                        l = l.setBalance(store, rb == sign ? -sign : 0);
                        r = r.setBalance(store, 0);
                    }
                    return;
                }
            }
            if (x.isRoot(store)) {
                return;
            }
            isleft = x.isFromLeft(store);
            x = x.getParent(store);
        }
    }

    NodeAVL getAccessor(PersistentStore store) {
        NodeAVL node = (NodeAVL)store.getAccessor(this);
        return node;
    }

    IndexRowIterator getIterator(Session session, PersistentStore store, NodeAVL x, boolean single, boolean reversed) {
        if (x == null) {
            return emptyIterator;
        }
        IndexRowIterator it = new IndexRowIterator(session, store, this, x, 0, single, reversed);
        return it;
    }

    public static final class IndexRowIterator
    implements RowIterator {
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        NodeAVL nextnode;
        Row lastrow;
        int distinctCount;
        boolean single;
        boolean reversed;

        public IndexRowIterator(Session session, PersistentStore store, IndexAVL index, NodeAVL node, int distinctCount, boolean single, boolean reversed) {
            this.session = session;
            this.store = store;
            this.index = index;
            this.distinctCount = distinctCount;
            this.single = single;
            this.reversed = reversed;
            if (index == null) {
                return;
            }
            this.nextnode = node;
        }

        public boolean hasNext() {
            return this.nextnode != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Row getNextRow() {
            if (this.nextnode == null) {
                this.release();
                return null;
            }
            NodeAVL lastnode = this.nextnode;
            if (this.single) {
                this.nextnode = null;
            } else {
                this.index.readLock.lock();
                this.store.writeLock();
                try {
                    this.nextnode = this.reversed ? this.index.last(this.session, this.store, this.nextnode, this.distinctCount) : this.index.next(this.session, this.store, this.nextnode, this.distinctCount);
                    Object var3_2 = null;
                    this.store.writeUnlock();
                    this.index.readLock.unlock();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    this.store.writeUnlock();
                    this.index.readLock.unlock();
                    throw throwable;
                }
            }
            this.lastrow = lastnode.getRow(this.store);
            return this.lastrow;
        }

        public Object[] getNext() {
            Row row = this.getNextRow();
            return row == null ? null : row.getData();
        }

        public void remove() {
            this.store.delete(this.session, this.lastrow);
            this.store.remove(this.lastrow.getPos());
        }

        public void release() {
        }

        public boolean setRowColumns(boolean[] columns) {
            return false;
        }

        public long getRowId() {
            return this.nextnode.getPos();
        }
    }
}

