/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.sql.Blob;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.Type;

public final class BlobType
extends BinaryType {
    public static final long maxBlobPrecision = 0x10000000000L;
    public static final int defaultBlobSize = 0x1000000;

    public BlobType(long precision) {
        super(30, precision);
    }

    public int displaySize() {
        return this.precision > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.precision;
    }

    public int getJDBCTypeCode() {
        return 2004;
    }

    public Class getJDBCClass() {
        return Blob.class;
    }

    public String getJDBCClassName() {
        return "java.sql.Blob";
    }

    public String getNameString() {
        return "BLOB";
    }

    public String getFullNameString() {
        return "BINARY LARGE OBJECT";
    }

    public String getDefinition() {
        long factor = this.precision;
        String multiplier = null;
        if (this.precision % 0x40000000L == 0L) {
            factor = this.precision / 0x40000000L;
            multiplier = "G";
        } else if (this.precision % 0x100000L == 0L) {
            factor = this.precision / 0x100000L;
            multiplier = "M";
        } else if (this.precision % 1024L == 0L) {
            factor = this.precision / 1024L;
            multiplier = "K";
        }
        StringBuffer sb = new StringBuffer(16);
        sb.append(this.getNameString());
        sb.append('(');
        sb.append(factor);
        if (multiplier != null) {
            sb.append(multiplier);
        }
        sb.append(')');
        return sb.toString();
    }

    public boolean acceptsPrecision() {
        return true;
    }

    public boolean requiresPrecision() {
        return false;
    }

    public long getMaxPrecision() {
        return 0x10000000000L;
    }

    public boolean isBinaryType() {
        return true;
    }

    public boolean isLobType() {
        return true;
    }

    public int compare(Session session, Object a, Object b) {
        if (a == b) {
            return 0;
        }
        if (a == null) {
            return -1;
        }
        if (b == null) {
            return 1;
        }
        if (b instanceof BinaryData) {
            return session.database.lobManager.compare((BlobData)a, ((BlobData)b).getBytes());
        }
        return session.database.lobManager.compare((BlobData)a, (BlobData)b);
    }

    public Object convertToTypeLimits(SessionInterface session, Object a) {
        return a;
    }

    public Object convertToType(SessionInterface session, Object a, Type otherType) {
        if (a == null) {
            return null;
        }
        if (otherType.typeCode == 30) {
            return a;
        }
        if (otherType.typeCode == 60 || otherType.typeCode == 61) {
            BlobData b = (BlobData)a;
            BlobDataID blob = session.createBlob(b.length(session));
            blob.setBytes(session, 0L, b.getBytes());
            return blob;
        }
        throw Error.error(5561);
    }

    public Object convertToDefaultType(SessionInterface session, Object a) {
        if (a == null) {
            return a;
        }
        if (a instanceof byte[]) {
            return new BinaryData((byte[])a, false);
        }
        throw Error.error(5561);
    }

    public String convertToString(Object a) {
        if (a == null) {
            return null;
        }
        byte[] bytes = ((BlobData)a).getBytes();
        return StringConverter.byteArrayToHexString(bytes);
    }

    public String convertToSQLString(Object a) {
        if (a == null) {
            return "NULL";
        }
        byte[] bytes = ((BlobData)a).getBytes();
        return StringConverter.byteArrayToSQLHexString(bytes);
    }

    public Object convertJavaToSQL(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof JDBCBlobClient) {
            return ((JDBCBlobClient)a).getBlob();
        }
        throw Error.error(5561);
    }

    public Object convertSQLToJava(SessionInterface session, Object a) {
        if (a == null) {
            return null;
        }
        if (a instanceof BlobDataID) {
            BlobDataID blob = (BlobDataID)a;
            return new JDBCBlobClient(session, blob);
        }
        throw Error.error(5561);
    }
}

