/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pwd;

import com.liferay.portal.PwdEncryptorException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.security.pwd.PasswordEncryptorUtil;
import com.liferay.portal.util.PropsUtil;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PwdAuthenticator {
    public static boolean authenticate(String login, String clearTextPassword, String currentEncryptedPassword) throws PwdEncryptorException, SystemException {
        String encryptedPassword = PasswordEncryptorUtil.encrypt(clearTextPassword, currentEncryptedPassword);
        if (currentEncryptedPassword.equals(encryptedPassword)) {
            return true;
        }
        if (GetterUtil.getBoolean((String)PropsUtil.get("auth.mac.allow"))) {
            try {
                MessageDigest digester = MessageDigest.getInstance(PropsUtil.get("auth.mac.algorithm"));
                digester.update(login.getBytes("UTF-8"));
                String shardKey = PropsUtil.get("auth.mac.shared.key");
                encryptedPassword = Base64.encode((byte[])digester.digest(shardKey.getBytes("UTF-8")));
                return currentEncryptedPassword.equals(encryptedPassword);
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SystemException((Throwable)nsae);
            }
            catch (UnsupportedEncodingException uee) {
                throw new SystemException((Throwable)uee);
            }
        }
        return false;
    }
}

