/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.util;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.templateparser.BaseTransformerListener;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.service.JournalArticleLocalServiceUtil;
import java.util.List;
import java.util.Map;

public class ContentTransformerListener
extends BaseTransformerListener {
    private static Log _log = LogFactoryUtil.getLog(ContentTransformerListener.class);

    public String onScript(String script, String xml, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onScript");
        }
        return this.injectEditInPlace(xml, script);
    }

    public String onXml(String xml, String languageId, Map<String, String> tokens) {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)"onXml");
        }
        return this.replace(xml, tokens);
    }

    protected String getDynamicContent(String xml, String elementName) {
        String content = null;
        try {
            Document document = SAXReaderUtil.read((String)xml);
            Element rootElement = document.getRootElement();
            for (Element element : rootElement.elements()) {
                String curElementName = element.attributeValue("name", "");
                if (!curElementName.equals(elementName)) continue;
                content = element.elementText("dynamic-content");
                break;
            }
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        return GetterUtil.getString(content);
    }

    protected String injectEditInPlace(String xml, String script) {
        block3: {
            try {
                Document document = SAXReaderUtil.read((String)xml);
                List nodes = document.selectNodes("//dynamic-element");
                for (Node node : nodes) {
                    Element element = (Element)node;
                    String name = GetterUtil.getString((String)element.attributeValue("name"));
                    String type = GetterUtil.getString((String)element.attributeValue("type"));
                    if (name.startsWith("reserved-") || !type.equals("text") && !type.equals("text_area") && !type.equals("text_box")) continue;
                    script = this.wrapEditInPlaceField(script, name, type, "data");
                    script = this.wrapEditInPlaceField(script, name, type, "getData()");
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)e2.getMessage());
            }
        }
        return script;
    }

    protected void replace(Element root, Map<String, String> tokens) throws Exception {
        long articleGroupId = GetterUtil.getLong((String)tokens.get("article_group_id"));
        for (Element el : root.elements()) {
            Element dynamicContent = el.element("dynamic-content");
            if (dynamicContent != null) {
                String text = dynamicContent.getText();
                text = HtmlUtil.stripComments((String)text);
                text = HtmlUtil.stripHtml((String)text);
                if (Validator.isNotNull((String)(text = text.trim())) && text.length() >= 7 && text.startsWith("[@") && text.endsWith("@]")) {
                    int pos = (text = text.substring(2, text.length() - 2)).indexOf(";");
                    if (pos != -1) {
                        String articleId = text.substring(0, pos);
                        String elementName = text.substring(pos + 1);
                        JournalArticle article = JournalArticleLocalServiceUtil.getArticle((long)articleGroupId, (String)articleId);
                        dynamicContent.clearContent();
                        dynamicContent.addCDATA(this.getDynamicContent(article.getContent(), elementName));
                    }
                } else if (text != null && text.startsWith("/image/journal/article?img_id")) {
                    dynamicContent.setText("@cdn_host@@root_path@" + text);
                }
            }
            this.replace(el, tokens);
        }
    }

    protected String replace(String xml, Map<String, String> tokens) {
        block2: {
            try {
                Document document = SAXReaderUtil.read((String)xml);
                Element rootElement = document.getRootElement();
                this.replace(rootElement, tokens);
                xml = DDMXMLUtil.formatXML((Document)document);
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)e2.getMessage());
            }
        }
        return xml;
    }

    protected String wrapEditInPlaceField(String script, String name, String type, String call) {
        String field = "$" + name + "." + call;
        String wrappedField = "<span class=\"journal-content-eip-" + type + "\" " + "id=\"journal-content-field-name-" + name + "\">" + field + "</span>";
        return StringUtil.replace((String)script, (String)("$editInPlace(" + field + ")"), (String)wrappedField);
    }
}

