/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.key.passwd.swing;

import de.schlichtherle.key.passwd.swing.AuthenticationPanel;
import de.schlichtherle.key.passwd.swing.Feedback;
import de.schlichtherle.key.passwd.swing.PromptingKeyProviderUI;
import de.schlichtherle.key.passwd.swing.WeakKeyException;
import de.schlichtherle.swing.EnhancedPanel;
import de.schlichtherle.swing.event.PanelEvent;
import de.schlichtherle.swing.event.PanelListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.zip.Deflater;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CreateKeyPanel
extends EnhancedPanel {
    private static final String CLASS_NAME;
    private static final ResourceBundle resources;
    private static final int MIN_PASSWD_LEN = 6;
    private final Color defaultForeground;
    private JComponent extraDataUI;
    private Feedback feedback;
    private AuthenticationPanel authenticationPanel;
    private JLabel error;
    private JPasswordField newPasswd1;
    private JLabel newPasswd1Label;
    private JPasswordField newPasswd2;
    private JLabel newPasswd2Label;
    private EnhancedPanel newPasswdPanel;
    private JTextPane resourceID;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CreateKeyPanel() {
        this.initComponents();
        DocumentListener dl = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CreateKeyPanel.this.setError(null);
            }

            public void removeUpdate(DocumentEvent e) {
                CreateKeyPanel.this.setError(null);
            }

            public void changedUpdate(DocumentEvent e) {
                CreateKeyPanel.this.setError(null);
            }
        };
        this.newPasswd1.getDocument().addDocumentListener(dl);
        this.newPasswd2.getDocument().addDocumentListener(dl);
        this.authenticationPanel.getKeyFileDocument().addDocumentListener(dl);
        this.defaultForeground = this.resourceID.getForeground();
    }

    private Font getBoldFont() {
        Font font = this.resourceID.getFont();
        return new Font(font.getName(), 1, font.getSize());
    }

    public String getResourceID() {
        return this.resourceID.getText();
    }

    public void setResourceID(String resourceID) {
        String lastResourceID = PromptingKeyProviderUI.lastResourceID;
        if (!lastResourceID.equals(resourceID) && !"".equals(lastResourceID)) {
            this.resourceID.setForeground(Color.RED);
        } else {
            this.resourceID.setForeground(this.defaultForeground);
        }
        this.resourceID.setText(resourceID);
        PromptingKeyProviderUI.lastResourceID = resourceID;
    }

    public Object getCreateKey() {
        try {
            switch (this.authenticationPanel.getAuthenticationMethod()) {
                case 0: {
                    char[] newPasswd1Content = this.newPasswd1.getPassword();
                    char[] newPasswd2Content = this.newPasswd2.getPassword();
                    if (Arrays.equals(newPasswd1Content, newPasswd2Content)) {
                        Arrays.fill(newPasswd2Content, '\u0000');
                        this.checkPasswdCreateKey(newPasswd1Content);
                        this.setError(null);
                        return newPasswd1Content;
                    }
                    this.setError(resources.getString("passwd.noMatch"));
                    return null;
                }
                case 1: {
                    byte[] key;
                    String keyFilePathname = this.authenticationPanel.getKeyFilePath();
                    if (new File(keyFilePathname).canWrite()) {
                        this.setError(resources.getString("keyFile.canWrite"));
                        return null;
                    }
                    try {
                        key = PromptingKeyProviderUI.readKeyFile(keyFilePathname);
                    }
                    catch (EOFException failure) {
                        this.setError(resources.getString("keyFile.eofException"));
                        return null;
                    }
                    catch (FileNotFoundException failure) {
                        this.setError(resources.getString("keyFile.fileNotFoundException"));
                        return null;
                    }
                    catch (IOException failure) {
                        this.setError(resources.getString("keyFile.ioException"));
                        return null;
                    }
                    this.checkKeyFileCreateKey(key);
                    this.setError(null);
                    return key;
                }
            }
            throw new AssertionError((Object)"Unsupported authentication method!");
        }
        catch (WeakKeyException failure) {
            this.setError(failure.getLocalizedMessage());
            return null;
        }
    }

    public void resetCreateKey() {
        this.resetPasswd();
        this.setError(null);
    }

    public void resetPasswd() {
        this.newPasswd1.setText(null);
        this.newPasswd2.setText(null);
    }

    protected void checkKeyFileCreateKey(byte[] createKey) throws WeakKeyException {
        Deflater def = new Deflater();
        def.setInput(createKey);
        def.finish();
        if (!$assertionsDisabled && def.getTotalOut() != 0) {
            throw new AssertionError();
        }
        int n = def.deflate(new byte[createKey.length * 2]);
        if (!$assertionsDisabled && def.getTotalOut() != n) {
            throw new AssertionError();
        }
        def.end();
        if (n < 64) {
            throw new WeakKeyException(CreateKeyPanel.localizedMessage(resources, "keyFile.badEntropy", null));
        }
    }

    protected void checkPasswdCreateKey(char[] createKey) throws WeakKeyException {
        if (createKey.length < 6) {
            throw new WeakKeyException(CreateKeyPanel.localizedMessage(resources, "passwd.tooShort", new Integer(6)));
        }
    }

    static final String localizedMessage(ResourceBundle resources, String key, Object param) {
        return param != null ? MessageFormat.format(resources.getString(key), param) : resources.getString(key);
    }

    public String getError() {
        String error = this.error.getText();
        return error.trim().length() > 0 ? error : null;
    }

    public void setError(String error) {
        this.error.setText(error != null ? error : " ");
    }

    public JComponent getExtraDataUI() {
        return this.extraDataUI;
    }

    public void setExtraDataUI(JComponent extraDataUI) {
        if (this.extraDataUI == extraDataUI) {
            return;
        }
        if (this.extraDataUI != null) {
            this.remove(this.extraDataUI);
        }
        if (extraDataUI != null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(15, 0, 0, 0);
            this.add((Component)extraDataUI, gridBagConstraints);
        }
        this.extraDataUI = extraDataUI;
        this.revalidate();
    }

    public Feedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(Feedback feedback) {
        this.feedback = feedback;
    }

    private void initComponents() {
        this.newPasswdPanel = new EnhancedPanel();
        this.newPasswd1Label = new JLabel();
        this.newPasswd1 = new JPasswordField();
        this.newPasswd2Label = new JLabel();
        this.newPasswd2 = new JPasswordField();
        JLabel prompt = new JLabel();
        this.resourceID = new JTextPane();
        this.authenticationPanel = new AuthenticationPanel();
        this.error = new JLabel();
        this.newPasswdPanel.setLayout(new GridBagLayout());
        this.newPasswdPanel.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                CreateKeyPanel.this.newPasswdPanelAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        this.newPasswd1Label.setDisplayedMnemonic(resources.getString("newPasswd1").charAt(0));
        this.newPasswd1Label.setLabelFor(this.newPasswd1);
        this.newPasswd1Label.setText(resources.getString("newPasswd1"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        this.newPasswdPanel.add((Component)this.newPasswd1Label, gridBagConstraints);
        this.newPasswd1.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.newPasswdPanel.add((Component)this.newPasswd1, gridBagConstraints);
        this.newPasswd2Label.setDisplayedMnemonic(resources.getString("newPasswd2").charAt(0));
        this.newPasswd2Label.setLabelFor(this.newPasswd2);
        this.newPasswd2Label.setText(resources.getString("newPasswd2"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.newPasswdPanel.add((Component)this.newPasswd2Label, gridBagConstraints);
        this.newPasswd2.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.newPasswdPanel.add((Component)this.newPasswd2, gridBagConstraints);
        this.setLayout(new GridBagLayout());
        this.addPanelListener(new PanelListener(){

            public void ancestorWindowShown(PanelEvent evt) {
                CreateKeyPanel.this.formAncestorWindowShown(evt);
            }

            public void ancestorWindowHidden(PanelEvent evt) {
            }
        });
        prompt.setLabelFor(this.resourceID);
        prompt.setText(resources.getString("prompt"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.add((Component)prompt, gridBagConstraints);
        this.resourceID.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
        this.resourceID.setEditable(false);
        this.resourceID.setFont(this.getBoldFont());
        this.resourceID.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.resourceID, gridBagConstraints);
        this.authenticationPanel.setPasswdPanel(this.newPasswdPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.authenticationPanel, gridBagConstraints);
        this.error.setForeground(new Color(255, 0, 0));
        this.error.setText(" ");
        this.error.setName("error");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.error, gridBagConstraints);
    }

    private void formAncestorWindowShown(PanelEvent evt) {
        Feedback feedback = this.getFeedback();
        if (feedback != null) {
            feedback.setPanel(this);
            feedback.run();
        }
    }

    private void newPasswdPanelAncestorWindowShown(PanelEvent evt) {
        final Window window = evt.getAncestorWindow();
        window.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent e) {
                window.removeWindowFocusListener(this);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        if (CreateKeyPanel.this.newPasswd1.requestFocusInWindow()) {
                            CreateKeyPanel.this.newPasswd1.selectAll();
                            CreateKeyPanel.this.newPasswd2.selectAll();
                        }
                    }
                });
            }

            public void windowLostFocus(WindowEvent e) {
            }
        });
    }

    static {
        $assertionsDisabled = !CreateKeyPanel.class.desiredAssertionStatus();
        CLASS_NAME = "de/schlichtherle/key/passwd/swing/CreateKeyPanel".replace('/', '.');
        resources = ResourceBundle.getBundle(CLASS_NAME);
    }
}

