/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.rdb;

import com.hp.hpl.mesa.rdf.jena.common.LiteralImpl;
import com.hp.hpl.mesa.rdf.jena.model.AnonId;
import com.hp.hpl.mesa.rdf.jena.model.Literal;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.rdb.DBConnection;
import com.hp.hpl.mesa.rdf.jena.rdb.DriverGenericGeneric;
import com.hp.hpl.mesa.rdf.jena.rdb.IDBID;
import com.hp.hpl.mesa.rdf.jena.rdb.IRDBDriver;
import com.hp.hpl.mesa.rdf.jena.rdb.ModelRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.RDFRDBException;
import com.hp.hpl.mesa.rdf.jena.rdb.ResourceImplRDB;
import com.hp.hpl.mesa.rdf.jena.rdb.StoreRDB;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestGenericDriver
extends TestCase {
    protected DBConnection m_dbcon;
    protected String m_databaseType;
    protected String m_layout;

    public TestGenericDriver(String string, String string2, String string3) {
        super(string);
        this.m_databaseType = string3;
        this.m_layout = string2;
    }

    public void setUp() throws IOException {
        String string = System.getProperty("jena.rdb.test.dbfull");
        String string2 = System.getProperty("jena.rdb.test.user", "DER");
        String string3 = System.getProperty("jena.rdb.test.password", "key");
        this.m_dbcon = new DBConnection(string, string2, string3);
    }

    public IRDBDriver setupDB() throws RDFRDBException {
        IRDBDriver iRDBDriver = this.m_dbcon.getDriver(this.m_layout, this.m_databaseType);
        if (iRDBDriver.isDBFormatOK()) {
            iRDBDriver.close();
            iRDBDriver.cleanDB();
            iRDBDriver.close();
        }
        iRDBDriver.formatDB();
        return iRDBDriver;
    }

    public void tearDownDB(IRDBDriver iRDBDriver) throws SQLException, RDFRDBException {
        iRDBDriver.close();
        iRDBDriver.cleanDB();
        iRDBDriver.close();
        this.m_dbcon.close();
    }

    public void testDBFormat() throws RDFRDBException, IOException, SQLException {
        IRDBDriver iRDBDriver = this.m_dbcon.getDriver(this.m_layout, this.m_databaseType);
        Connection connection = iRDBDriver.getConnection();
        Assert.assertNotNull((String)"jdbc connection ok", (Object)connection);
        try {
            if (iRDBDriver.isDBFormatOK()) {
                iRDBDriver.cleanDB();
                iRDBDriver.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((String)"DB should be clean", (boolean)false, (boolean)iRDBDriver.isDBFormatOK());
        iRDBDriver.formatDB();
        Assert.assertEquals((String)"DB should be formated", (boolean)true, (boolean)iRDBDriver.isDBFormatOK());
        iRDBDriver.close();
        iRDBDriver.cleanDB();
        Assert.assertEquals((String)"DB should be clean", (boolean)false, (boolean)iRDBDriver.isDBFormatOK());
        iRDBDriver.close();
    }

    public void testSQLCache() throws IOException, SQLException {
    }

    public void testDriver() throws SQLException, RDFException {
        DriverGenericGeneric driverGenericGeneric = (DriverGenericGeneric)this.setupDB();
        this.doTestNamespaceAdd(driverGenericGeneric);
        this.doTestResourceAdd(driverGenericGeneric);
        this.doTestLiteralAdd(driverGenericGeneric);
        this.doTestStatementAdd(driverGenericGeneric);
        if (driverGenericGeneric.supportsMultipleModels()) {
            this.doTestMuliModels(driverGenericGeneric);
        }
        this.tearDownDB(driverGenericGeneric);
    }

    public void doTestNamespaceAdd(DriverGenericGeneric driverGenericGeneric) throws SQLException, RDFException {
        String string = "http://namespace/foo";
        String string2 = "http://namespace/foo2";
        IDBID iDBID = driverGenericGeneric.addNamespace(string);
        IDBID iDBID2 = driverGenericGeneric.getNamespaceID(string);
        Assert.assertEquals((Object)iDBID, (Object)iDBID2);
        IDBID iDBID3 = driverGenericGeneric.addNamespace(string2);
        IDBID iDBID4 = driverGenericGeneric.getNamespaceID(string2);
        Assert.assertEquals((Object)iDBID, (Object)iDBID2);
        Assert.assertTrue((!iDBID3.equals(iDBID) ? (byte)1 : 0) != 0);
        IDBID iDBID5 = driverGenericGeneric.addNamespace(string);
        Assert.assertEquals((Object)iDBID, (Object)iDBID5);
        String string3 = driverGenericGeneric.getNamespace(iDBID5);
        Assert.assertEquals((Object)string, (Object)string3);
    }

    public void doTestResourceAdd(DriverGenericGeneric driverGenericGeneric) throws SQLException, RDFException {
        StoreRDB storeRDB = StoreRDB.createDB(driverGenericGeneric);
        ModelRDB modelRDB = new ModelRDB(storeRDB);
        Resource resource = modelRDB.createResource("http://namespace/foo#res1");
        Resource resource2 = modelRDB.createResource("http://namespace/foo#res2");
        Resource resource3 = modelRDB.createResource("http://namespace/foo2#res3");
        Resource resource4 = modelRDB.createResource("http://namespace/foo#res2");
        IDBID iDBID = driverGenericGeneric.addResource(resource);
        IDBID iDBID2 = driverGenericGeneric.addResource(resource2);
        IDBID iDBID3 = driverGenericGeneric.addResource(resource3);
        IDBID iDBID4 = driverGenericGeneric.addResource(resource4);
        IDBID iDBID5 = driverGenericGeneric.getNamespaceID("http://namespace/foo#");
        Assert.assertEquals((String)"Resource id allocation in clean database", (Object)iDBID2, (Object)((ResourceImplRDB)resource2).getRDBId());
        Assert.assertEquals((String)"Resource id allocation in clean database", (Object)iDBID3, (Object)((ResourceImplRDB)resource3).getRDBId());
        Assert.assertEquals((String)"NS ID alloc in clean db", (Object)iDBID5, (Object)((ResourceImplRDB)resource).getRDBNSId());
        Assert.assertEquals((String)"NS ID realloc in clean db", (Object)iDBID5, (Object)((ResourceImplRDB)resource4).getRDBNSId());
        Assert.assertEquals((String)"Detect prior id allocation", (Object)iDBID2, (Object)((ResourceImplRDB)resource4).getRDBId());
        ResourceImplRDB resourceImplRDB = new ResourceImplRDB(new AnonId("foobar1"), (Model)modelRDB);
        driverGenericGeneric.addResource(resourceImplRDB);
        Assert.assertEquals((String)"anon NS id", (Object)"_", (Object)driverGenericGeneric.getNamespace(driverGenericGeneric.m_anonNSId));
        Assert.assertEquals((String)"anon resource", (Object)driverGenericGeneric.m_anonNSId, (Object)resourceImplRDB.getRDBNSId());
    }

    public void doTestLiteralAdd(DriverGenericGeneric driverGenericGeneric) throws SQLException, RDFException {
        IDBID iDBID;
        IDBID iDBID2 = driverGenericGeneric.addLiteral(new LiteralImpl(1234L));
        IDBID iDBID3 = driverGenericGeneric.addLiteral(new LiteralImpl("Foo bar"));
        IDBID iDBID4 = driverGenericGeneric.addLiteral(new LiteralImpl("<help/>", "English", true));
        IDBID iDBID5 = driverGenericGeneric.addLiteral(new LiteralImpl(1234L));
        Assert.assertEquals((Object)iDBID2, (Object)iDBID5);
        Assert.assertTrue((!iDBID2.equals(iDBID3) ? (byte)1 : 0) != 0);
        Assert.assertTrue((!iDBID2.equals(iDBID4) ? (byte)1 : 0) != 0);
        Assert.assertTrue((!iDBID3.equals(iDBID4) ? (byte)1 : 0) != 0);
        IDBID iDBID6 = driverGenericGeneric.getLiteralID(new LiteralImpl("Foo bar"));
        Assert.assertEquals((Object)iDBID6, (Object)iDBID3);
        StoreRDB storeRDB = new StoreRDB(driverGenericGeneric);
        storeRDB.begin();
        int n = driverGenericGeneric.MAX_LITERAL;
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("abcdefghij".charAt(n2 % 10));
            ++n2;
        }
        String string = stringBuffer.toString() + "a";
        String string2 = stringBuffer.toString() + "b";
        IDBID iDBID7 = driverGenericGeneric.addLiteral(new LiteralImpl(string));
        Assert.assertTrue((!iDBID7.equals(iDBID = driverGenericGeneric.addLiteral(new LiteralImpl(string2))) ? (byte)1 : 0) != 0);
        Literal literal = driverGenericGeneric.getLiteral(iDBID7);
        Literal literal2 = driverGenericGeneric.getLiteral(iDBID);
        Assert.assertEquals((Object)string, (Object)literal.toString());
        Assert.assertEquals((Object)string2, (Object)literal2.toString());
        iDBID7 = driverGenericGeneric.addLiteral(new LiteralImpl(string.substring(1)));
        iDBID = driverGenericGeneric.addLiteral(new LiteralImpl(string2.substring(1)));
        Assert.assertTrue((!iDBID7.equals(iDBID) ? (byte)1 : 0) != 0);
        literal = driverGenericGeneric.getLiteral(iDBID7);
        literal2 = driverGenericGeneric.getLiteral(iDBID);
        Assert.assertEquals((Object)string.substring(1), (Object)literal.toString());
        Assert.assertEquals((Object)string2.substring(1), (Object)literal2.toString());
        iDBID7 = driverGenericGeneric.addLiteral(new LiteralImpl(string.substring(2)));
        iDBID = driverGenericGeneric.addLiteral(new LiteralImpl(string2.substring(2)));
        Assert.assertTrue((!iDBID7.equals(iDBID) ? (byte)1 : 0) != 0);
        literal = driverGenericGeneric.getLiteral(iDBID7);
        literal2 = driverGenericGeneric.getLiteral(iDBID);
        Assert.assertEquals((Object)string.substring(2), (Object)literal.toString());
        Assert.assertEquals((Object)string2.substring(2), (Object)literal2.toString());
        storeRDB.commit();
    }

    public void doTestStatementAdd(DriverGenericGeneric driverGenericGeneric) throws SQLException, RDFException {
        StoreRDB storeRDB = StoreRDB.createDB(driverGenericGeneric);
        ModelRDB modelRDB = new ModelRDB(storeRDB);
        Resource resource = modelRDB.createResource("http://namespace/foo#sub1");
        Property property = modelRDB.createProperty("http://namespace/foo#prop");
        com.hp.hpl.mesa.rdf.jena.model.Statement statement = modelRDB.createStatement(resource, property, 42L);
        modelRDB.add(statement);
        modelRDB.add(modelRDB.createStatement(resource, property, resource));
        Statement statement2 = driverGenericGeneric.getConnection().createStatement();
        ResultSet resultSet = statement2.executeQuery("SELECT SUBJECT, PREDICATE, OBJECT, OBJECT_ISLITERAL FROM RDF_STATEMENTS");
        Assert.assertTrue((boolean)resultSet.next());
        Object object = resultSet.getObject(1);
        Object object2 = resultSet.getObject(2);
        Object object3 = resultSet.getObject(3);
        int n = resultSet.getInt(4);
        Assert.assertTrue((boolean)resultSet.next());
        Object object4 = resultSet.getObject(1);
        Object object5 = resultSet.getObject(2);
        Object object6 = resultSet.getObject(3);
        int n2 = resultSet.getInt(4);
        Assert.assertEquals((Object)object, (Object)object4);
        Assert.assertEquals((Object)object4, (Object)object6);
        Assert.assertEquals((Object)object2, (Object)object5);
        Assert.assertTrue((!object.equals(object2) ? (byte)1 : 0) != 0);
        Assert.assertEquals((int)n, (int)1);
        Assert.assertEquals((int)n2, (int)0);
    }

    public void doTestMuliModels(IRDBDriver iRDBDriver) throws RDFException, SQLException {
        Assert.assertTrue((boolean)iRDBDriver.supportsMultipleModels());
        IDBID iDBID = iRDBDriver.allocateModelID("model1");
        IDBID iDBID2 = iRDBDriver.allocateModelID("model2");
        IDBID iDBID3 = iRDBDriver.allocateModelID("model1");
        Assert.assertEquals((Object)iDBID, (Object)iDBID3);
        Assert.assertTrue((!iDBID.equals(iDBID2) ? (byte)1 : 0) != 0);
        this.assertIteratorValues(iRDBDriver.listModels(), new Object[]{"default", "model1", "model2"});
        ModelRDB modelRDB = ModelRDB.createModel(this.m_dbcon, "model1");
        ModelRDB modelRDB2 = ModelRDB.createModel(this.m_dbcon, "model2");
        Resource resource = modelRDB.createResource("http://namespace/foo#sub1");
        Resource resource2 = modelRDB.createResource("http://namespace/foo2#sub2");
        Property property = modelRDB.createProperty("http://namespace/foo#prop");
        Property property2 = modelRDB.createProperty("http://namespace/foop#props");
        com.hp.hpl.mesa.rdf.jena.model.Statement statement = modelRDB.createStatement(resource, property, 42L);
        modelRDB.add(statement);
        com.hp.hpl.mesa.rdf.jena.model.Statement statement2 = modelRDB.createStatement(resource2, property, 13L);
        modelRDB.add(statement2);
        com.hp.hpl.mesa.rdf.jena.model.Statement statement3 = statement;
        modelRDB2.add(statement3);
        com.hp.hpl.mesa.rdf.jena.model.Statement statement4 = modelRDB2.createStatement(resource, property2, 13L);
        modelRDB2.add(statement4);
        this.assertIteratorValues(iRDBDriver.listSubjects(modelRDB2), new Object[]{resource});
        this.assertIteratorValues(iRDBDriver.listSubjects(modelRDB), new Object[]{resource, resource2});
        this.assertIteratorValues(iRDBDriver.listNamespaces(modelRDB), new Object[]{"http://namespace/foo#"});
        this.assertIteratorValues(iRDBDriver.listNamespaces(modelRDB2), new Object[]{"http://namespace/foo#", "http://namespace/foop#"});
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, null, modelRDB), new Object[]{statement, statement2});
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, null, modelRDB2), new Object[]{statement3, statement4});
        this.assertIteratorValues(iRDBDriver.listStatements(resource, null, null, modelRDB), new Object[]{statement});
        this.assertIteratorValues(iRDBDriver.listStatements(resource, null, null, modelRDB2), new Object[]{statement3, statement4});
        this.assertIteratorValues(iRDBDriver.listStatements(null, property, null, modelRDB), new Object[]{statement, statement2});
        this.assertIteratorValues(iRDBDriver.listStatements(null, property, null, modelRDB2), new Object[]{statement3});
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, new LiteralImpl(13L), modelRDB), new Object[]{statement2});
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, new LiteralImpl(13L), modelRDB2), new Object[]{statement4});
        this.assertIteratorValues(iRDBDriver.listStatements(resource, property, null, modelRDB), new Object[]{statement});
        this.assertIteratorValues(iRDBDriver.listStatements(resource, property, null, modelRDB2), new Object[]{statement3});
        this.assertIteratorValues(iRDBDriver.listStatements(null, property, new LiteralImpl(13L), modelRDB), new Object[]{statement2});
        this.assertIteratorValues(iRDBDriver.listStatements(null, property, new LiteralImpl(13L), modelRDB2), new Object[0]);
        this.assertIteratorValues(iRDBDriver.listStatements(resource, null, new LiteralImpl(13L), modelRDB), new Object[0]);
        this.assertIteratorValues(iRDBDriver.listStatements(resource, null, new LiteralImpl(13L), modelRDB2), new Object[]{statement4});
        this.assertIteratorValues(iRDBDriver.listStatements(resource, property2, new LiteralImpl(13L), modelRDB), new Object[0]);
        this.assertIteratorValues(iRDBDriver.listStatements(resource, property2, new LiteralImpl(13L), modelRDB2), new Object[]{statement4});
        iRDBDriver.deleteStatement(resource, property, new LiteralImpl(42L), modelRDB);
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, null, modelRDB), new Object[]{statement2});
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, null, modelRDB2), new Object[]{statement3, statement4});
        iRDBDriver.deleteStatement(statement2.getSubject(), statement2.getPredicate(), statement2.getObject(), modelRDB);
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, null, modelRDB), new Object[0]);
        this.assertIteratorValues(iRDBDriver.listStatements(null, null, null, modelRDB2), new Object[]{statement3, statement4});
        modelRDB.close();
        modelRDB2.close();
    }

    public void assertIteratorValues(Iterator iterator, Object[] objectArray) {
        boolean[] blArray = new boolean[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            blArray[n] = false;
            ++n;
        }
        while (iterator.hasNext()) {
            Object e = iterator.next();
            boolean bl = false;
            int n2 = 0;
            while (n2 < objectArray.length) {
                if (e.equals(objectArray[n2])) {
                    bl = true;
                    blArray[n2] = true;
                }
                ++n2;
            }
            Assert.assertTrue((boolean)bl);
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            Assert.assertTrue((boolean)blArray[n3]);
            ++n3;
        }
    }

    public void listTable(String string, IRDBDriver iRDBDriver) throws SQLException, RDFRDBException {
        Connection connection = iRDBDriver.getConnection();
        System.out.println("Table - " + string);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT * FROM " + string);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        int n = 1;
        while (n <= resultSetMetaData.getColumnCount()) {
            System.out.print("\t" + resultSetMetaData.getColumnLabel(n));
            ++n;
        }
        System.out.println("");
        while (resultSet.next()) {
            int n2 = 1;
            while (n2 <= resultSetMetaData.getColumnCount()) {
                System.out.print("\t" + resultSet.getObject(n2));
                ++n2;
            }
            System.out.println("");
        }
    }

    public static TestSuite suite(String string, String string2) {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest((Test)new TestGenericDriver("testDBFormat", string, string2));
        testSuite.addTest((Test)new TestGenericDriver("testSQLCache", string, string2));
        testSuite.addTest((Test)new TestGenericDriver("testDriver", string, string2));
        return testSuite;
    }
}

