/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.servletauthorizing;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ProtectedServletRequest;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsValues;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class ServletAuthorizingFilter
extends BasePortalFilter {
    private static Log _log = LogFactoryUtil.getLog(ServletAuthorizingFilter.class);

    protected void processFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        String jRemoteUser;
        HttpSession session = request.getSession();
        PortalInstances.getCompanyId(request);
        long userId = PortalUtil.getUserId((HttpServletRequest)request);
        String remoteUser = request.getRemoteUser();
        if (!PropsValues.PORTAL_JAAS_ENABLE && (jRemoteUser = (String)session.getAttribute("j_remoteuser")) != null) {
            remoteUser = jRemoteUser;
            session.removeAttribute("j_remoteuser");
        }
        if (userId > 0L && remoteUser == null) {
            remoteUser = String.valueOf(userId);
        }
        request = new ProtectedServletRequest(request, remoteUser);
        if (userId > 0L || remoteUser != null) {
            String name = String.valueOf(userId);
            if (remoteUser != null) {
                name = remoteUser;
            }
            PrincipalThreadLocal.setName((String)name);
            userId = GetterUtil.getLong((String)name);
            try {
                User user = UserLocalServiceUtil.getUserById((long)userId);
                PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
                PermissionThreadLocal.setPermissionChecker((PermissionChecker)permissionChecker);
                session.setAttribute("USER_ID", (Object)new Long(userId));
                session.setAttribute("org.apache.struts.action.LOCALE", (Object)user.getLocale());
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
        }
        this.processFilter(ServletAuthorizingFilter.class, request, response, filterChain);
    }
}

