/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gcube.smartgears.context.Property;
import org.gcube.smartgears.utils.Utils;

public class Properties
implements Iterable<Property> {
    private final Map<String, Property> properties = new HashMap<String, Property>();
    private Properties parent;

    public Properties(Properties parent) {
        this.parent = parent;
    }

    public Properties() {
    }

    @Override
    public Iterator<Property> iterator() {
        return this.properties.values().iterator();
    }

    public synchronized void add(Property ... properties) {
        Utils.notNull("properties", properties);
        for (Property property : properties) {
            this.properties.put(property.name(), property);
        }
    }

    public synchronized boolean contains(String name) {
        Utils.notNull("property name", name);
        return this.properties.containsKey(name) || this.parent == null ? false : this.parent.contains(name);
    }

    public void delete(String name) {
        Utils.notNull("property name", name);
        if (this.properties.remove(name) == null) {
            if (this.parent == null) {
                throw new IllegalStateException("unknown property " + name);
            }
            this.parent.delete(name);
        }
    }

    public synchronized Property lookup(String name) {
        Utils.notNull("property name", name);
        Property property = this.properties.get(name);
        if (property == null) {
            if (this.parent == null) {
                throw new IllegalStateException("unknown property " + name);
            }
            property = this.parent.lookup(name);
        }
        return property;
    }

    public synchronized boolean isEmpty() {
        return this.properties.isEmpty() || this.parent == null ? true : this.parent.isEmpty();
    }

    public String toString() {
        int maxLen = 100;
        return "board=" + (this.properties != null ? this.toString(this.properties.entrySet(), 100) : null);
    }

    private String toString(Collection<?> collection, int maxLen) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        Iterator<?> iterator = collection.iterator();
        for (int i = 0; iterator.hasNext() && i < maxLen; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(iterator.next());
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Properties other = (Properties)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        return !(this.properties == null ? other.properties != null : !this.properties.equals(other.properties));
    }
}

