/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.accounting.datamodel.aggregation;

import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Map;
import org.gcube.accounting.datamodel.AggregatedUsageRecord;
import org.gcube.accounting.datamodel.basetypes.AbstractStorageStatusRecord;
import org.gcube.accounting.datamodel.usagerecords.StorageStatusRecord;
import org.gcube.documentstore.exception.InvalidValueException;
import org.gcube.documentstore.exception.NotAggregatableRecordsExceptions;
import org.gcube.documentstore.records.AggregatedRecord;
import org.gcube.documentstore.records.aggregation.AggregationUtility;
import org.gcube.documentstore.records.implementation.AggregatedField;

@JsonTypeName(value="StorageStatusRecord")
public class AggregatedStorageStatusRecord
extends AbstractStorageStatusRecord
implements AggregatedUsageRecord<AggregatedStorageStatusRecord, StorageStatusRecord> {
    private static final long serialVersionUID = 4683337274367137236L;
    @AggregatedField
    public static final String DATA_VOLUME = "dataVolume";
    @AggregatedField
    public static final String DATA_COUNT = "dataCount";

    public AggregatedStorageStatusRecord() {
    }

    public AggregatedStorageStatusRecord(Map<String, ? extends Serializable> properties) throws InvalidValueException {
        super(properties);
    }

    public AggregatedStorageStatusRecord(StorageStatusRecord record) throws InvalidValueException {
        super(record.getResourceProperties());
        this.setOperationCount(1);
        Calendar creationTime = record.getCreationTime();
        this.setCreationTime(Calendar.getInstance());
        this.setStartTime(creationTime);
        this.setEndTime(creationTime);
    }

    public int getOperationCount() {
        return super.getOperationCount();
    }

    public void setOperationCount(int operationCount) throws InvalidValueException {
        super.setOperationCount(operationCount);
    }

    public Calendar getStartTime() {
        return super.getStartTimeAsCalendar();
    }

    public void setStartTime(Calendar startTime) throws InvalidValueException {
        super.setStartTime(startTime);
    }

    public Calendar getEndTime() {
        return super.getEndTimeAsCalendar();
    }

    public void setEndTime(Calendar endTime) throws InvalidValueException {
        super.setEndTime(endTime);
    }

    public void setAggregated(Boolean aggregate) throws InvalidValueException {
        super.setAggregated(aggregate);
    }

    public Boolean isAggregated() {
        return super.isAggregated();
    }

    public AggregatedStorageStatusRecord aggregate(AggregatedStorageStatusRecord record) throws NotAggregatableRecordsExceptions {
        try {
            AggregationUtility aggregationUtility = new AggregationUtility((AggregatedRecord)this);
            aggregationUtility.aggregate((AggregatedRecord)record);
            this.setDataVolume(record.getDataVolume());
            this.setDataCount(record.getDataCount());
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
        return this;
    }

    public AggregatedStorageStatusRecord aggregate(StorageStatusRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.aggregate(new AggregatedStorageStatusRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
    }

    public boolean isAggregable(AggregatedStorageStatusRecord record) throws NotAggregatableRecordsExceptions {
        AggregationUtility aggregationUtility = new AggregationUtility((AggregatedRecord)this);
        return aggregationUtility.isAggregable((AggregatedRecord)record);
    }

    public boolean isAggregable(StorageStatusRecord record) throws NotAggregatableRecordsExceptions {
        try {
            return this.isAggregable(new AggregatedStorageStatusRecord(record));
        }
        catch (NotAggregatableRecordsExceptions e) {
            throw e;
        }
        catch (Exception ex) {
            throw new NotAggregatableRecordsExceptions((Throwable)ex);
        }
    }

    public Class<StorageStatusRecord> getAggregable() {
        return StorageStatusRecord.class;
    }
}

