/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.extensions.resource;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.common.resources.gcore.Resources;
import org.gcube.smartgears.context.application.ApplicationContext;
import org.gcube.smartgears.extensions.ApiResource;
import org.gcube.smartgears.extensions.ApiSignature;
import org.gcube.smartgears.extensions.HttpExtension;
import org.gcube.smartgears.handlers.application.lifecycle.ProfilePublisher;
import org.gcube.smartgears.handlers.application.request.RequestError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopesResource
extends ApiResource {
    private static final long serialVersionUID = 1L;
    private static Logger log = LoggerFactory.getLogger(ScopesResource.class);
    public static final String mapping = "/scopes";
    private static final ApiSignature signature = ScopesResource.handles("/scopes").with(ScopesResource.method(HttpExtension.Method.GET).produces("application/xml")).with(ScopesResource.method(HttpExtension.Method.POST).accepts("application/xml"));
    private ProfilePublisher publisher;

    ScopesResource() {
        super(signature);
    }

    @Override
    public boolean supports(HttpExtension.Method method) {
        return method == HttpExtension.Method.GET || method == HttpExtension.Method.POST;
    }

    @Override
    public void init(ApplicationContext context) throws Exception {
        super.init(context);
        this.publisher = new ProfilePublisher(context);
    }

    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            Resources.marshal((Object)new Scopes(this.context().profile(GCoreEndpoint.class).scopes().asCollection()), (Writer)resp.getWriter());
        }
        catch (Exception e) {
            RequestError.invalid_request_error.fire("cannot parse request body", e);
        }
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Scope wrapper = (Scope)Resources.unmarshal(Scope.class, (Reader)req.getReader());
        String scope = wrapper.value;
        if (scope == null || scope.isEmpty()) {
            RequestError.invalid_request_error.fire("missing scope in request body");
        }
        GCoreEndpoint profile = this.context().profile(GCoreEndpoint.class);
        if (wrapper.delete) {
            this.delete(profile, scope);
        } else {
            this.add(profile, scope);
        }
    }

    private void add(GCoreEndpoint profile, String scope) {
        log.info("adding {} to {}", (Object)scope, (Object)this.context().name());
        this.publisher.addTo(Collections.singletonList(scope));
    }

    private void delete(GCoreEndpoint profile, String scope) {
        if (profile.scopes().size() == 1) {
            RequestError.illegal_state_error.fire("cannot remove this resource from " + scope + ", as it is its only scope.");
        }
        log.info("removing {} from {}", (Object)scope, (Object)this.context().name());
        this.publisher.removeFrom(Collections.singletonList(scope));
    }

    @XmlRootElement(name="scope")
    public static class Scope {
        @XmlAttribute
        public boolean delete;
        @XmlValue
        public String value;

        Scope() {
        }

        public Scope(String scope) {
            this.value = scope;
        }
    }

    @XmlRootElement(name="scopes")
    public static class Scopes {
        @XmlElement(name="scope")
        public Collection<String> values;

        Scopes() {
        }

        public Scopes(Collection<String> scopes) {
            this.values = scopes;
        }
    }
}

