/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.bucket;

import com.couchbase.client.core.ClusterFacade;
import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.annotations.InterfaceAudience;
import com.couchbase.client.core.annotations.InterfaceStability;
import com.couchbase.client.core.message.CouchbaseRequest;
import com.couchbase.client.core.message.ResponseStatus;
import com.couchbase.client.core.message.config.FlushRequest;
import com.couchbase.client.core.message.config.FlushResponse;
import com.couchbase.client.core.message.kv.GetRequest;
import com.couchbase.client.core.message.kv.GetResponse;
import com.couchbase.client.core.message.kv.UpsertRequest;
import com.couchbase.client.core.message.kv.UpsertResponse;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import com.couchbase.client.java.error.FlushDisabledException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import rx.Observable;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.functions.Func2;

@InterfaceStability.Uncommitted
@InterfaceAudience.Private
public class BucketFlusher {
    static final int FLUSH_MARKER_SIZE = 1024;
    private static final List<String> FLUSH_MARKERS = new ArrayList<String>();

    private BucketFlusher() {
    }

    public static Observable<Boolean> flush(final ClusterFacade core, final String bucket, final String password) {
        return BucketFlusher.createMarkerDocuments(core, bucket).flatMap((Func1)new Func1<List<String>, Observable<Boolean>>(){

            public Observable<Boolean> call(List<String> strings) {
                return BucketFlusher.initiateFlush(core, bucket, password);
            }
        }).flatMap((Func1)new Func1<Boolean, Observable<Boolean>>(){

            public Observable<Boolean> call(Boolean isDone) {
                return isDone != false ? Observable.just((Object)true) : BucketFlusher.pollMarkerDocuments(core, bucket);
            }
        });
    }

    private static Observable<List<String>> createMarkerDocuments(final ClusterFacade core, final String bucket) {
        return Observable.from(FLUSH_MARKERS).flatMap((Func1)new Func1<String, Observable<UpsertResponse>>(){

            public Observable<UpsertResponse> call(String id) {
                return core.send((CouchbaseRequest)new UpsertRequest(id, Unpooled.copiedBuffer((CharSequence)id, (Charset)CharsetUtil.UTF_8), bucket));
            }
        }).doOnNext((Action1)new Action1<UpsertResponse>(){

            public void call(UpsertResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
            }
        }).last().map((Func1)new Func1<UpsertResponse, List<String>>(){

            public List<String> call(UpsertResponse response) {
                return FLUSH_MARKERS;
            }
        });
    }

    private static Observable<Boolean> initiateFlush(ClusterFacade core, String bucket, String password) {
        return core.send((CouchbaseRequest)new FlushRequest(bucket, password)).map((Func1)new Func1<FlushResponse, Boolean>(){

            public Boolean call(FlushResponse flushResponse) {
                if (flushResponse.status() == ResponseStatus.FAILURE) {
                    if (flushResponse.content().contains("disabled")) {
                        throw new FlushDisabledException("Flush is disabled for this bucket.");
                    }
                    throw new CouchbaseException("Flush failed because of: " + flushResponse.content());
                }
                return flushResponse.isDone();
            }
        });
    }

    private static Observable<Boolean> pollMarkerDocuments(final ClusterFacade core, final String bucket) {
        return Observable.from(FLUSH_MARKERS).flatMap((Func1)new Func1<String, Observable<GetResponse>>(){

            public Observable<GetResponse> call(String id) {
                return core.send((CouchbaseRequest)new GetRequest(id, bucket));
            }
        }).reduce((Object)0, (Func2)new Func2<Integer, GetResponse, Integer>(){

            public Integer call(Integer foundDocs, GetResponse response) {
                if (response.content() != null && response.content().refCnt() > 0) {
                    response.content().release();
                }
                if (response.status() == ResponseStatus.SUCCESS) {
                    Integer n = foundDocs;
                    Integer n2 = foundDocs = Integer.valueOf(foundDocs + 1);
                }
                return foundDocs;
            }
        }).filter((Func1)new Func1<Integer, Boolean>(){

            public Boolean call(Integer foundDocs) {
                return foundDocs == 0;
            }
        }).repeatWhen(new Func1<Observable<? extends Void>, Observable<?>>(){

            public Observable<?> call(Observable<? extends Void> observable) {
                return observable.flatMap(new Func1<Void, Observable<?>>(){

                    public Observable<?> call(Void aVoid) {
                        return Observable.timer((long)500L, (TimeUnit)TimeUnit.MILLISECONDS);
                    }
                });
            }
        }).take(1).map((Func1)new Func1<Integer, Boolean>(){

            public Boolean call(Integer integer) {
                return true;
            }
        });
    }

    static {
        for (int i = 0; i < 1024; ++i) {
            FLUSH_MARKERS.add("__flush_marker_" + i);
        }
    }
}

