/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.io.File;
import java.util.Set;
import org.gcube.smartgears.configuration.Mode;
import org.gcube.smartgears.configuration.application.ApplicationConfiguration;
import org.gcube.smartgears.configuration.application.Exclude;
import org.gcube.smartgears.configuration.application.Include;
import org.gcube.smartgears.configuration.application.ProxyAddress;
import org.gcube.smartgears.configuration.container.ContainerConfiguration;
import org.gcube.smartgears.persistence.DefaultPersistence;
import org.gcube.smartgears.persistence.Persistence;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BridgedApplicationConfiguration
implements ApplicationConfiguration {
    private static Logger log = LoggerFactory.getLogger(ApplicationConfiguration.class);
    private final ContainerConfiguration container;
    private final ApplicationConfiguration application;

    public BridgedApplicationConfiguration(ContainerConfiguration container, ApplicationConfiguration config) {
        this.container = container;
        this.application = config;
        if (this.application.persistence() == null) {
            String location = container.persistence().location() + "/" + this.application.name();
            File dir = new File(location);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            this.application.persistence(new DefaultPersistence(location));
            log.trace("setting persistence location for {} @ {}", (Object)this.application.name(), (Object)dir.getAbsolutePath());
        }
    }

    public ApplicationConfiguration inner() {
        return this.application;
    }

    @Override
    public Mode mode() {
        return this.container.mode() == Mode.offline ? Mode.offline : this.application.mode();
    }

    @Override
    public String context() {
        return this.application.context();
    }

    @Override
    public ApplicationConfiguration context(String context) {
        return this.application.context(context);
    }

    @Override
    public String name() {
        return this.application.name();
    }

    @Override
    public ApplicationConfiguration name(String name) {
        return this.application.name(name);
    }

    @Override
    public String serviceClass() {
        return this.application.serviceClass();
    }

    @Override
    public ApplicationConfiguration serviceClass(String group) {
        return this.application.serviceClass(group);
    }

    @Override
    public String version() {
        return this.application.version();
    }

    @Override
    public ApplicationConfiguration version(String version) {
        return this.application.version(version);
    }

    @Override
    public String description() {
        return this.application.description();
    }

    @Override
    public ProxyAddress proxyAddress() {
        return this.application.proxyAddress();
    }

    @Override
    public ApplicationConfiguration description(String description) {
        return this.application.description(description);
    }

    @Override
    public Persistence persistence() {
        return this.application.persistence();
    }

    @Override
    public ApplicationConfiguration persistence(Persistence manager) {
        return this.application.persistence(manager);
    }

    @Override
    public ApplicationConfiguration mode(Mode mode) {
        return this.application.mode(mode);
    }

    @Override
    public void validate() {
        this.application.validate();
    }

    @Override
    public Set<Exclude> excludes() {
        return this.application.excludes();
    }

    @Override
    public Set<Include> includes() {
        return this.application.includes();
    }

    @Override
    public void merge(ApplicationConfiguration config) {
        this.application.merge(config);
    }

    @Override
    public Set<String> startTokens() {
        return this.application.startTokens();
    }

    @Override
    public ApplicationConfiguration startTokens(Set<String> tokens) {
        return this.application.startTokens(tokens);
    }

    @Override
    public boolean proxied() {
        return this.application.proxied();
    }

    @Override
    public ApplicationConfiguration excludes(Exclude ... excludes) {
        return this.application.excludes(excludes);
    }

    @Override
    public ApplicationConfiguration includes(Include ... includes) {
        return this.application.includes(includes);
    }

    @Override
    public ApplicationConfiguration proxyAddress(ProxyAddress proxyaddress) {
        return this.application.proxyAddress(proxyaddress);
    }
}

