/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resources.discovery.client.impl;

import java.util.ArrayList;
import java.util.List;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.api.DiscoveryException;
import org.gcube.resources.discovery.client.api.InvalidResultException;
import org.gcube.resources.discovery.client.api.ResultParser;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelegateClient<R>
implements DiscoveryClient<R> {
    private static Logger log = LoggerFactory.getLogger(DelegateClient.class);
    private final ResultParser<R> parser;
    private final DiscoveryClient<String> inner;

    public DelegateClient(ResultParser<R> parser, DiscoveryClient<String> inner) {
        this.parser = parser;
        this.inner = inner;
    }

    @Override
    public List<R> submit(Query query) throws DiscoveryException, InvalidResultException {
        ArrayList<R> parsed = new ArrayList<R>();
        List<String> unparsed = this.inner.submit(query);
        int errors = 0;
        for (String result : unparsed) {
            try {
                parsed.add(this.parser.parse(result));
            }
            catch (Exception e) {
                log.warn("discarded invalid result " + result, (Throwable)e);
                ++errors;
            }
        }
        if (errors > 0 && parsed.size() == 0) {
            throw new InvalidResultException("no success but " + errors + " errors parsing results");
        }
        return parsed;
    }
}

