/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.keycloak;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.gcube.common.gxrest.request.GXHTTPStringRequest;
import org.gcube.common.gxrest.response.inbound.GXInboundResponse;
import org.gcube.common.keycloak.KeycloakClient;
import org.gcube.common.keycloak.KeycloakClientException;
import org.gcube.common.keycloak.model.ModelUtils;
import org.gcube.common.keycloak.model.TokenResponse;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;

public class DefaultKeycloakClient
implements KeycloakClient {
    @Override
    public URL findTokenEndpointURL() throws KeycloakClientException {
        logger.debug("Checking ScopeProvider's scope presence and format");
        String originalScope = ScopeProvider.instance.get();
        if (originalScope == null || !originalScope.startsWith("/") || originalScope.length() < 2) {
            throw new KeycloakClientException(originalScope == null ? "Scope not found in ScopeProvider" : "Bad scope name found: " + originalScope);
        }
        logger.debug("Assuring use the rootVO to query the endpoint simple query. Actual scope is: {}", (Object)originalScope);
        String rootVOScope = "/" + originalScope.split("/")[1];
        logger.debug("Setting rootVO scope into provider as: {}", (Object)rootVOScope);
        ScopeProvider.instance.set(rootVOScope);
        logger.debug("Creating simple query");
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition(String.format("$resource/Profile/Category/text() eq '%s'", "Auth")).addCondition(String.format("$resource/Profile/Name/text() eq '%s'", "IAM")).setResult(String.format("$resource/Profile/AccessPoint[Description/text() eq '%s']", "oidc-token endpoint"));
        logger.debug("Creating client for AccessPoint");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.AccessPoint.class);
        logger.trace("Submitting query: {}", (Object)query);
        List accessPoints = client.submit((Query)query);
        logger.debug("Restting scope into provider to the original value: {}", (Object)originalScope);
        ScopeProvider.instance.set(originalScope);
        if (accessPoints.size() == 0) {
            throw new KeycloakClientException("Service endpoint not found");
        }
        if (accessPoints.size() > 1) {
            throw new KeycloakClientException("Found more than one endpoint with query");
        }
        String address = ((ServiceEndpoint.AccessPoint)accessPoints.iterator().next()).address();
        logger.debug("Found address: {}", (Object)address);
        try {
            return new URL(address);
        }
        catch (MalformedURLException e) {
            throw new KeycloakClientException("Cannot create URL from address: " + address, e);
        }
    }

    @Override
    public TokenResponse queryUMAToken(String clientId, String clientSecret, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(clientId, clientSecret, ScopeProvider.instance.get(), permissions);
    }

    @Override
    public TokenResponse queryUMAToken(String clientId, String clientSecret, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(this.findTokenEndpointURL(), clientId, clientSecret, audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, String clientId, String clientSecret, String audience, List<String> permissions) throws KeycloakClientException {
        return this.queryUMAToken(tokenURL, "Basic " + Base64.getEncoder().encodeToString((clientId + ":" + clientSecret).getBytes()), audience, permissions);
    }

    @Override
    public TokenResponse queryUMAToken(URL tokenURL, String authorization, String audience, List<String> permissions) throws KeycloakClientException {
        GXInboundResponse response;
        GXHTTPStringRequest request;
        if (tokenURL == null) {
            throw new KeycloakClientException("Token URL must be not null");
        }
        if (authorization == null || "".equals(authorization)) {
            throw new KeycloakClientException("Authorization must be not null nor empty");
        }
        if (audience == null || "".equals(audience)) {
            throw new KeycloakClientException("Audience must be not null nor empty");
        }
        logger.debug("Querying token from Keycloak server with URL: {}", (Object)tokenURL);
        try {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            params.put("grant_type", Arrays.asList("urn:ietf:params:oauth:grant-type:uma-ticket"));
            params.put("audience", Arrays.asList(URLEncoder.encode(DefaultKeycloakClient.checkAudience(audience), "UTF-8")));
            if (permissions != null && !permissions.isEmpty()) {
                params.put("permission", permissions.stream().map(s -> {
                    try {
                        return URLEncoder.encode(s, "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return "";
                    }
                }).collect(Collectors.toList()));
            }
            String queryString = params.entrySet().stream().flatMap(p -> ((List)p.getValue()).stream().map(v -> (String)p.getKey() + "=" + v)).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            request = GXHTTPStringRequest.newRequest((String)tokenURL.toString()).header("Content-Type", "application/x-www-form-urlencoded").withBody(queryString);
            request.isExternalCall(true);
            if (authorization != null) {
                logger.debug("Adding authorization header as: {}", (Object)authorization);
                request = request.header("Authorization", authorization);
            }
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct the request object correctly", e);
        }
        try {
            response = request.post();
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot send request correctly", e);
        }
        if (response.isSuccessResponse()) {
            try {
                return (TokenResponse)response.tryConvertStreamedContentFromJson(TokenResponse.class);
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct token response object correctly", e);
            }
        }
        throw KeycloakClientException.create("Unable to get token", response.getHTTPCode(), response.getHeaderFields().getOrDefault("content-type", Collections.singletonList("unknown/unknown")).get(0), response.getMessage());
    }

    private static String checkAudience(String audience) {
        if (audience.startsWith("/")) {
            try {
                logger.trace("Audience was provided in non URL encoded form, encoding it");
                return URLEncoder.encode(audience, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("Cannot URL encode 'audience'", (Throwable)e);
            }
        }
        return audience;
    }

    @Override
    public TokenResponse refreshToken(TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken((String)null, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(tokenURL, null, null, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(String clientId, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(clientId, null, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(String clientId, String clientSecret, TokenResponse tokenResponse) throws KeycloakClientException {
        return this.refreshToken(this.findTokenEndpointURL(), clientId, clientSecret, tokenResponse);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, String clientId, String clientSecret, TokenResponse tokenResponse) throws KeycloakClientException {
        if (clientId == null) {
            logger.debug("Client id not set, trying to get it from access token info");
            try {
                clientId = ModelUtils.getClientIdFromToken(ModelUtils.getAccessTokenFrom(tokenResponse));
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct access token object from token response", e);
            }
        }
        return this.refreshToken(tokenURL, clientId, clientSecret, tokenResponse.getRefreshToken());
    }

    @Override
    public TokenResponse refreshToken(String refreshTokenJWTString) throws KeycloakClientException {
        try {
            String clientId = ModelUtils.getClientIdFromToken(ModelUtils.getRefreshTokenFrom(refreshTokenJWTString));
            return this.refreshToken(clientId, refreshTokenJWTString);
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct access token object from token response", e);
        }
    }

    @Override
    public TokenResponse refreshToken(String clientId, String refreshTokenJWTString) throws KeycloakClientException {
        return this.refreshToken(clientId, null, refreshTokenJWTString);
    }

    @Override
    public TokenResponse refreshToken(String clientId, String clientSecret, String refreshTokenJWTString) throws KeycloakClientException {
        return this.refreshToken(this.findTokenEndpointURL(), clientId, clientSecret, refreshTokenJWTString);
    }

    @Override
    public TokenResponse refreshToken(URL tokenURL, String clientId, String clientSecret, String refreshTokenJWTString) throws KeycloakClientException {
        GXInboundResponse response;
        GXHTTPStringRequest request;
        if (tokenURL == null) {
            throw new KeycloakClientException("Token URL must be not null");
        }
        if (clientId == null || "".equals(clientId)) {
            throw new KeycloakClientException("Client id must be not null nor empty");
        }
        if (refreshTokenJWTString == null || "".equals(clientId)) {
            throw new KeycloakClientException("Refresh token JWT encoded string must be not null nor empty");
        }
        logger.debug("Refreshing token from Keycloak server with URL: {}", (Object)tokenURL);
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("grant_type", "refresh_token");
            params.put("refresh_token", refreshTokenJWTString);
            params.put("client_id", URLEncoder.encode(clientId, "UTF-8"));
            if (clientSecret != null && !"".equals(clientSecret)) {
                params.put("client_secret", URLEncoder.encode(clientSecret, "UTF-8"));
            }
            String queryString = params.entrySet().stream().map(p -> (String)p.getKey() + "=" + (String)p.getValue()).reduce((p1, p2) -> p1 + "&" + p2).orElse("");
            request = GXHTTPStringRequest.newRequest((String)tokenURL.toString()).header("Content-Type", "application/x-www-form-urlencoded").withBody(queryString);
            request.isExternalCall(true);
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot construct the request object correctly", e);
        }
        try {
            response = request.post();
        }
        catch (Exception e) {
            throw new KeycloakClientException("Cannot send request correctly", e);
        }
        if (response.isSuccessResponse()) {
            try {
                return (TokenResponse)response.tryConvertStreamedContentFromJson(TokenResponse.class);
            }
            catch (Exception e) {
                throw new KeycloakClientException("Cannot construct token response object correctly", e);
            }
        }
        throw KeycloakClientException.create("Unable to get token", response.getHTTPCode(), response.getHeaderFields().getOrDefault("content-type", Collections.singletonList("unknown/unknown")).get(0), response.getMessage());
    }
}

