/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.tree;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gcube.informationsystem.tree.Node;
import org.gcube.informationsystem.tree.NodeElaborator;
import org.gcube.informationsystem.tree.NodeInformation;

public class Tree<T> {
    private boolean allowMultipleInheritance = true;
    private Node<T> root;
    private NodeInformation<T> ni;
    private Map<String, Node<T>> locate;

    public Tree(T t, NodeInformation<T> ni) throws Exception {
        this.ni = ni;
        this.locate = new HashMap<String, Node<T>>();
        this.root = new Node<T>(t);
        this.root.setTree(this);
        String identifier = ni.getIdentifier(t);
        this.locate.put(identifier, this.root);
    }

    public void setAllowMultipleInheritance(boolean allowMultipleInheritance) {
        this.allowMultipleInheritance = allowMultipleInheritance;
    }

    public NodeInformation<T> getNodeInformation() {
        return this.ni;
    }

    public Node<T> addNode(T t) {
        String identifier = this.ni.getIdentifier(t);
        if (this.locate.containsKey(identifier)) {
            return this.locate.get(identifier);
        }
        Node<T> node = new Node<T>(t);
        node.setTree(this);
        Set<String> parentIdentifiers = this.ni.getParentIdentifiers(this.root.getNodeElement(), t);
        for (String parentIdentifier : parentIdentifiers) {
            Node<T> parentNode = this.locate.get(parentIdentifier);
            if (parentNode == null) {
                throw new RuntimeException("I can find parent for " + identifier + ". Missing parent is " + parentIdentifier);
            }
            parentNode.addChild(node);
            if (this.allowMultipleInheritance) continue;
            break;
        }
        this.locate.put(identifier, node);
        return node;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public String toString() {
        return this.root.toString();
    }

    public void elaborate(NodeElaborator<T> nodeElaborator) throws Exception {
        this.root.elaborate(nodeElaborator);
    }
}

