/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.events.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.gcube.common.events.Hub;
import org.gcube.common.events.Observes;
import org.gcube.common.events.impl.Key;
import org.gcube.common.events.impl.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Observer {
    private static final Logger log = LoggerFactory.getLogger(Hub.class);
    final Object object;
    final Method method;
    final Observes.Kind kind;
    final Key key;
    private ExecutorService service;
    private Future<?> future;
    private long delay;
    private List<Object> accumulated = new ArrayList<Object>();

    public static List<Observer> observersFor(Object object, ExecutorService service) {
        ArrayList<Observer> observers = new ArrayList<Observer>();
        List<Method> methods = Observer.observerMethodsOf(object);
        if (methods.isEmpty()) {
            throw new IllegalArgumentException(String.valueOf(object) + " is not an observer, none of its methods is annotated with @Observes");
        }
        for (Method method : methods) {
            observers.add(new Observer(object, method, service));
        }
        return observers;
    }

    Observer(Object object, Method method, ExecutorService service) {
        Observes.Kind kind;
        method.setAccessible(true);
        this.object = object;
        this.method = method;
        this.service = service;
        this.kind = kind = method.getAnnotation(Observes.class).kind();
        HashSet<String> qualifiers = new HashSet<String>(Arrays.asList(method.getAnnotation(Observes.class).value()));
        this.delay = method.getAnnotation(Observes.class).every();
        Type paramType = method.getGenericParameterTypes()[0];
        if (this.delay > 0L) {
            paramType = ReflectionUtils.elementTypeOf(paramType);
        }
        this.key = new Key(paramType, qualifiers);
    }

    public Observes.Kind kind() {
        return this.kind;
    }

    public void onEvent(Object event) {
        if (this.delay > 0L) {
            this.onEventDelayed(event);
        } else {
            this.onEventImmediate(event);
        }
    }

    public void onEventImmediate(Object event) {
        try {
            this.method.invoke(this.object, event);
        }
        catch (InvocationTargetException e) {
            this.rethrow(event, e.getCause());
        }
        catch (Exception e) {
            this.rethrow(event, e);
        }
    }

    public synchronized void onEventDelayed(Object event) {
        this.accumulated.add(event);
        if (this.future == null || this.future.isDone()) {
            this.future = this.service.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(Observer.this.delay);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    ArrayList<Object> listEvent = new ArrayList<Object>(Observer.this.accumulated);
                    Observer.this.accumulated.clear();
                    Observer.this.onEventImmediate(listEvent);
                }
            });
        }
    }

    private void rethrow(Object event, Throwable t) {
        String msg = "observer " + String.valueOf(this.object) + " failed to process event " + String.valueOf(event) + " with qualifiers " + String.valueOf(this.key.qualifiers());
        switch (this.kind) {
            case critical: {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)RuntimeException.class.cast(t);
                }
                throw new RuntimeException(msg, t);
            }
        }
        log.error(msg, t);
    }

    public Key key() {
        return this.key;
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public boolean equals(Object obj) {
        return this.object.equals(obj);
    }

    public static List<Method> observerMethodsOf(Object o) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : o.getClass().getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Observes.class)) continue;
            Type[] params = method.getGenericParameterTypes();
            if (params.length != 1) {
                throw new IllegalArgumentException("observer method " + String.valueOf(method) + " does not take a single parameter");
            }
            if (ReflectionUtils.containsVariable(params[0])) {
                throw new IllegalArgumentException("observer method " + String.valueOf(method) + " uses type variables, which inhibit event delivery");
            }
            long delay = method.getAnnotation(Observes.class).every();
            if (delay > 0L && !ReflectionUtils.isCollectionType(params[0])) {
                throw new IllegalArgumentException("observer method " + String.valueOf(method) + " expects multiple events at once but its parameter cannot be assigned to java.util.Collection parameter");
            }
            methods.add(method);
        }
        return methods;
    }
}

