/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.contexts.reference;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum ContextState {
    CREATED("created"),
    ACTIVE("active"),
    SUSPENDED("suspended"),
    DELETED("deleted");

    private static final Map<String, ContextState> ENUM_MAP;
    protected String state;

    private ContextState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public static ContextState fromString(String state) {
        return ENUM_MAP.get(state.toLowerCase());
    }

    static {
        ContextState[] array = ContextState.values();
        ConcurrentHashMap<String, ContextState> map = new ConcurrentHashMap<String, ContextState>(array.length);
        for (ContextState cs : array) {
            map.put(cs.getState().toLowerCase(), cs);
        }
        ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

