/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.types.impl.validator;

import java.util.List;
import org.gcube.com.fasterxml.jackson.databind.node.ObjectNode;
import org.gcube.informationsystem.base.reference.AttributeDefinition;
import org.gcube.informationsystem.types.impl.validator.AttributeValidator;
import org.gcube.informationsystem.types.impl.validator.ValidatorReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectNodeValidator {
    protected static Logger logger = LoggerFactory.getLogger(ObjectNodeValidator.class);
    protected final ObjectNode nodeToValidate;
    protected final List<? extends AttributeDefinition> attributeDefinitions;
    protected final boolean stopOnError;
    protected ValidatorReport validatorReport;

    public ObjectNodeValidator(ObjectNode nodeToValidate, List<? extends AttributeDefinition> attributeDefinitions) {
        this(nodeToValidate, attributeDefinitions, false);
    }

    public ObjectNodeValidator(ObjectNode nodeToValidate, List<? extends AttributeDefinition> attributeDefinitions, Boolean stopOnError) {
        this.nodeToValidate = nodeToValidate;
        this.attributeDefinitions = attributeDefinitions;
        this.stopOnError = stopOnError;
    }

    public ValidatorReport getValidatorReport() {
        return this.validatorReport;
    }

    public boolean isValid() {
        return this.validatorReport.isValid();
    }

    public boolean validate() {
        this.validatorReport = new ValidatorReport();
        boolean valid = true;
        for (AttributeDefinition attributeDefinition : this.attributeDefinitions) {
            String key;
            AttributeValidator attributeValidator = new AttributeValidator(attributeDefinition, this.nodeToValidate.get(key = attributeDefinition.getName()), this.stopOnError);
            valid = attributeValidator.validate() && valid;
            this.validatorReport.addAttributeValidatorReport(attributeValidator.getAttributeValidatorReport());
            if (valid || !this.stopOnError) continue;
            return false;
        }
        return this.validatorReport.isValid();
    }
}

