/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public final class UUIDManager {
    private static final Set<String> RESERVED_UUID_STRING;
    private static final Set<UUID> RESERVED_UUID;
    private static UUIDManager uuidManager;

    public static UUIDManager getInstance() {
        if (uuidManager == null) {
            uuidManager = new UUIDManager();
        }
        return uuidManager;
    }

    private UUIDManager() {
    }

    public boolean isReservedUUID(UUID uuid) {
        return RESERVED_UUID.contains(uuid);
    }

    public boolean isReservedUUID(String uuid) {
        return RESERVED_UUID_STRING.contains(uuid);
    }

    public Set<String> getAllReservedUUIDAsStrings() {
        return new TreeSet<String>(RESERVED_UUID_STRING);
    }

    public Set<UUID> getAllReservedUUID() {
        return new TreeSet<UUID>(RESERVED_UUID);
    }

    public UUID generateValidUUID() {
        return this.generateValidUUID(null);
    }

    public UUID generateValidUUID(UUID uuid) {
        UUID uUID = uuid = uuid == null ? UUID.randomUUID() : uuid;
        while (RESERVED_UUID.contains(uuid)) {
            uuid = UUID.randomUUID();
        }
        return uuid;
    }

    public UUID validateUUID(UUID uuid) throws Exception {
        if (RESERVED_UUID.contains(uuid)) {
            throw new Exception(uuid.toString() + " UUID is reserved. All the following UUID are reserved " + this.getAllReservedUUIDAsStrings().toString());
        }
        return uuid;
    }

    static {
        String[] uuidValidCharacters;
        RESERVED_UUID_STRING = new HashSet<String>();
        RESERVED_UUID = new HashSet<UUID>();
        for (String string : uuidValidCharacters = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"}) {
            String uuidString = "XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX";
            uuidString = uuidString.replaceAll("X", string);
            RESERVED_UUID_STRING.add(uuidString);
            RESERVED_UUID.add(UUID.fromString(uuidString));
        }
    }
}

