/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.resourcemanagement.model.reference.properties;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.gcube.informationsystem.types.annotations.ISProperty;
import org.gcube.informationsystem.types.reference.Change;
import org.gcube.informationsystem.types.reference.TypeMetadata;
import org.gcube.resourcemanagement.model.impl.properties.RegexPropertyImpl;
import org.gcube.resourcemanagement.model.reference.properties.GCubeProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.PropertyValidator;
import org.gcube.resourcemanagement.model.reference.properties.utilities.ValidatedTypedProperty;
import org.gcube.resourcemanagement.model.reference.properties.utilities.Validation;

@JsonDeserialize(as=RegexPropertyImpl.class)
@TypeMetadata(name="RegexProperty", description="A property validated with a regular expression.", version="1.0.0")
@Change(version="1.0.0", description="First Version")
public interface RegexProperty
extends GCubeProperty,
ValidatedTypedProperty<String, String> {
    public static final String NAME = "RegexProperty";

    public static RegexProperty getDefaultInstance() {
        return new RegexPropertyImpl();
    }

    @Override
    default public Validation validate() {
        return new RegexValidator().validate(this);
    }

    @Override
    @ISProperty
    public String getValue();

    @Override
    public void setValue(String var1);

    @Override
    @ISProperty
    public String getSchema();

    @Override
    public void setSchema(String var1);

    public static class RegexValidator
    implements PropertyValidator<RegexProperty> {
        @Override
        public Validation validate(RegexProperty property) {
            if (Objects.isNull(property.getValue())) {
                return Validation.fail("The value of the regex property is not set.");
            }
            if (Objects.isNull(property.getSchema())) {
                return Validation.fail("The type of the regex property is not set.");
            }
            Pattern pattern = Pattern.compile(property.getSchema());
            Matcher matcher = pattern.matcher(property.getValue());
            return matcher.find() ? Validation.success("Accepted!") : Validation.fail(property.getValue() + " was not a valid match!");
        }
    }
}

