/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl;

import java.util.Map;
import org.gcube.io.jsonwebtoken.Header;
import org.gcube.io.jsonwebtoken.impl.DefaultHeader;
import org.gcube.io.jsonwebtoken.impl.DefaultJwsHeader;
import org.gcube.io.jsonwebtoken.impl.TokenizedJwt;
import org.gcube.io.jsonwebtoken.lang.Strings;

class DefaultTokenizedJwt
implements TokenizedJwt {
    private final CharSequence protectedHeader;
    private final CharSequence payload;
    private final CharSequence digest;

    DefaultTokenizedJwt(CharSequence protectedHeader, CharSequence payload, CharSequence digest) {
        this.protectedHeader = protectedHeader;
        this.payload = payload;
        this.digest = digest;
    }

    @Override
    public CharSequence getProtected() {
        return this.protectedHeader;
    }

    @Override
    public CharSequence getPayload() {
        return this.payload;
    }

    @Override
    public CharSequence getDigest() {
        return this.digest;
    }

    @Override
    public Header createHeader(Map<String, ?> m) {
        if (Strings.hasText((CharSequence)this.getDigest())) {
            return new DefaultJwsHeader(m);
        }
        return new DefaultHeader(m);
    }
}

