/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.clients.stubs.jaxws.proxies;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodRetriever<T>
implements InvocationHandler {
    public static Logger log = LoggerFactory.getLogger(MethodRetriever.class);
    private T service;

    public MethodRetriever(T service) {
        this.service = service;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this.service, args);
        }
        catch (IllegalAccessException | IllegalArgumentException proxyEx) {
            log.error("error invoking method " + method.getName() + " in service " + this.service.getClass().getCanonicalName() + " using proxy ", (Throwable)proxyEx);
            throw new RuntimeException(proxyEx);
        }
        catch (InvocationTargetException ite) {
            log.error("exception invoking method " + method.getName() + " in service " + this.service.getClass().getCanonicalName() + " using proxy ");
            throw ite.getCause();
        }
    }
}

