/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.scope.impl;

import java.util.Map;
import org.gcube.common.scope.api.ServiceMap;
import org.gcube.common.scope.impl.ServiceMapScanner;
import org.gcube.common.security.ContextBean;
import org.gcube.common.security.providers.SecretManagerProvider;

public class ScopedServiceMap
implements ServiceMap {
    private final Map<String, ServiceMap> maps = ServiceMapScanner.maps();

    @Override
    public String scope() {
        return this.currentMap().scope();
    }

    @Override
    public String version() {
        return this.currentMap().version();
    }

    @Override
    public String endpoint(String service) throws IllegalArgumentException, IllegalStateException {
        return this.currentMap().endpoint(service);
    }

    public ServiceMap currentMap() {
        ServiceMap map;
        String currentScope = SecretManagerProvider.get().getContext();
        if (currentScope == null) {
            throw new IllegalStateException("current scope is undefined");
        }
        ContextBean bean = new ContextBean(currentScope);
        if (bean.is(ContextBean.Type.VRE)) {
            currentScope = bean.enclosingScope().toString();
        }
        if ((map = this.maps.get(currentScope)) == null) {
            throw new IllegalStateException("a map for " + currentScope + " is undefined");
        }
        return map;
    }
}

