/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.security.providers;

import org.gcube.common.security.secrets.Secret;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecretManagerProvider {
    private static final Logger logger = LoggerFactory.getLogger(SecretManagerProvider.class);
    private static final InheritableThreadLocal<Secret> thread = new InheritableThreadLocal<Secret>(){

        @Override
        protected Secret initialValue() {
            return null;
        }
    };

    public static Secret get() {
        return (Secret)thread.get();
    }

    public static void set(Secret secret) {
        Secret current = SecretManagerProvider.get();
        if (current == null) {
            thread.set(secret);
        } else {
            if (secret.getOwner().getId().compareTo(current.getOwner().getId()) != 0) {
                String msg = String.format("You are trying to set a secret for owner %s but a secret for owner %s is already set in this thread. Use reset() if you want to clear the current secret before setting a new one. If, instead, you are trying to perform a nested operation with a different owner, please use AuthorizedTask instead.", secret.getOwner(), current.getOwner());
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            if (secret.getContext().compareTo(current.getContext()) != 0) {
                String msg = String.format("You are trying to set a secret for context %s but a secret for context %s is already set in this thread. Use reset() if you want to clear the current secret before setting a new one. If, instead, you are trying to perform a nested operation in a different context, please use AuthorizedTask instead.", secret.getContext(), current.getContext());
                logger.error(msg);
                throw new IllegalStateException(msg);
            }
            if (secret.priority() > current.priority()) {
                thread.set(secret);
            } else {
                logger.warn("Ignoring secret {} with priority {} because the secret {} with higher priority {} is already set", new Object[]{secret.getClass().getSimpleName(), secret.priority(), current.getClass().getSimpleName(), current.priority()});
            }
        }
    }

    public static void reset() {
        thread.remove();
    }
}

