/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.gcube.com.fasterxml.jackson.annotation.JsonAutoDetect;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;
import org.gcube.com.fasterxml.jackson.annotation.JsonInclude;
import org.gcube.com.fasterxml.jackson.annotation.JsonProperty;
import org.gcube.common.validator.ValidationError;
import org.gcube.common.validator.Validator;
import org.gcube.common.validator.ValidatorFactory;
import org.gcube.common.validator.annotations.NotEmpty;
import org.gcube.common.validator.annotations.NotNull;
import org.gcube.smartgears.configuration.PersistenceConfiguration;
import org.gcube.smartgears.configuration.application.GCubeExclude;
import org.gcube.smartgears.configuration.application.GCubeInclude;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class ApplicationConfiguration {
    @NotNull
    String name;
    @NotNull
    String group;
    @NotNull
    String version;
    String description = "";
    @JsonIgnore
    String context;
    private boolean proxable = true;
    Set<GCubeExclude> excludes = new HashSet<GCubeExclude>();
    Set<GCubeInclude> includes = new HashSet<GCubeInclude>();
    @NotEmpty
    @JsonProperty(value="persistence")
    PersistenceConfiguration persistenceConfiguration;
    @JsonProperty(value="allowed-secrets")
    List<String> allowedSecretClasses = null;

    public Set<GCubeExclude> excludes() {
        return this.excludes;
    }

    public Set<GCubeInclude> includes() {
        return this.includes;
    }

    public String name() {
        return this.name;
    }

    public String context() {
        return this.context;
    }

    public ApplicationConfiguration excludes(GCubeExclude ... excludes) {
        this.excludes = new HashSet<GCubeExclude>(Arrays.asList(excludes));
        return this;
    }

    public ApplicationConfiguration includes(GCubeInclude ... includes) {
        this.includes = new HashSet<GCubeInclude>(Arrays.asList(includes));
        return this;
    }

    public ApplicationConfiguration allowedSecrets(String ... classNames) {
        this.allowedSecretClasses = Arrays.asList(classNames);
        return this;
    }

    public List<String> allowedSecrets() {
        return this.allowedSecretClasses;
    }

    public ApplicationConfiguration context(String context) {
        this.context = context;
        return this;
    }

    public ApplicationConfiguration name(String name) {
        this.name = name;
        return this;
    }

    public ApplicationConfiguration persistenceConfiguration(PersistenceConfiguration configuration) {
        this.persistenceConfiguration = configuration;
        return this;
    }

    public ApplicationConfiguration proxable(boolean proxable) {
        this.proxable = proxable;
        return this;
    }

    public String group() {
        return this.group;
    }

    public ApplicationConfiguration group(String group) {
        this.group = group;
        return this;
    }

    public String version() {
        return this.version;
    }

    public ApplicationConfiguration version(String version) {
        this.version = version;
        return this;
    }

    public String description() {
        return this.description;
    }

    public ApplicationConfiguration description(String description) {
        this.description = description;
        return this;
    }

    public boolean proxable() {
        return this.proxable;
    }

    public PersistenceConfiguration persistenceConfiguration() {
        return this.persistenceConfiguration;
    }

    public void validate() {
        ArrayList<String> msgs = new ArrayList<String>();
        Validator validator = ValidatorFactory.validator();
        for (ValidationError error : validator.validate((Object)this)) {
            msgs.add(error.toString());
        }
        if (!this.excludes().isEmpty() && !this.includes().isEmpty()) {
            msgs.add("exclude tags and includes tags are mutually exclusive");
        }
        if (!msgs.isEmpty()) {
            throw new IllegalStateException("invalid configuration: " + String.valueOf(msgs));
        }
    }

    public int hashCode() {
        return Objects.hash(this.description, this.excludes, this.group, this.includes, this.name, this.proxable, this.version, this.allowedSecretClasses);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationConfiguration other = (ApplicationConfiguration)obj;
        return Objects.equals(this.description, other.description) && Objects.equals(this.excludes, other.excludes) && Objects.equals(this.group, other.group) && Objects.equals(this.includes, other.includes) && Objects.equals(this.name, other.name) && this.proxable == other.proxable && Objects.equals(this.version, other.version);
    }

    public String toString() {
        return "ApplicationConfiguration [name=" + this.name + ", group=" + this.group + ", version=" + this.version + ", description=" + this.description + ", context=" + this.context + ", proxable=" + this.proxable + ", excludes=" + String.valueOf(this.excludes) + ", includes=" + String.valueOf(this.includes) + ", persistenceConfiguration=" + String.valueOf(this.persistenceConfiguration) + ", allowedSecretClasses=" + String.valueOf(this.allowedSecretClasses) + "]";
    }
}

