/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.smartgears.configuration.application;

import java.util.LinkedList;
import java.util.List;
import org.gcube.smartgears.handlers.application.ApplicationLifecycleHandler;
import org.gcube.smartgears.handlers.application.RequestHandler;

public class ApplicationHandlers {
    private List<ApplicationLifecycleHandler> lifecycleHandlers = new LinkedList<ApplicationLifecycleHandler>();
    private List<RequestHandler> requestHandlers = new LinkedList<RequestHandler>();

    public ApplicationHandlers(List<ApplicationLifecycleHandler> lifecycleHandlers, List<RequestHandler> requestHandlers) {
        this.lifecycleHandlers = lifecycleHandlers;
        this.requestHandlers = requestHandlers;
    }

    public List<ApplicationLifecycleHandler> lifecycleHandlers() {
        return this.lifecycleHandlers;
    }

    public ApplicationHandlers setLifecycleHandlers(List<ApplicationLifecycleHandler> handlers) {
        this.lifecycleHandlers = handlers;
        return this;
    }

    public List<RequestHandler> requestHandlers() {
        return this.requestHandlers;
    }

    public ApplicationHandlers setRequetHandlers(List<RequestHandler> handlers) {
        this.requestHandlers = handlers;
        return this;
    }

    public void mergeWith(ApplicationHandlers other) {
        List<ApplicationLifecycleHandler> lifecycles = other.lifecycleHandlers();
        for (ApplicationLifecycleHandler handler : lifecycles) {
            if (this.lifecycleHandlers().contains(handler)) continue;
            this.lifecycleHandlers().add(handler);
        }
        List<RequestHandler> requests = other.requestHandlers();
        for (RequestHandler handler : requests) {
            if (this.requestHandlers().contains(handler)) continue;
            this.requestHandlers().add(handler);
        }
    }
}

