/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.io.jsonwebtoken.impl.io;

import java.io.OutputStream;
import org.gcube.io.jsonwebtoken.impl.io.FilteredOutputStream;
import org.gcube.io.jsonwebtoken.io.EncodingException;
import org.gcube.io.jsonwebtoken.lang.Assert;

public class EncodingOutputStream
extends FilteredOutputStream {
    private final String codecName;
    private final String name;

    public EncodingOutputStream(OutputStream out, String codecName, String name) {
        super(out);
        this.codecName = (String)Assert.hasText((CharSequence)codecName, (String)"codecName cannot be null or empty.");
        this.name = (String)Assert.hasText((CharSequence)name, (String)"name cannot be null or empty.");
    }

    @Override
    protected void onThrowable(Throwable t) {
        String msg = "Unable to " + this.codecName + "-encode " + this.name + ": " + t.getMessage();
        throw new EncodingException(msg, t);
    }
}

