/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ReflectionUtility {
    private static void checkDirectory(File directory, String pckgname, List<Class<?>> classes) throws ClassNotFoundException {
        String[] files;
        if (directory.exists() && directory.isDirectory() && (files = directory.list()) != null) {
            for (String file : files) {
                if (file.endsWith(".class")) {
                    try {
                        classes.add(Class.forName(pckgname + "." + file.substring(0, file.length() - 6)));
                    }
                    catch (NoClassDefFoundError noClassDefFoundError) {}
                    continue;
                }
                File tmpDirectory = new File(directory, file);
                if (!tmpDirectory.isDirectory()) continue;
                ReflectionUtility.checkDirectory(tmpDirectory, pckgname + "." + file, classes);
            }
        }
    }

    private static void checkJarFile(JarURLConnection connection, String pckgname, List<Class<?>> classes) throws ClassNotFoundException, IOException {
        JarFile jarFile = connection.getJarFile();
        Enumeration<JarEntry> entries = jarFile.entries();
        JarEntry jarEntry = null;
        while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
            String name = jarEntry.getName();
            if (!name.contains(".class") || !(name = name.substring(0, name.length() - 6).replace('/', '.')).contains(pckgname)) continue;
            classes.add(Class.forName(name));
        }
    }

    public static List<Class<?>> getClassesForPackage(Package packageObject) throws ClassNotFoundException {
        return ReflectionUtility.getClassesForPackage(packageObject.getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> getClassesForPackage(String pckgname) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        try {
            ClassLoader cld = Thread.currentThread().getContextClassLoader();
            if (cld == null) {
                throw new ClassNotFoundException("Can't get class loader.");
            }
            Enumeration<URL> resources = cld.getResources(pckgname.replace('.', '/'));
            URL url = null;
            while (resources.hasMoreElements() && (url = resources.nextElement()) != null) {
                try {
                    URLConnection connection = url.openConnection();
                    if (connection instanceof JarURLConnection) {
                        JarURLConnection lConnection = (JarURLConnection)connection;
                        ReflectionUtility.checkJarFile(lConnection, pckgname, classes);
                        continue;
                    }
                    if (!ReflectionUtility.isFileURLConnection(connection, url)) throw new ClassNotFoundException(pckgname + " (" + url.getPath() + ") does not appear to be a valid package. Connection type: " + connection.getClass().getName());
                    try {
                        ReflectionUtility.checkDirectory(new File(URLDecoder.decode(url.getPath(), "UTF-8")), pckgname, classes);
                    }
                    catch (UnsupportedEncodingException ex) {
                        throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Unsupported encoding)", ex);
                    }
                }
                catch (IOException ioex) {
                    throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
                    return classes;
                }
            }
        }
        catch (NullPointerException ex) {
            throw new ClassNotFoundException(pckgname + " does not appear to be a valid package (Null pointer exception)", ex);
        }
        catch (IOException ioex) {
            throw new ClassNotFoundException("IOException was thrown when trying to get all resources for " + pckgname, ioex);
        }
    }

    private static boolean isFileURLConnection(URLConnection connection, URL url) {
        String connectionClassName = connection.getClass().getName();
        String urlProtocol = url.getProtocol();
        if ("file".equals(urlProtocol)) {
            return connectionClassName.contains("FileURLConnection") || connectionClassName.equals("sun.net.www.protocol.file.FileURLConnection") || connectionClassName.endsWith("FileURLConnection");
        }
        return false;
    }
}

