/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.informationsystem.utils;

import java.util.regex.Pattern;
import org.gcube.com.fasterxml.jackson.annotation.JsonIgnore;

public final class Version
implements Comparable<Version> {
    public static final String VERSION_REGEX = "^[1-9][0-9]{0,}\\.(0|([1-9][0-9]{0,}))\\.(0|([1-9][0-9]{0,}))$";
    private static final Pattern VERSION_PATTERN = Pattern.compile("^[1-9][0-9]{0,}\\.(0|([1-9][0-9]{0,}))\\.(0|([1-9][0-9]{0,}))$");
    public static final String MINIMAL_VERSION_STRING = "1.0.0";
    public static final Version MINIMAL_VERSION = new Version("1.0.0");
    public static final String MINIMAL_VERSION_DESCRIPTION = "First Version";
    @JsonIgnore
    protected int major;
    @JsonIgnore
    protected int minor;
    @JsonIgnore
    protected int revision;

    protected Version() {
    }

    public Version(String version) {
        this.setVersion(version);
    }

    public Version(int major, int minor, int revision) {
        this.major = major;
        this.minor = minor;
        this.revision = revision;
        this.check();
    }

    public void setVersion(String version) {
        if (!VERSION_PATTERN.matcher(version).matches()) {
            throw new RuntimeException("The provided version (i.e. " + version + ") MUST respect the regex ^[1-9][0-9]{0,}\\.(0|([1-9][0-9]{0,}))\\.(0|([1-9][0-9]{0,}))$");
        }
        String[] parts = version.split("\\.");
        this.major = Integer.valueOf(parts[0]);
        this.minor = Integer.valueOf(parts[1]);
        this.revision = Integer.valueOf(parts[2]);
        this.check();
    }

    protected void check() {
        if (this.compareTo(MINIMAL_VERSION) < 0) {
            throw new RuntimeException("Minimal Allowed version is 1.0.0");
        }
    }

    public int getMajor() {
        return this.major;
    }

    protected void setMajor(int major) {
        this.major = major;
    }

    public int getMinor() {
        return this.minor;
    }

    protected void setMinor(int minor) {
        this.minor = minor;
    }

    public int getRevision() {
        return this.revision;
    }

    protected void setRevision(int revision) {
        this.revision = revision;
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.revision;
    }

    @Override
    public int compareTo(Version other) {
        if (other == null) {
            return 1;
        }
        int compare = Integer.compare(this.major, other.major);
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(this.minor, other.minor);
        if (compare != 0) {
            return compare;
        }
        compare = Integer.compare(this.revision, other.revision);
        return compare;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.revision;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.revision == other.revision;
    }
}

