/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.vomanagement.security.configuration.client;

import java.rmi.Remote;
import java.util.Iterator;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.client.Stub;
import org.apache.axis.message.SOAPHeaderElement;
import org.gcube.common.core.security.GCUBESecurityManager;
import org.gcube.common.core.security.context.SecurityContextFactory;
import org.gcube.common.vomanagement.security.authorisation.core.impl.SAMLSecurityCredentials;
import org.gcube.common.vomanagement.security.authorisation.handlers.utils.SAMLAuthzAssertionTokenBuilder;
import org.gcube.common.vomanagement.security.authorisation.utils.AssertionGenerator;
import org.gcube.common.vomanagement.security.configuration.client.GCUBESamlAssertionClientSecurityManager;
import org.globus.wsrf.impl.security.authentication.Constants;
import org.globus.wsrf.impl.security.authorization.HostAuthorization;
import org.opensaml.SAMLAssertion;

public class GCUBESamlAssertionAutoInsertClientSecurityManager
extends GCUBESamlAssertionClientSecurityManager {
    @Override
    public void setSecurity(Remote s, GCUBESecurityManager.AuthMode e, GCUBESecurityManager.DelegationMode d) throws Exception {
        this.logger.debug((Object)("setting security parameters for client " + this.identity));
        if (this.isSecurityEnabled()) {
            Stub stub = (Stub)s;
            stub._setProperty("org.globus.gsi.credentials", (Object)SecurityContextFactory.getInstance().getSecurityContext().getDefaultCredentials());
            SAMLSecurityCredentials credentials = (SAMLSecurityCredentials)this.getCredentials();
            if (credentials != null && credentials.getAssertion() != null) {
                this.logger.debug((Object)"setting SAML assertion");
                this.insertAssertion(stub, credentials);
                this.logger.debug((Object)"SAML assertion set");
            } else {
                this.logger.error((Object)"credentials or assertion not found");
            }
            String authMethodString = null;
            if (this.authMethod == GCUBESecurityManager.AuthMethod.GSI_CONV) {
                this.logger.debug((Object)"GSI Secure conversation");
                authMethodString = "org.globus.security.secConv.msg.type";
                this.logger.debug((Object)"Setting delegation...");
                this.logger.debug((Object)("delegation " + e));
                switch (d) {
                    case FULL: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsifull");
                        break;
                    }
                    case LIMITED: {
                        stub._setProperty("org.globus.security.authorization", (Object)HostAuthorization.getInstance());
                        stub._setProperty("org.globus.gsi.mode", (Object)"gsilimited");
                    }
                }
            } else {
                this.logger.debug((Object)"GSI Secure transport");
                authMethodString = "org.globus.security.transport.type";
            }
            switch (e) {
                case INTEGRITY: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    break;
                }
                case PRIVACY: {
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                    break;
                }
                case BOTH: {
                    stub._setProperty(authMethodString, (Object)Constants.SIGNATURE);
                    stub._setProperty(authMethodString, (Object)Constants.ENCRYPTION);
                }
            }
            this.logger.debug((Object)("Setting authentication GSI sec transport= " + e.name() + " on " + stub.getClass().getSimpleName()));
        } else {
            this.logger.debug((Object)"Security not enabled, nothing to do");
        }
    }

    private void insertAssertion(Stub stub, SAMLSecurityCredentials credentials) throws Exception {
        this.logger.debug((Object)"Inserting SAML Assertion inside the header");
        org.apache.axis.message.SOAPEnvelope envelope = new org.apache.axis.message.SOAPEnvelope();
        SAMLAuthzAssertionTokenBuilder builder = new SAMLAuthzAssertionTokenBuilder(credentials.getAssertion());
        SOAPMessage newM = builder.buildMessage((SOAPEnvelope)envelope);
        Iterator headers = newM.getSOAPHeader().getChildElements();
        SOAPHeaderElement wssSecurity = null;
        while (headers.hasNext() && wssSecurity == null) {
            SOAPHeaderElement element = (SOAPHeaderElement)headers.next();
            if (!element.getNodeName().equals("wsse:Security")) continue;
            wssSecurity = element;
            stub.setHeader(wssSecurity);
        }
        this.logger.debug((Object)"SAML Assertion inside the header inserted");
    }

    public static void main(String[] args) throws Exception {
        AssertionGenerator samlAssertionGenerator = new AssertionGenerator();
        samlAssertionGenerator.setLifetimeSec(5000);
        samlAssertionGenerator.setUserId("ciro");
        samlAssertionGenerator.addRole("admin");
        SAMLAssertion assertion = samlAssertionGenerator.generate();
        org.apache.axis.message.SOAPEnvelope envelope = new org.apache.axis.message.SOAPEnvelope();
        SAMLAuthzAssertionTokenBuilder builder = new SAMLAuthzAssertionTokenBuilder(assertion);
        SOAPMessage newM = builder.buildMessage((SOAPEnvelope)envelope);
        Iterator headers = newM.getSOAPHeader().getChildElements();
        while (headers.hasNext()) {
            SOAPElement element = (SOAPElement)headers.next();
            System.out.println(element.getNodeName());
            System.out.println(element.getClass());
        }
    }
}

