/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.utils;

import java.io.File;
import java.io.FileReader;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.soap.SOAPException;
import org.apache.axis.message.SOAPHeaderElement;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Utils {
    public static final String SERVICE_PROPERTIES = "serviceSecurityProperties.props";
    public static final String SECURITY_TOKEN = "SECURITY_TOKEN";
    public static final String BINARY_SECURITY_TOKEN_LABEL = "BinarySecurityToken";
    public static final String BINARY_SECURITY_TOKEN_PREFIX = "wsse";
    public static final String WSSE_NAMESPACE = "http://schemas.xmlsoap.org/ws/2002/04/secext";
    public static final String VALUE_TYPE_LABEL = "ValueType";
    public static final String ENCODING_TYPE_LABEL = "EncodingType";
    public static final String BASE64 = "wsse:Base64Binary";
    public static final String ID_LABEL = "Id";
    public static final String SECURITY_TOKEN_ATTR = "SecurityToken";

    public static void setServiceProperties(GCUBEServiceContext ctxt, String serviceName) {
        GCUBELog log = new GCUBELog(Utils.class);
        Properties properties = null;
        log.debug((Object)("Service name " + serviceName));
        try {
            File servicePropertiesFile = ctxt.getFile(SERVICE_PROPERTIES, new boolean[]{false});
            log.debug((Object)("Service Property file = " + servicePropertiesFile));
            if (servicePropertiesFile != null && servicePropertiesFile.exists()) {
                properties = new Properties();
                properties.load(new FileReader(servicePropertiesFile));
            }
        }
        catch (Exception e) {
            log.debug((Object)"Unable to load local property file");
        }
        if (properties != null) {
            ConfigurationManager.getInstance().setServiceProperties(serviceName, properties);
        }
    }

    public static Element generateBinaryTokenElement(String type, String binaryTokenValue) throws Exception {
        GCUBELog log = new GCUBELog(Utils.class);
        log.debug((Object)"Generating token SOAP element");
        log.debug((Object)("Type = " + type));
        log.debug((Object)("Value = " + binaryTokenValue));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document tokenDocument = builder.newDocument();
        Element tokenElement = tokenDocument.createElementNS(WSSE_NAMESPACE, "wsse:BinarySecurityToken");
        tokenElement.setAttribute(VALUE_TYPE_LABEL, type);
        tokenElement.setAttribute(ENCODING_TYPE_LABEL, BASE64);
        tokenElement.setAttribute(ID_LABEL, SECURITY_TOKEN);
        tokenElement.setTextContent(binaryTokenValue);
        log.debug((Object)"Header completed");
        return tokenElement;
    }

    public static SOAPHeaderElement generateSoapHeaderBinaryTokenElement(String type, String binaryTokenValue) throws SOAPException {
        GCUBELog log = new GCUBELog(Utils.class);
        log.debug((Object)"Generating token SOAP element");
        log.debug((Object)("Type = " + type));
        log.debug((Object)("Value = " + binaryTokenValue));
        SOAPHeaderElement headerElement = new SOAPHeaderElement(new QName(WSSE_NAMESPACE, "wsse:BinarySecurityToken"));
        headerElement.addAttribute(WSSE_NAMESPACE, VALUE_TYPE_LABEL, type);
        headerElement.addAttribute(WSSE_NAMESPACE, ENCODING_TYPE_LABEL, BASE64);
        headerElement.addAttribute(WSSE_NAMESPACE, ID_LABEL, SECURITY_TOKEN_ATTR);
        headerElement.setValue(binaryTokenValue);
        log.debug((Object)"Header completed");
        return headerElement;
    }
}

