/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.security.soa3.connector.integration.server;

import java.security.Provider;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.rpc.handler.MessageContext;
import org.gcube.common.core.contexts.GCUBEServiceContext;
import org.gcube.common.core.contexts.GHNContext;
import org.gcube.common.core.faults.GCUBEException;
import org.gcube.common.core.faults.GCUBEUnrecoverableException;
import org.gcube.common.core.security.GCUBEServiceAuthorizationController;
import org.gcube.common.core.security.GCUBEServiceSecurityManager;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.security.soa3.configuration.ConfigurationManagerFactory;
import org.gcube.security.soa3.configuration.GSSIntegrationInit;
import org.gcube.security.soa3.connector.GCUBESecurityController;
import org.gcube.security.soa3.connector.impl.SOA3SecurityController;
import org.gcube.security.soa3.connector.integration.utils.GSSIntegrationUtils;

public class SOA3IntegrationSecurityController
implements GCUBEServiceAuthorizationController {
    private GCUBELog log = new GCUBELog((Object)this);
    private GCUBESecurityController controller = new SOA3SecurityController();
    private boolean isSecurityEnabled = false;
    private String serviceString;

    public void initialise(GCUBEServiceContext ctxt, GCUBEServiceSecurityManager securityManager) throws Exception {
        this.log.debug((Object)"Initializing...");
        GSSIntegrationInit.init();
        String serviceName = ctxt.getName();
        String serviceClass = ctxt.getServiceClass();
        this.log.debug((Object)("Service name " + serviceName));
        this.log.debug((Object)("Service class " + serviceClass));
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("SERVICE_NAME", serviceName);
        if (!ConfigurationManagerFactory.getConfigurationManager().servicePropertiesSet(serviceName)) {
            GSSIntegrationUtils.setServiceProperties(ctxt, serviceName);
        }
        this.log.debug((Object)"Initializing the controller");
        this.isSecurityEnabled = ctxt.isSecurityEnabled();
        this.controller.init(properties);
        this.serviceString = serviceClass + ":" + serviceName;
        this.log.debug((Object)("Service string " + this.serviceString));
        this.log.debug((Object)"Init completed");
        if (this.log.isDebugEnabled()) {
            Provider[] provs;
            for (Provider p : provs = Security.getProviders()) {
                this.log.debug((Object)("name " + p.getName()));
                this.log.debug((Object)("version " + p.getVersion()));
                this.log.debug(p.getClass());
                Set<Provider.Service> services = p.getServices();
                if (services == null || services.isEmpty()) continue;
                this.log.debug((Object)"Services:");
                for (Provider.Service s : services) {
                    this.log.debug((Object)s.getAlgorithm());
                }
                this.log.debug((Object)"********************");
            }
        }
    }

    public boolean isSecurityEnabled() {
        return this.isSecurityEnabled;
    }

    public void authoriseCall(Map<String, Object> parameters) throws GCUBEException {
        this.log.debug((Object)"Checking the privileges...");
        this.log.debug((Object)"Loading GSS parameters...");
        Map headers = (Map)parameters.get("HEADERS");
        String securityHeader = (String)headers.get("BinarySecurityToken");
        MessageContext messageContext = (MessageContext)parameters.get("MESSAGE_CONTEXT");
        this.log.debug((Object)"Storing parameters...");
        HashMap<String, Object> internalParameters = new HashMap<String, Object>();
        internalParameters.put("BinarySecurityToken", securityHeader);
        internalParameters.put("PEER_SUBJECT", messageContext.getProperty("callerSubject"));
        internalParameters.put("SERVICE_STRING", this.serviceString);
        internalParameters.put("SERVICE_INSTANCE", GHNContext.getContext().getHostname());
        this.log.debug((Object)"Calling security controller");
        if (!this.controller.checkAccess(internalParameters)) {
            this.log.debug((Object)"Access not granted");
            throw new GCUBEUnrecoverableException("Security exception: the requirer is not authorized to perform the selected operation");
        }
        this.log.debug((Object)"Access granted");
        this.log.debug((Object)"Loading security token...");
        Object token = internalParameters.get("SECURITY_TOKEN");
        if (token != null) {
            messageContext.setProperty("SECURITY_TOKEN", token);
            this.log.debug((Object)"Token added to message context");
        } else {
            this.log.debug((Object)"Token not present");
        }
    }
}

