/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.um.ldap.validators;

import it.eng.rdlab.um.ldap.Utils;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LdapUserValidator {
    public static boolean validate(String dn, List<String> objectClassesList, Map<String, String> attributeMap) {
        Log log = LogFactory.getLog(LdapUserValidator.class);
        log.debug((Object)"Checking object classes list...");
        List<String> dnKeys = null;
        log.debug((Object)("Utils.parseDN(dn) -->" + Utils.parseDN(dn).size()));
        if (dn == null || (dnKeys = Utils.parseDN(dn)) == null) {
            log.error((Object)"Distinguished name not valid");
            return false;
        }
        if (objectClassesList == null || objectClassesList.size() == 0 || !objectClassesList.contains("person") || !objectClassesList.contains("inetOrgPerson")) {
            log.debug((Object)"Invalid object class list");
            return false;
        }
        log.debug((Object)"Checking user mandatory parameters dn, cn and sn");
        log.debug((Object)("DN = " + dn));
        boolean cn = attributeMap.get("cn") != null || dnKeys.contains("cn");
        boolean sn = attributeMap.get("sn") != null || dnKeys.contains("sn");
        log.debug((Object)("Common name = " + cn));
        log.debug((Object)("Surname = " + sn));
        return cn && sn;
    }
}

