/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.pm.connector.utils;

import it.eng.rdlab.soa3.pm.connector.utils.SecurityManager;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SoapUtils {
    public static String soapMessage2String(SOAPMessage soapMessage) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        soapMessage.writeTo((OutputStream)baos);
        String soapMessageString = new String(baos.toByteArray());
        return soapMessageString;
    }

    public static SOAPMessage generateSoapMessage(Document document) throws Exception {
        Log logger = LogFactory.getLog(SoapUtils.class);
        logger.debug((Object)"Generating soap message");
        Element queryElement = document.getDocumentElement();
        SOAPMessage soapmsg = MessageFactory.newInstance().createMessage();
        SOAPFactory sf = SOAPFactory.newInstance();
        SOAPElement bodyelement = sf.createElement(queryElement);
        logger.debug((Object)"Query Element added");
        soapmsg.getSOAPBody().addChildElement(bodyelement);
        soapmsg.saveChanges();
        logger.debug((Object)"Message completed");
        String soapString = SoapUtils.soapMessage2String(soapmsg);
        logger.debug((Object)("Message = " + soapString));
        return soapmsg;
    }

    public static SOAPMessage performCall(SOAPMessage message, String url) throws UnsupportedOperationException, SOAPException {
        Log logger = LogFactory.getLog(SoapUtils.class);
        logger.debug((Object)("url = " + url));
        SOAPConnection conn = SOAPConnectionFactory.newInstance().createConnection();
        if (url.startsWith("https")) {
            logger.debug((Object)"Secure url, let's add the certificates");
            try {
                SecurityManager.getInstance().loadCertificate();
            }
            catch (Exception e) {
                logger.warn((Object)"Unable to load the certificates", (Throwable)e);
            }
        }
        return conn.call(message, (Object)url);
    }

    public static void main(String[] args) throws Exception {
        CertificateFactory factory = CertificateFactory.getInstance("X.509");
        FileInputStream is = new FileInputStream("/etc/argus-security/hostcert.pem");
        X509Certificate cert = (X509Certificate)factory.generateCertificate(is);
        System.out.println(cert.getIssuerDN());
    }
}

