/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.impl;

import it.eng.rdlab.soa3.um.rest.IUserManagementService;
import it.eng.rdlab.soa3.um.rest.bean.OrganizationModel;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.soa3.um.rest.impl.GroupManagerImpl;
import it.eng.rdlab.soa3.um.rest.impl.RoleManagerImpl;
import it.eng.rdlab.soa3.um.rest.impl.UserManagerImpl;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import it.eng.rdlab.um.exceptions.GroupRetrievalException;
import it.eng.rdlab.um.exceptions.UserManagementSystemException;
import it.eng.rdlab.um.group.beans.GroupModel;
import it.eng.rdlab.um.ldap.LdapDataModelWrapper;
import it.eng.rdlab.um.ldap.data.beans.LdapOrganizationalUnitDataModel;
import it.eng.rdlab.um.ldap.data.beans.LdapOrganizationalUnitDataModelWrapper;
import it.eng.rdlab.um.ldap.group.bean.LdapOrganizationModel;
import it.eng.rdlab.um.ldap.group.bean.LdapOrganizationModelWrapper;
import it.eng.rdlab.um.ldap.group.service.LdapOrganizationManager;
import it.eng.rdlab.um.ldap.service.LdapManager;
import it.eng.rdlab.um.ldap.service.exceptions.LdapManagerException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.log4j.Logger;

public class OrganizationManagerImpl
implements IUserManagementService.OrganizationManager {
    private Logger logger;
    private String ldapUrl = null;

    public OrganizationManagerImpl(String ldapUrl) {
        this.ldapUrl = ldapUrl;
        this.logger = Logger.getLogger(this.getClass());
    }

    public String createOrganization(String organizationName, String adminUserId, String adminPassword) {
        this.logger.debug((Object)("Creating organization: " + organizationName));
        LdapOrganizationManager manager = null;
        String response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)adminPassword, (String)this.ldapUrl);
            manager = new LdapOrganizationManager(ConfigurationManager.getInstance().getLdapBase());
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            LdapOrganizationModel organization = new LdapOrganizationModel();
            if (organizationName == null) {
                organization.setOrganizationName(ConfigurationManager.getInstance().getLdapBase());
            } else {
                organization.setOrganizationName(organizationName);
            }
            String dn = Utils.organizationDNBuilder((String)organizationName);
            organization.setOrganizationDN(dn);
            boolean organizationCreation = true;
            this.logger.debug((Object)("Organization Name = " + organizationName));
            if (organizationName != null) {
                LdapOrganizationModel orgModel = new LdapOrganizationModel(Utils.organizationDNBuilder((String)organizationName), organizationName, null);
                LdapManager.getInstance().createDataElement((LdapDataModelWrapper)new LdapOrganizationModelWrapper((GroupModel)orgModel));
            }
            if (organizationCreation) {
                this.logger.debug((Object)("Organization " + organizationCreation + " created"));
                LdapOrganizationalUnitDataModel groupOuDataModel = new LdapOrganizationalUnitDataModel(Utils.generateGroupsDN((String)organizationName), "groups");
                LdapOrganizationalUnitDataModel peopleOuDataModel = new LdapOrganizationalUnitDataModel(Utils.generatePeopleDN((String)organizationName), "people");
                LdapOrganizationalUnitDataModel roleOuDataModel = new LdapOrganizationalUnitDataModel(Utils.generateRolesDN((String)organizationName), "roles");
                boolean groupCreation = LdapManager.getInstance().createDataElement((LdapDataModelWrapper)new LdapOrganizationalUnitDataModelWrapper((GroupModel)groupOuDataModel));
                this.logger.debug((Object)("Group OU creation " + groupCreation));
                boolean peopleCreation = LdapManager.getInstance().createDataElement((LdapDataModelWrapper)new LdapOrganizationalUnitDataModelWrapper((GroupModel)peopleOuDataModel));
                this.logger.debug((Object)("People OU creation " + peopleCreation));
                boolean roleCreation = LdapManager.getInstance().createDataElement((LdapDataModelWrapper)new LdapOrganizationalUnitDataModelWrapper((GroupModel)roleOuDataModel));
                this.logger.debug((Object)("Role OU creation " + roleCreation));
                response = groupCreation && peopleCreation && roleCreation ? organization.getOrganizationName() : null;
            } else {
                this.logger.debug((Object)"Unable to create a new organization");
                response = null;
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean deleteOrganization(String organizationName, String adminUserId, String adminPassword) {
        this.logger.debug((Object)("Deleting organization: " + organizationName));
        LdapOrganizationManager manager = null;
        boolean response = false;
        try {
            boolean isDeleted;
            if (!this.emptyOrganization(organizationName, adminUserId, adminPassword)) {
                this.logger.warn((Object)"Some nodes are empty or it has been impossible to delete their content");
            }
            Utils.initLdap((String)adminUserId, (String)adminPassword, (String)this.ldapUrl);
            boolean usersDeleted = LdapManager.getInstance().deleteData(Utils.generatePeopleDN((String)organizationName));
            this.logger.debug((Object)("Delete people node " + usersDeleted));
            boolean rolesDeleted = LdapManager.getInstance().deleteData(Utils.generateRolesDN((String)organizationName));
            this.logger.debug((Object)("Delete roles node " + rolesDeleted));
            boolean groupsDeleted = LdapManager.getInstance().deleteData(Utils.generateGroupsDN((String)organizationName));
            this.logger.debug((Object)("Delete groups node " + groupsDeleted));
            manager = new LdapOrganizationManager(Utils.organizationDNBuilder((String)organizationName));
            boolean bl = isDeleted = usersDeleted && rolesDeleted && groupsDeleted && manager.deleteGroup(Utils.organizationDNBuilder((String)organizationName), false);
            if (isDeleted) {
                this.logger.debug((Object)("Organization " + organizationName + "has been deleted"));
            } else {
                this.logger.debug((Object)("Organization " + organizationName + "has not been deleted"));
            }
            manager.close();
            response = isDeleted;
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
        }
        catch (UserManagementSystemException e) {
            this.logger.error((Object)"Unable to delete organization contents", (Throwable)e);
        }
        catch (GroupRetrievalException e) {
            this.logger.error((Object)"Unable to delete organization contents", (Throwable)e);
        }
        catch (LdapManagerException e) {
            this.logger.error((Object)"Unable to delete organization contents", (Throwable)e);
        }
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    private boolean emptyOrganization(String organizationName, String adminUserId, String adminPassword) {
        return new UserManagerImpl(ConfigurationManager.getInstance().getLdapUrl()).deleteUsers(organizationName, adminUserId, adminPassword) & new GroupManagerImpl(ConfigurationManager.getInstance().getLdapUrl()).deleteGroups(organizationName, adminUserId, adminPassword) & new RoleManagerImpl(ConfigurationManager.getInstance().getLdapUrl()).deleteRoles(organizationName, adminUserId, adminPassword);
    }

    public int deleteOrganizations(String adminUserId, String adminPassword) {
        this.logger.debug((Object)"Deleting all organizations");
        List organizations = this.listOrganizations(adminUserId, adminPassword);
        int response = 0;
        boolean allDeleted = true;
        boolean atLeastOneDeleted = false;
        for (OrganizationModel organization : organizations) {
            String organizationName = organization.getOrganizationName();
            if (!this.emptyOrganization(organizationName, adminUserId, adminPassword)) {
                this.logger.warn((Object)"Some nodes are empty or it has been impossible to delete their content");
            }
            boolean singleResponse = this.deleteOrganization(organizationName, adminUserId, adminPassword);
            atLeastOneDeleted |= singleResponse;
            allDeleted &= singleResponse;
        }
        response = allDeleted ? 0 : (atLeastOneDeleted ? 1 : 2);
        this.logger.debug((Object)("Response " + response));
        return response;
    }

    public OrganizationModel getOrganizationByName(String organizationName, String adminUserId, String adminPassword) {
        this.logger.debug((Object)("Getting organization: " + organizationName));
        LdapOrganizationManager manager = null;
        OrganizationModel response = new OrganizationModel();
        try {
            Utils.initLdap((String)adminUserId, (String)adminPassword, (String)this.ldapUrl);
            manager = new LdapOrganizationManager(ConfigurationManager.getInstance().getLdapBase());
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            String dn = Utils.organizationDNBuilder((String)organizationName);
            GroupModel model = manager.getGroup(dn);
            response.setDescription(model.getDescription());
            response.setOrganizationId(model.getGroupId());
            response.setOrganizationName(model.getGroupName());
            return response;
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
            return null;
        }
    }

    public List<OrganizationModel> listOrganizations(String adminUserId, String adminPassword) {
        this.logger.debug((Object)"Listing all organizations");
        LdapOrganizationManager manager = null;
        ArrayList<OrganizationModel> response = null;
        try {
            Utils.initLdap((String)adminUserId, (String)adminPassword, (String)this.ldapUrl);
            manager = new LdapOrganizationManager(ConfigurationManager.getInstance().getLdapBase());
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return null;
        }
        try {
            response = new ArrayList<OrganizationModel>();
            List modelList = manager.listGroups();
            for (GroupModel currentOrganization : modelList) {
                String organizationDn = currentOrganization.getGroupId();
                this.logger.debug((Object)("Generating organization model for organization " + organizationDn));
                OrganizationModel organization = new OrganizationModel();
                organization.setParentOrganizationId(ConfigurationManager.getInstance().getLdapBase());
                organization.setDescription(organization.getDescription());
                organization.setOrganizationId(organizationDn);
                organization.setOrganizationName(organizationDn.substring(organizationDn.indexOf("=") + 1, organizationDn.indexOf(",")).trim());
                this.logger.debug((Object)"Model generated");
                response.add(organization);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean updateOrganization(OrganizationModel organization, String adminUserId, String adminPassword) {
        this.logger.debug((Object)("Updating organization: " + organization.getOrganizationName()));
        LdapOrganizationManager manager = null;
        boolean response = false;
        try {
            Utils.initLdap((String)adminUserId, (String)adminPassword, (String)this.ldapUrl);
            manager = new LdapOrganizationManager(ConfigurationManager.getInstance().getLdapBase());
        }
        catch (NamingException e) {
            this.logger.error((Object)"Connection problem to LDAP", (Throwable)e);
            return false;
        }
        try {
            LdapOrganizationModel organizationLdapModel = new LdapOrganizationModel();
            organizationLdapModel.setOrganizationDN(organization.getOrganizationId());
            organizationLdapModel.setDescription(organization.getDescription());
            response = manager.updateGroup((GroupModel)organizationLdapModel);
        }
        catch (Exception e) {
            this.logger.debug((Object)"An error occourred during the operation", (Throwable)e);
        }
        manager.close();
        this.logger.debug((Object)("Operation completed with result " + response));
        return response;
    }

    public boolean existsOrganization(String organizationName, String adminUserId, String adminPassword) {
        this.logger.debug((Object)("Checking if organization: " + organizationName + " exists"));
        boolean response = this.getOrganizationByName(organizationName, adminUserId, adminPassword) != null;
        this.logger.debug((Object)("Result " + response));
        return response;
    }
}

