/*
 * Decompiled with CFR 0.152.
 */
package it.eng.rdlab.soa3.um.rest.jaxrs;

import com.sun.jersey.api.core.HttpContext;
import it.eng.rdlab.soa3.um.rest.bean.OrganizationModel;
import it.eng.rdlab.soa3.um.rest.conf.ConfigurationManager;
import it.eng.rdlab.soa3.um.rest.exceptions.UMJSONParserException;
import it.eng.rdlab.soa3.um.rest.impl.GroupManagerImpl;
import it.eng.rdlab.soa3.um.rest.impl.OrganizationManagerImpl;
import it.eng.rdlab.soa3.um.rest.impl.RoleManagerImpl;
import it.eng.rdlab.soa3.um.rest.impl.UserManagerImpl;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.OrganizationJaxbBean;
import it.eng.rdlab.soa3.um.rest.jaxrs.bean.OrganizationsJaxbBean;
import it.eng.rdlab.soa3.um.rest.utils.Utils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;

@Path(value="/organizationmanager")
public class OrganizationManager {
    private OrganizationManagerImpl organizationManager;
    private ConfigurationManager cm;
    private Log logger = LogFactory.getLog(OrganizationManager.class);
    private UserManagerImpl userManager;
    private GroupManagerImpl groupManager;
    private RoleManagerImpl roleManager;

    public OrganizationManager() throws Exception {
        this.cm = ConfigurationManager.getInstance();
        this.organizationManager = new OrganizationManagerImpl(this.cm.getLdapUrl());
        this.groupManager = new GroupManagerImpl(this.cm.getLdapUrl());
        this.userManager = new UserManagerImpl(this.cm.getLdapUrl());
        this.roleManager = new RoleManagerImpl(this.cm.getLdapUrl());
    }

    @PUT
    @Consumes(value={"application/json"})
    @Path(value="/{organizationName}")
    public Response createOrganization(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)("Creating organization " + organizationName));
        String organization = this.organizationManager.createOrganization(organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (organization == null) {
            this.logger.error((Object)("Organization was not created" + organizationName));
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Organization:  " + organizationName + " was not created, check if the organization already exists")).build();
        }
        this.logger.debug((Object)("Organization has been created successfully " + organization));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Organization has been created successfully ").build();
    }

    @PUT
    @Consumes(value={"application/json"})
    public Response createOrganization(@Context HttpContext context) {
        return this.createOrganization(null, context);
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/{organizationName}")
    public String getOrganization(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)("getting organization " + organizationName));
        OrganizationModel organization = this.organizationManager.getOrganizationByName(organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (organization == null) {
            this.logger.error((Object)("Organization " + organizationName + " is not present "));
            return "Organization " + organizationName + " is not present";
        }
        this.logger.debug((Object)("Organization " + organizationName + " is present"));
        try {
            String response = Utils.getMapper().writeValueAsString((Object)new OrganizationJaxbBean(organization));
            return response;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get organization unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get organization unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get organization unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Path(value="/organizations")
    public String listOrganizations(@Context HttpContext context) {
        this.logger.debug((Object)"Listing all the organizations...");
        List organizations = this.organizationManager.listOrganizations(this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        Iterator organizationsIter = organizations.iterator();
        ArrayList<OrganizationJaxbBean> organizationsBean = new ArrayList<OrganizationJaxbBean>();
        while (organizationsIter.hasNext()) {
            OrganizationModel current = (OrganizationModel)organizationsIter.next();
            OrganizationJaxbBean currentBean = new OrganizationJaxbBean(current.getOrganizationName(), current.getDescription());
            organizationsBean.add(currentBean);
        }
        try {
            String response = Utils.getMapper().writeValueAsString((Object)new OrganizationsJaxbBean(organizationsBean));
            return response;
        }
        catch (JsonGenerationException e) {
            this.logger.error((Object)"get organizations unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to generate JSON ", (Throwable)e);
        }
        catch (JsonMappingException e) {
            this.logger.error((Object)"get organizations unsuccessful due to json parse error  ");
            throw new UMJSONParserException("Unable to map JSON ", (Throwable)e);
        }
        catch (IOException e) {
            this.logger.error((Object)"get organizations unsuccessful due to json parse error  ");
            throw new UMJSONParserException("IO Exception while parsing JSON ", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{organizationName}")
    public Response deleteOrganization(@PathParam(value="organizationName") String organizationName, @Context HttpContext context) {
        this.logger.debug((Object)("Deleting organization " + organizationName));
        boolean isDeleted = this.organizationManager.deleteOrganization(organizationName, this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        if (isDeleted) {
            this.logger.debug((Object)("Delete organization successful: " + isDeleted));
            return Response.status((Response.Status)Response.Status.OK).entity((Object)("organization " + organizationName + " deleted successfully ")).build();
        }
        this.logger.error((Object)"Delete organization unsuccessful ");
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("organization " + organizationName + " cannot be deleted  ")).build();
    }

    @DELETE
    @Path(value="/organizations")
    public Response deleteOrganizations(@Context HttpContext context) {
        this.logger.debug((Object)"Deleting all the organizations...");
        int isDeleted = this.organizationManager.deleteOrganizations(this.cm.getLdapUserDN(), this.cm.getLdapPwd());
        switch (isDeleted) {
            case 0: {
                this.logger.debug((Object)("Delete organization successful: " + isDeleted));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)"organizations deleted successfully ").build();
            }
            case 1: {
                this.logger.debug((Object)("Delete organization successful: " + isDeleted));
                return Response.status((Response.Status)Response.Status.OK).entity((Object)"WARN: some organizations have not been deleted ").build();
            }
        }
        this.logger.error((Object)"Delete organization unsuccessful ");
        return Response.status((Response.Status)Response.Status.NOT_MODIFIED).entity((Object)"organizations cannot be deleted  ").build();
    }
}

