/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.vomanagement.vomsapi.test;

import java.util.Properties;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.spi.RootLogger;
import org.gcube.vomanagement.vomsapi.CredentialsManager;
import org.gcube.vomanagement.vomsapi.VOMSAdmin;
import org.gcube.vomanagement.vomsapi.VOMSAttributes;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfiguration;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIConfigurationProperty;
import org.gcube.vomanagement.vomsapi.impl.VOMSAPIFactory;
import org.gcube.vomanagement.vomsapi.util.CredentialsUtil;
import org.glite.wsdl.services.org_glite_security_voms.User;
import org.glite.wsdl.services.org_glite_security_voms_service_attributes.AttributeClass;
import org.glite.wsdl.services.org_glite_security_voms_service_attributes.AttributeValue;
import org.gridforum.jgss.ExtendedGSSCredential;

public class VOMSTest {
    public static void main(String[] args) throws Exception {
        AttributeValue[] roleAttributes;
        AttributeValue[] groupAttributes;
        AttributeValue[] userAttributes;
        AttributeClass[] classes;
        BasicConfigurator.configure((Appender)new ConsoleAppender());
        RootLogger.getLogger((String)"org.gcube").setLevel(Level.DEBUG);
        RootLogger.getLogger((String)"org.glite").setLevel(Level.DEBUG);
        Properties props = new Properties();
        props.setProperty(VOMSAPIConfigurationProperty.VOMS_HOST.toString(), "voms.research-infrastructures.eu");
        props.setProperty(VOMSAPIConfigurationProperty.VO_NAME.toString(), "gCube");
        props.setProperty(VOMSAPIConfigurationProperty.CLIENT_CERT.toString(), "/home/roccetti/certs/INFNPaoloRoccetti_cert.pem");
        props.setProperty(VOMSAPIConfigurationProperty.CLIENT_KEY.toString(), "/home/roccetti/certs/INFNPaoloRoccetti_key.pem");
        props.setProperty(VOMSAPIConfigurationProperty.CLIENT_PWD.toString(), "v3nd3tt@");
        props.setProperty(VOMSAPIConfigurationProperty.RUNS_IN_WS_CORE.toString(), "false");
        props.setProperty(VOMSAPIConfigurationProperty.MYPROXY_HOST.toString(), "grids04.eng.it");
        VOMSAPIFactory factory = new VOMSAPIFactory(new VOMSAPIConfiguration(props));
        CredentialsManager credManager = factory.getCredentialsManager();
        String userName = "Alice";
        ExtendedGSSCredential creds = credManager.getPlainCredentials(userName);
        System.out.println(CredentialsUtil.stringCredentials((ExtendedGSSCredential)creds));
        String userDN = CredentialsUtil.getIdentityDN((ExtendedGSSCredential)creds);
        String userCA = CredentialsUtil.getIssuerDN((ExtendedGSSCredential)creds);
        VOMSAdmin admin = factory.getVOMSAdmin();
        String groupName = "/gCube/testGroup";
        String parentGroupName = "/gCube";
        String roleName = "testRole";
        admin.createGroup(parentGroupName, groupName);
        admin.createRole(roleName);
        User user = new User();
        user.setDN(userDN);
        user.setCA(userCA);
        user.setCN(userName);
        user.setMail(userName + "@testDomain.org");
        admin.createUser(user);
        admin.addMember(groupName, userDN, userCA);
        admin.assignRole(groupName, roleName, userDN, userCA);
        VOMSAttributes attributes = factory.getVOMSAttributes();
        attributes.createAttributeClass("testAttributeClass", "testDescription");
        System.out.println("Attribute classes: ");
        for (AttributeClass clazz : classes = attributes.listAttributeClasses()) {
            System.out.println("Class[" + clazz.getName() + "," + clazz.getDescription() + ", uniqueness: " + clazz.isUniquenessChecked() + "]");
        }
        AttributeClass attributeClass = attributes.getAttributeClass("testAttributeClass");
        AttributeValue attributeValue = new AttributeValue(attributeClass, "this field is useless", "testAttributeValue");
        attributes.setUserAttribute(user, attributeValue);
        attributes.setGroupAttribute(groupName, attributeValue);
        attributes.setRoleAttribute(groupName, roleName, attributeValue);
        System.out.println("Attributes of user DN=" + user.getDN() + ", CA=" + user.getCA());
        for (AttributeValue attribute : userAttributes = attributes.listUserAttributes(user)) {
            System.out.println("\tAttribute[class=" + attribute.getAttributeClass().getName() + ", value=" + attribute.getValue() + ",  context=" + attribute.getContext() + "]");
        }
        System.out.println("--------------");
        System.out.println("Attributes of group " + groupName);
        for (AttributeValue attribute : groupAttributes = attributes.listGroupAttributes(groupName)) {
            System.out.println("\tAttribute[class=" + attribute.getAttributeClass().getName() + ", value=" + attribute.getValue() + ",  context=" + attribute.getContext() + "]");
        }
        System.out.println("--------------");
        System.out.println("Attributes of role " + roleName + " in group " + groupName);
        for (AttributeValue attribute : roleAttributes = attributes.listRoleAttributes(groupName, roleName)) {
            System.out.println("\tAttribute[class=" + attribute.getAttributeClass().getName() + ", value=" + attribute.getValue() + ",  context=" + attribute.getContext() + "]");
        }
        System.out.println("--------------");
        attributes.deleteUserAttribute(user, attributeValue);
        attributes.deleteGroupAttribute(groupName, attributeValue);
        factory.getVOMSAttributes().deleteRoleAttribute(groupName, roleName, attributeValue);
        factory.getVOMSAttributes().deleteAttributeClass("testAttributeClass");
        admin.deleteUser(userDN, userCA);
        admin.deleteRole(roleName);
        admin.deleteGroup(groupName);
    }
}

