/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.condition.BagConditionEnvironment;
import gr.uoa.di.madgik.execution.plan.element.condition.BagConditionalElement;
import gr.uoa.di.madgik.execution.plan.element.condition.ConditionTree;
import gr.uoa.di.madgik.execution.plan.element.condition.IConditionEnvironment;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.utils.BackgroundExecution;
import gr.uoa.di.madgik.execution.utils.DataTypeUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BagPlanElement
extends PlanElementBase {
    private static final Logger logger = LoggerFactory.getLogger(BagPlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = BagPlanElement.class.getSimpleName();
    public Map<String, BagConditionalElement> ElementCollection = new HashMap<String, BagConditionalElement>();
    public boolean TerminateOnNoProgress = true;
    public ConditionTree TerminationCondition = null;
    private List<BackgroundExecution> workers = new ArrayList<BackgroundExecution>();
    private final Object synchWorker = new Object();

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element listnode = XMLUtils.GetChildElementWithName((Node)XML, (String)"list");
            if (listnode == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            List lstmembers = XMLUtils.GetChildElementsWithName((Node)listnode, (String)"bagElement");
            this.ElementCollection.clear();
            for (Element lstm : lstmembers) {
                BagConditionalElement pelem = new BagConditionalElement();
                pelem.FromXML(lstm);
                if (pelem.Element == null) {
                    throw new ExecutionSerializationException("Not valid serialization");
                }
                if (this.ElementCollection.containsKey(pelem.Element.GetName())) {
                    throw new ExecutionSerializationException("Not valid serialization");
                }
                this.ElementCollection.put(pelem.Element.GetName(), pelem);
            }
            Element terminationElem = XMLUtils.GetChildElementWithName((Node)XML, (String)"termination");
            if (terminationElem == null) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            if (!XMLUtils.AttributeExists((Element)terminationElem, (String)"onNoProgress").booleanValue()) {
                throw new ExecutionSerializationException("Not valid serialization");
            }
            this.TerminateOnNoProgress = DataTypeUtils.GetValueAsBoolean(XMLUtils.GetAttribute((Element)terminationElem, (String)"onNoProgress"));
            Element conditionnode = XMLUtils.GetChildElementWithName((Node)terminationElem, (String)"conditionTree");
            if (conditionnode != null) {
                ConditionTree nodeCondition = new ConditionTree();
                nodeCondition.FromXML(conditionnode);
                this.TerminationCondition = nodeCondition;
            } else {
                this.TerminationCondition = null;
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Bag;
    }

    @Override
    public IPlanElement Locate(String ID) {
        if (this.ID.equals(ID)) {
            return this;
        }
        for (BagConditionalElement elem : this.ElementCollection.values()) {
            IPlanElement e = elem.Element.Locate(ID);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        for (BagConditionalElement elem : this.ElementCollection.values()) {
            acts.addAll(elem.Element.LocateActionElements());
        }
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append("<list>");
        for (BagConditionalElement elem : this.ElementCollection.values()) {
            buf.append(elem.ToXML());
        }
        buf.append("</list>");
        buf.append("<termination onNoProgress=\"" + this.TerminateOnNoProgress + "\">");
        if (this.TerminationCondition != null) {
            buf.append(this.TerminationCondition.ToXML());
        }
        buf.append("</termination>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.ElementCollection == null || this.ElementCollection.size() == 0) {
            throw new ExecutionValidationException("Element collection not set");
        }
        for (Map.Entry<String, BagConditionalElement> elem : this.ElementCollection.entrySet()) {
            if (elem.getValue().Element == null) {
                throw new ExecutionValidationException("Element cannot be null");
            }
            if (!elem.getKey().equals(elem.getValue().Element.GetName())) {
                throw new ExecutionValidationException("Element key is not the same as its name");
            }
            elem.getValue().Element.Validate();
            if (elem.getValue().Condition == null) continue;
            elem.getValue().Condition.Validate();
        }
        if (this.TerminationCondition != null) {
            this.TerminationCondition.Validate();
        }
        if (!this.TerminateOnNoProgress && this.TerminationCondition == null) {
            throw new ExecutionValidationException("Termination condition must be set when termination on no progress is not set");
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[0];
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return false;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return new ArrayList<ContingencyTrigger>();
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (BagConditionalElement elem : this.ElementCollection.values()) {
            vars.addAll(elem.Element.GetModifiedVariableNames());
            if (elem.Condition == null) continue;
            vars.addAll(elem.Condition.GetModifiedVariableNames());
        }
        if (this.TerminationCondition != null) {
            vars.addAll(this.TerminationCondition.GetModifiedVariableNames());
        }
        return vars;
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        for (BagConditionalElement elem : this.ElementCollection.values()) {
            vars.addAll(elem.Element.GetNeededVariableNames());
            if (elem.Condition == null) continue;
            vars.addAll(elem.Condition.GetNeededVariableNames());
        }
        if (this.TerminationCondition != null) {
            vars.addAll(this.TerminationCondition.GetNeededVariableNames());
        }
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    private List<String> GetNodesThatCanBeExecuted(ExecutionHandle Handle, IConditionEnvironment Environment) throws ExecutionRunTimeException {
        ArrayList<String> nodes = new ArrayList<String>();
        for (Map.Entry<String, BagConditionalElement> progressNode : this.ElementCollection.entrySet()) {
            if (progressNode.getValue().Executed || progressNode.getValue().PickedForExecution || progressNode.getValue().Condition != null && !progressNode.getValue().Condition.EvaluateCondition(Handle, Environment)) continue;
            logger.debug("Adding to nodes that can be executed node " + progressNode.getKey());
            progressNode.getValue().PickedForExecution = true;
            nodes.add(progressNode.getKey());
        }
        return nodes;
    }

    private int GetNumberOfActiveWorkers() {
        int count = 0;
        for (BackgroundExecution work : this.workers) {
            if (work.ExecutionCompleted) continue;
            ++count;
        }
        return count;
    }

    private boolean TerminateBagExecution(ExecutionHandle Handle, BagConditionEnvironment bgEnv) throws ExecutionRunTimeException {
        if (this.TerminateOnNoProgress && !bgEnv.ProgressDoneInIteration) {
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "No progress made in iteration. Breaking execution"));
            }
            return true;
        }
        if (this.TerminationCondition != null && this.TerminationCondition.EvaluateCondition(Handle, bgEnv)) {
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "Termination condition was met. Breaking execution"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionInternalErrorException, ExecutionCancelException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        int TotalSteps = this.ElementCollection.size() + 2;
        logger.debug("Starting");
        this.CheckStatus(Handle);
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, TotalSteps, "Starting Execution of " + this.Name));
        }
        for (BagConditionalElement elem : this.ElementCollection.values()) {
            elem.Executed = false;
            elem.PickedForExecution = false;
        }
        BagConditionEnvironment bgenv = new BagConditionEnvironment();
        bgenv.ElementCollection = this.ElementCollection;
        bgenv.workers = this.workers;
        bgenv.ProgressDoneInIteration = true;
        int Count = 0;
        int numberOfPreviousCompletedWorkers = 0;
        this.StopClock(PlanElementBase.ClockType.Init);
        while (true) {
            this.StartClock(PlanElementBase.ClockType.Init);
            Object object = this.synchWorker;
            synchronized (object) {
                if (this.TerminateBagExecution(Handle, bgenv)) {
                    break;
                }
                List<String> NodeNamesToExecute = this.GetNodesThatCanBeExecuted(Handle, bgenv);
                this.StopClock(PlanElementBase.ClockType.Init);
                this.StartClock(PlanElementBase.ClockType.Children);
                for (String nname : NodeNamesToExecute) {
                    if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                        Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), "Starting Execution of sub element " + (Count + 1) + " of " + this.ElementCollection.size()));
                    }
                    BackgroundExecution bg = new BackgroundExecution(this.ElementCollection.get((Object)nname).Element, Handle, this.synchWorker);
                    this.workers.add(bg);
                    Thread t = new Thread(bg);
                    t.setName(BackgroundExecution.class.getName());
                    t.setDaemon(true);
                    t.start();
                    ++Count;
                }
                bgenv.ProgressDoneInIteration = this.GetNumberOfActiveWorkers() != 0;
                if (bgenv.ProgressDoneInIteration) {
                    try {
                        this.synchWorker.wait();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                int countCompleted = 0;
                for (BackgroundExecution bg : this.workers) {
                    if (bg.ExecutionCompleted) {
                        this.ElementCollection.get((Object)bg.Element.GetName()).Executed = true;
                        ++countCompleted;
                    }
                    if (bg.Error == null) continue;
                    if (bg.Error instanceof ExecutionRunTimeException) {
                        throw (ExecutionRunTimeException)bg.Error;
                    }
                    if (bg.Error instanceof ExecutionInternalErrorException) {
                        throw (ExecutionInternalErrorException)bg.Error;
                    }
                    if (bg.Error instanceof ExecutionCancelException) {
                        throw (ExecutionCancelException)bg.Error;
                    }
                    if (bg.Error instanceof ExecutionBreakException) {
                        throw (ExecutionBreakException)bg.Error;
                    }
                    ExecutionRunTimeException rt = new ExecutionRunTimeException(bg.Error.getMessage());
                    rt.SetCause(bg.Error);
                    throw rt;
                }
                this.StopClock(PlanElementBase.ClockType.Children);
                if (countCompleted > numberOfPreviousCompletedWorkers) {
                    if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                        Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1 + countCompleted, TotalSteps, "Completed Execution of a sub element (" + countCompleted + " finished of " + this.ElementCollection.size() + ")"));
                    }
                    numberOfPreviousCompletedWorkers = countCompleted;
                }
            }
        }
        this.workers.clear();
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), TotalSteps, TotalSteps, "Finishing Execution of " + this.Name));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }
}

