/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.engine.ExecutionHandle;
import gr.uoa.di.madgik.execution.event.ExecutionProgressReportStateEvent;
import gr.uoa.di.madgik.execution.exception.ExecutionBreakException;
import gr.uoa.di.madgik.execution.exception.ExecutionCancelException;
import gr.uoa.di.madgik.execution.exception.ExecutionException;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionRunTimeException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.IPlanElement;
import gr.uoa.di.madgik.execution.plan.element.PlanElementBase;
import gr.uoa.di.madgik.execution.plan.element.attachment.ExecutionAttachment;
import gr.uoa.di.madgik.execution.plan.element.contingency.ContingencyTrigger;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.invocable.BoundaryConfig;
import gr.uoa.di.madgik.execution.plan.element.invocable.BoundaryHandler;
import gr.uoa.di.madgik.execution.plan.element.variable.VariableCollection;
import gr.uoa.di.madgik.execution.utils.BoundaryIsolationInfo;
import gr.uoa.di.madgik.execution.utils.ExceptionUtils;
import gr.uoa.di.madgik.execution.utils.PlanElementUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BoundaryPlanElement
extends PlanElementBase {
    private static final Logger logger = LoggerFactory.getLogger(BoundaryPlanElement.class);
    private String ID = UUID.randomUUID().toString();
    private String Name = BoundaryPlanElement.class.getSimpleName();
    public IPlanElement Root = null;
    public List<ContingencyTrigger> Triggers = new ArrayList<ContingencyTrigger>();
    public BoundaryConfig Config = null;
    public BoundaryIsolationInfo Isolation = null;
    public List<String> CleanUpLocalFiles = new ArrayList<String>();
    public Set<ExecutionAttachment> Attachments = new HashSet<ExecutionAttachment>();

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Element XML) throws ExecutionSerializationException {
        try {
            Element confelement;
            if (!IPlanElement.PlanElementType.valueOf(XMLUtils.GetAttribute((Element)XML, (String)"type")).equals((Object)this.GetPlanElementType())) {
                throw new ExecutionSerializationException("plan element type missmatch");
            }
            this.ID = XMLUtils.GetAttribute((Element)XML, (String)"id");
            this.Name = XMLUtils.GetAttribute((Element)XML, (String)"name");
            Element rootelem = XMLUtils.GetChildElementWithName((Node)XML, (String)"planElement");
            if (rootelem == null) {
                throw new ExecutionSerializationException("not valid serialization of plan element");
            }
            this.Root = PlanElementUtils.GetPlanElement(rootelem);
            Element cont = XMLUtils.GetChildElementWithName((Node)XML, (String)"triggers");
            this.Triggers.clear();
            if (cont != null) {
                List trigs = XMLUtils.GetChildElementsWithName((Node)cont, (String)"contingency");
                for (Element trig : trigs) {
                    ContingencyTrigger t = new ContingencyTrigger();
                    t.FromXML(trig);
                    this.Triggers.add(t);
                }
            }
            if ((confelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"boundaryConfig")) == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            this.Config = new BoundaryConfig();
            this.Config.FromXML(confelement);
            Element isolationelement = XMLUtils.GetChildElementWithName((Node)XML, (String)"isolation");
            if (isolationelement == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            this.Isolation = new BoundaryIsolationInfo();
            this.Isolation.FromXML(isolationelement);
            Element cleanupElement = XMLUtils.GetChildElementWithName((Node)XML, (String)"cleanup");
            if (cleanupElement == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            List cleanupFilesElementlst = XMLUtils.GetChildElementsWithName((Node)cleanupElement, (String)"file");
            this.CleanUpLocalFiles.clear();
            for (Element cleanupFileElement : cleanupFilesElementlst) {
                if (!XMLUtils.AttributeExists((Element)cleanupFileElement, (String)"value").booleanValue()) {
                    throw new ExecutionSerializationException("not valid serialization of element");
                }
                this.CleanUpLocalFiles.add(XMLUtils.GetAttribute((Element)cleanupFileElement, (String)"value"));
            }
            Element atts = XMLUtils.GetChildElementWithName((Node)XML, (String)"attachments");
            if (atts == null) {
                throw new ExecutionSerializationException("not valid serialization of element");
            }
            List attlst = XMLUtils.GetChildElementsWithName((Node)atts, (String)"attachment");
            this.Attachments.clear();
            for (Element at : attlst) {
                ExecutionAttachment ato = new ExecutionAttachment();
                ato.FromXML(at);
                this.Attachments.add(ato);
            }
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided xml serialization", ex);
        }
    }

    @Override
    public String GetID() {
        return this.ID;
    }

    @Override
    public String GetName() {
        return this.Name;
    }

    @Override
    public IPlanElement.PlanElementType GetPlanElementType() {
        return IPlanElement.PlanElementType.Boundary;
    }

    @Override
    public IPlanElement Locate(String ID) {
        IPlanElement elem;
        if (this.ID.equals(ID)) {
            return this;
        }
        if (this.Root != null && (elem = this.Root.Locate(ID)) != null) {
            return elem;
        }
        return null;
    }

    @Override
    public Set<IPlanElement> LocateActionElements() {
        HashSet<IPlanElement> acts = new HashSet<IPlanElement>();
        if (this.Root != null) {
            acts.addAll(this.Root.LocateActionElements());
        }
        return acts;
    }

    @Override
    public void SetName(String Name) {
        this.Name = Name;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<planElement type=\"" + this.GetPlanElementType().toString() + "\" id=\"" + this.GetID() + "\" name=\"" + this.GetName() + "\">");
        buf.append(this.Root.ToXML());
        buf.append("<triggers>");
        for (ContingencyTrigger trig : this.Triggers) {
            buf.append(trig.ToXML());
        }
        buf.append("</triggers>");
        buf.append(this.Config.ToXML());
        buf.append(this.Isolation.ToXML());
        buf.append("<cleanup>");
        for (String f : this.CleanUpLocalFiles) {
            buf.append("<file name=\"" + f + "\"/>");
        }
        buf.append("</cleanup>");
        buf.append("<attachments>");
        for (ExecutionAttachment at : this.Attachments) {
            buf.append(at.ToXML());
        }
        buf.append("</attachments>");
        buf.append("</planElement>");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.Root == null) {
            throw new ExecutionValidationException("root of node not set");
        }
        if (this.Config == null) {
            throw new ExecutionValidationException("Boundary config not set");
        }
        if (this.Isolation == null) {
            throw new ExecutionValidationException("Isolation config not set");
        }
        if (this.Attachments == null) {
            throw new ExecutionValidationException("Attachments can be empty but not null");
        }
        for (ExecutionAttachment at : this.Attachments) {
            at.Validate();
        }
        this.Config.Validate();
        this.Isolation.Validate();
        if (this.CleanUpLocalFiles == null) {
            throw new ExecutionValidationException("List of local cleanup files can be empty but not null");
        }
    }

    @Override
    public void ValidatePreExecution(ExecutionHandle Handle) throws ExecutionValidationException {
        this.Validate();
        for (String f : this.CleanUpLocalFiles) {
            if (Handle.GetPlan().Variables.Contains(f)) continue;
            throw new ExecutionValidationException("Cleanup file not present in available variables");
        }
    }

    @Override
    public IContingencyReaction.ReactionType[] SupportedContingencyTriggers() {
        return new IContingencyReaction.ReactionType[]{IContingencyReaction.ReactionType.None, IContingencyReaction.ReactionType.Pick, IContingencyReaction.ReactionType.Retry};
    }

    @Override
    public boolean SupportsContingencyTriggers() {
        return true;
    }

    @Override
    public List<ContingencyTrigger> GetContingencyTriggers() {
        return this.Triggers;
    }

    @Override
    public void SetContingencyResourcePick(ExecutionHandle Handle, String Pick) throws ExecutionRunTimeException {
        try {
            String[] args = Pick.split(":");
            if (args.length != 2) {
                throw new ExecutionSerializationException("Pick resource serialization is not in the expected format");
            }
            this.Config.HostName = args[0];
            this.Config.Port = Integer.parseInt(args[1]);
            this.Config.Validate();
        }
        catch (Exception ex) {
            throw new ExecutionRunTimeException("Could not set provided picked resource (" + Pick + ") because of error (" + ex.getMessage() + ")", ex);
        }
    }

    @Override
    public Set<String> GetNeededVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Root.GetNeededVariableNames());
        vars.addAll(this.Isolation.GetNeededVariableNames());
        return vars;
    }

    @Override
    public Set<String> GetModifiedVariableNames() {
        HashSet<String> vars = new HashSet<String>();
        vars.addAll(this.Root.GetModifiedVariableNames());
        vars.addAll(this.Isolation.GetModifiedVariableNames());
        return vars;
    }

    @Override
    public Logger GetExtenderLogger() {
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ExecuteExtender(ExecutionHandle Handle) throws ExecutionRunTimeException, ExecutionCancelException, ExecutionInternalErrorException, ExecutionBreakException {
        this.StartClock(PlanElementBase.ClockType.Total);
        this.StartClock(PlanElementBase.ClockType.Init);
        try {
            this.RegisterToRunningActionElementsRestriction(Handle);
            logger.debug("Starting");
            this.CheckStatus(Handle);
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 1, 3, "Starting Execution of " + this.Name));
            }
            if (!Handle.GetPlan().Config.ChokeProgressReporting) {
                Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 2, 3, "Assembling info to forward to remote boundary element"));
            }
            BoundaryHandler handler = new BoundaryHandler(this.Root, Handle.GetPlan().Variables.Subset(this.GetNeededVariableNames()), Handle.GetPlan().EnvHints, Handle, this.GetID(), this.Name, this.Config, this.Isolation, Handle.GetPlan().Config, this.Attachments);
            this.StopClock(PlanElementBase.ClockType.Init);
            this.StartClock(PlanElementBase.ClockType.Children);
            String varsUpdate = handler.EngineSideProtocol();
            this.StopClock(PlanElementBase.ClockType.Children);
            this.StartClock(PlanElementBase.ClockType.Finilization);
            VariableCollection varsCollectionUpdate = new VariableCollection(varsUpdate);
            Handle.GetPlan().Variables.Update(varsCollectionUpdate, this.Root.GetModifiedVariableNames());
            if (handler.WeirdCompletion) {
                throw new ExecutionInternalErrorException("Boundary element completed but neither with success or with error...");
            }
            if (!handler.Completed) {
                throw new ExecutionInternalErrorException("Boundary element returned without completing");
            }
            if (handler.Completed && !handler.Successful) {
                throw new ExecutionException("Received error from " + this.Name + "(" + this.Config.HostName + ":" + this.Config.Port + ")", handler.Error);
            }
            this.StopClock(PlanElementBase.ClockType.Finilization);
        }
        catch (Exception ex) {
            ExceptionUtils.ThrowTransformedException(ex);
        }
        finally {
            this.StartClock(PlanElementBase.ClockType.Finilization);
            this.UnregisterToRunningActionElementsRestriction(Handle);
            this.CleanUpFiles();
            this.StopClock(PlanElementBase.ClockType.Finilization);
        }
        if (!Handle.GetPlan().Config.ChokeProgressReporting) {
            Handle.EmitEvent(new ExecutionProgressReportStateEvent(this.GetID(), 3, 3, "Finishing Execution of " + this.Name, this.Name, this.Config.HostName, this.Config.Port));
        }
        logger.debug("Exiting");
        this.StopClock(PlanElementBase.ClockType.Total);
        if (!Handle.GetPlan().Config.ChokePerformanceReporting) {
            Handle.EmitEvent(this.GetPerformanceEvent());
        }
    }

    private void CleanUpFiles() {
        for (String s : this.CleanUpLocalFiles) {
            try {
                String file = s;
                File f = new File(file);
                if (!f.exists() || !f.isFile()) continue;
                f.delete();
            }
            catch (Exception ex) {
                logger.warn("Could not cleanup file of variable with location " + s);
            }
        }
    }
}

