/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.execution.plan.element.contingency;

import gr.uoa.di.madgik.commons.utils.XMLUtils;
import gr.uoa.di.madgik.execution.exception.ExecutionInternalErrorException;
import gr.uoa.di.madgik.execution.exception.ExecutionSerializationException;
import gr.uoa.di.madgik.execution.exception.ExecutionValidationException;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReaction;
import gr.uoa.di.madgik.execution.plan.element.contingency.IContingencyReactionHandler;
import gr.uoa.di.madgik.execution.plan.element.contingency.ReactionRetryHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ContingencyReactionRetry
implements IContingencyReaction {
    public int NumberOfRetries = 0;
    public long RetryInterval = 0L;

    @Override
    public void FromXML(String XML) throws ExecutionSerializationException {
        Document doc = null;
        try {
            doc = XMLUtils.Deserialize((String)XML);
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
        this.FromXML(doc.getDocumentElement());
    }

    @Override
    public void FromXML(Node XML) throws ExecutionSerializationException {
        try {
            if (!(XMLUtils.AttributeExists((Element)((Element)XML), (String)"type").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"retries").booleanValue() && XMLUtils.AttributeExists((Element)((Element)XML), (String)"interval").booleanValue())) {
                throw new ExecutionSerializationException("Invalid serializatiuon provided");
            }
            if (!IContingencyReaction.ReactionType.valueOf(XMLUtils.GetAttribute((Element)((Element)XML), (String)"type")).equals((Object)this.GetReactionType())) {
                throw new ExecutionSerializationException("Invalid serializatiuon provided");
            }
            this.NumberOfRetries = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"retries"));
            this.RetryInterval = Integer.parseInt(XMLUtils.GetAttribute((Element)((Element)XML), (String)"interval"));
        }
        catch (Exception ex) {
            throw new ExecutionSerializationException("Could not deserialize provided XML serialization", ex);
        }
    }

    @Override
    public IContingencyReaction.ReactionType GetReactionType() {
        return IContingencyReaction.ReactionType.Retry;
    }

    @Override
    public String ToXML() throws ExecutionSerializationException {
        StringBuilder buf = new StringBuilder();
        buf.append("<reaction type=\"" + this.GetReactionType().toString() + "\" retries=\"" + this.NumberOfRetries + "\" interval=\"" + this.RetryInterval + "\" />");
        return buf.toString();
    }

    @Override
    public void Validate() throws ExecutionValidationException {
        if (this.NumberOfRetries == 0) {
            throw new ExecutionValidationException("Consider using ContingencyReactionNone if you want 0 retries");
        }
        if (this.RetryInterval < 0L) {
            throw new ExecutionValidationException("Retry interval must be non negative");
        }
    }

    @Override
    public IContingencyReactionHandler GetReactionHandler() throws ExecutionInternalErrorException {
        ReactionRetryHandler handler = new ReactionRetryHandler();
        handler.SetReactionToHandle(this);
        return handler;
    }
}

